/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.mixin.xplatform.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.EdibleItemPower;
import net.merchantpug.apugli.power.factory.ModifyEnchantmentLevelPowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements ItemStackAccess {
    @Unique
    private int apugli$previousDamage;
    @Unique
    public Entity apugli$entity;

    @Shadow
    public abstract Item m_41720_();

    @Shadow
    public abstract CompoundTag m_41784_();

    @Shadow
    public abstract int m_41776_();

    @Override
    public void apugli$setEntity(Entity entity) {
        this.apugli$entity = entity;
    }

    @Override
    public Entity apugli$getEntity() {
        return this.apugli$entity;
    }

    @ModifyReturnValue(method={"copy"}, at={@At(value="RETURN")})
    private ItemStack apugli$copyNewParams(ItemStack newStack) {
        Entity holder = this.apugli$entity;
        if (holder != null) {
            if (newStack.m_41619_()) {
                newStack = ModifyEnchantmentLevelPowerFactory.getWorkableEmptyStack(holder);
            } else {
                ((ItemStackAccess)newStack).apugli$setEntity(holder);
            }
        }
        return newStack;
    }

    @ModifyVariable(method={"setDamageValue"}, at=@At(value="HEAD"), argsOnly=true)
    private int apugli$captureDamageValue(int newDamage) {
        Entity entity = this.apugli$entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CompoundTag tag = this.m_41784_();
            this.apugli$previousDamage = tag.m_128425_("Damage", 3) ? tag.m_128451_("Damage") : 0;
            int removedDurability = this.apugli$previousDamage - newDamage;
            for (Object power : Services.POWER.getPowers(living, ApugliPowers.MODIFY_DURABILITY_CHANGE.get())) {
                if (!ApugliPowers.MODIFY_DURABILITY_CHANGE.get().doesApply(power, living.m_9236_(), (ItemStack)this, removedDurability)) continue;
                removedDurability = ApugliPowers.MODIFY_DURABILITY_CHANGE.get().postFunction(power, Services.PLATFORM.applyModifiers(living, ApugliPowers.MODIFY_DURABILITY_CHANGE.get(), (double)removedDurability));
            }
            return this.apugli$previousDamage - removedDurability;
        }
        return newDamage;
    }

    @Inject(method={"setDamageValue"}, at={@At(value="TAIL")})
    private void apugli$executeDurabilityChangeActions(int newDamage, CallbackInfo ci) {
        Entity entity = this.apugli$entity;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        int addedDamage = newDamage - this.apugli$previousDamage;
        Services.POWER.getPowers(living, ApugliPowers.ACTION_ON_DURABILITY_CHANGE.get()).stream().filter(p -> p.doesApply((ItemStack)this)).forEach(power -> {
            if (newDamage >= this.m_41776_()) {
                power.executeBreakAction((ItemStack)this);
            } else if (addedDamage > 0) {
                power.executeDecreaseAction((ItemStack)this);
            } else if (addedDamage < 0) {
                power.executeIncreaseAction((ItemStack)this);
            }
        });
    }

    @Inject(method={"getUseAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$getUseAction(CallbackInfoReturnable<UseAnim> cir) {
        ItemStack stack = (ItemStack)this;
        Entity entity = this.apugli$entity;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Optional<EdibleItemPower> power = Services.POWER.getPowers(living, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(living.m_9236_(), stack)).findFirst();
        power.ifPresent(edibleItemPower -> cir.setReturnValue((Object)(edibleItemPower.getUseAction().equals((Object)EdibleItemPower.EatAnimation.DRINK) ? UseAnim.DRINK : UseAnim.EAT)));
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$getMaxUseTime(CallbackInfoReturnable<Integer> cir) {
        ItemStack stack = (ItemStack)this;
        Entity entity = this.apugli$entity;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Optional<EdibleItemPower> power = Services.POWER.getPowers(living, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(living.m_9236_(), stack)).findFirst();
        power.ifPresent(edibleItemPower -> cir.setReturnValue((Object)(edibleItemPower.getFoodComponent().m_38748_() ? 16 : 32)));
    }
}

