/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.integration.pehkui;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.integration.pehkui.ApoliScaleModifier;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Math;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

public class DelayedApoliScaleModifier<P>
extends ApoliScaleModifier<P> {
    private int ticks;
    private final int baseMaxTicks;
    private int maxTicks;
    protected final List<?> delayModifiers;
    private Map<ResourceLocation, Double> previousResourceValues = new HashMap<ResourceLocation, Double>();
    private Map<Integer, Map<ResourceLocation, Double>> inBetweenResourceValues = new HashMap<Integer, Map<ResourceLocation, Double>>();
    private Map<ResourceLocation, Double> targetResourceValues = new HashMap<ResourceLocation, Double>();
    protected final Optional<ResourceLocation> easing;
    protected final Map<ResourceLocation, Float> cachedPreviousScales = new HashMap<ResourceLocation, Float>();
    protected final Map<ResourceLocation, Float> cachedPreviousPreviousScales = new HashMap<ResourceLocation, Float>();
    private final Map<ResourceLocation, Map<Integer, Map<Float, Float>>> reachedScales = new HashMap<ResourceLocation, Map<Integer, Map<Float, Float>>>();
    private final Map<ResourceLocation, Map<Integer, Float>> reachedPreviousScales = new HashMap<ResourceLocation, Map<Integer, Float>>();
    private final ResourceLocation tickUpdateScaleTypeId;
    private float tickUpdatePrevious;
    private float tickUpdateTarget;

    public DelayedApoliScaleModifier(P power, LivingEntity entity, List<?> modifiers, List<?> delayModifiers, int maxTicks, Set<ResourceLocation> cachedScaleIds, int powerPriority, Optional<ResourceLocation> easing) {
        super(power, entity, modifiers, cachedScaleIds, powerPriority);
        this.delayModifiers = ImmutableList.copyOf(delayModifiers);
        this.baseMaxTicks = (int)Services.PLATFORM.applyModifiers((Entity)this.owner, this.delayModifiers, (double)maxTicks);
        this.ticks = 0;
        this.maxTicks = maxTicks;
        this.easing = easing;
        this.tickUpdateScaleTypeId = (ResourceLocation)this.getCachedScaleIds().stream().findFirst().orElseThrow();
        if (entity != null) {
            this.tickUpdateTarget = !Services.POWER.isActive(this.power, entity) ? PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((Entity)entity).getBaseScale() : (float)Services.PLATFORM.applyModifiers((Entity)entity, this.modifiers, (double)PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((Entity)entity).getBaseScale());
            this.tickUpdatePrevious = PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((Entity)entity).getBaseScale();
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getClampedTicks() {
        return Mth.m_14045_((int)this.ticks, (int)0, (int)this.getMaxTicks());
    }

    public void setTicks(int value) {
        this.ticks = Mth.m_14045_((int)value, (int)0, (int)this.getMaxTicks());
    }

    protected boolean isMax() {
        return this.ticks >= this.getMaxTicks();
    }

    protected boolean isMin() {
        return this.ticks <= 0;
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        ListTag previousResourceValuesTag;
        CompoundTag entryTag;
        tag.m_128405_("MaxTicks", this.getMaxTicks());
        tag.m_128405_("Ticks", this.getClampedTicks());
        super.serialize(tag);
        if (!this.cachedPreviousScales.isEmpty()) {
            ListTag cachedPreviousScalesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Float> entry : this.cachedPreviousScales.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Type", entry.getKey().toString());
                entryTag.m_128350_("Value", entry.getValue().floatValue());
                cachedPreviousScalesTag.add((Object)entryTag);
            }
            tag.m_128365_("PreviousScales", (Tag)cachedPreviousScalesTag);
        }
        if (!this.cachedPreviousPreviousScales.isEmpty()) {
            ListTag cachedPreviousPreviousScalesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Float> entry : this.cachedPreviousPreviousScales.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Type", entry.getKey().toString());
                entryTag.m_128350_("Value", entry.getValue().floatValue());
                cachedPreviousPreviousScalesTag.add((Object)entryTag);
            }
            tag.m_128365_("PreviousPreviousScales", (Tag)cachedPreviousPreviousScalesTag);
        }
        if (!this.targetResourceValues.isEmpty()) {
            ListTag targetResourceValuesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Number> entry : this.targetResourceValues.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Resource", entry.getKey().toString());
                entryTag.m_128347_("Value", ((Double)entry.getValue()).doubleValue());
                targetResourceValuesTag.add((Object)entryTag);
            }
            tag.m_128365_("TargetResourceValues", (Tag)targetResourceValuesTag);
        }
        if (!this.previousResourceValues.isEmpty()) {
            previousResourceValuesTag = new ListTag();
            for (Map.Entry<ResourceLocation, Number> entry : this.previousResourceValues.entrySet()) {
                entryTag = new CompoundTag();
                entryTag.m_128359_("Resource", entry.getKey().toString());
                entryTag.m_128347_("Value", ((Double)entry.getValue()).doubleValue());
                previousResourceValuesTag.add((Object)entryTag);
            }
            tag.m_128365_("PreviousResourceValues", (Tag)previousResourceValuesTag);
        }
        if (!this.inBetweenResourceValues.isEmpty()) {
            previousResourceValuesTag = new ListTag();
            for (Map.Entry<Object, Object> entry : this.inBetweenResourceValues.entrySet()) {
                if (((Map)entry.getValue()).isEmpty()) continue;
                entryTag = new CompoundTag();
                ListTag valuesTag = new ListTag();
                for (Map.Entry innerEntry : ((Map)entry.getValue()).entrySet()) {
                    CompoundTag innerEntryTag = new CompoundTag();
                    innerEntryTag.m_128359_("Resource", ((ResourceLocation)innerEntry.getKey()).toString());
                    innerEntryTag.m_128347_("Value", ((Double)innerEntry.getValue()).doubleValue());
                    valuesTag.add((Object)innerEntryTag);
                }
                entryTag.m_128359_("Ticks", ((Integer)entry.getKey()).toString());
                entryTag.m_128365_("Values", (Tag)valuesTag);
                previousResourceValuesTag.add((Object)entryTag);
            }
            tag.m_128365_("InBetweenResourceValues", (Tag)previousResourceValuesTag);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag, boolean initialize) {
        CompoundTag entryTag;
        int i;
        ListTag listTag;
        this.maxTicks = tag.m_128451_("MaxTicks");
        this.setTicks(tag.m_128451_("Ticks"));
        super.deserialize(tag, false);
        this.cachedPreviousScales.clear();
        if (tag.m_128425_("PreviousScales", 9)) {
            listTag = tag.m_128437_("PreviousScales", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.m_128728_(i);
                this.cachedPreviousScales.put(new ResourceLocation(entryTag.m_128461_("Type")), Float.valueOf(entryTag.m_128457_("Value")));
            }
        }
        this.cachedPreviousPreviousScales.clear();
        if (tag.m_128425_("PreviousPreviousScales", 9)) {
            listTag = tag.m_128437_("PreviousPreviousScales", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.m_128728_(i);
                this.cachedPreviousPreviousScales.put(new ResourceLocation(entryTag.m_128461_("Type")), Float.valueOf(entryTag.m_128457_("Value")));
            }
        }
        this.targetResourceValues.clear();
        if (tag.m_128425_("TargetResourceValues", 9)) {
            listTag = tag.m_128437_("TargetResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.m_128728_(i);
                this.targetResourceValues.put(new ResourceLocation(entryTag.m_128461_("Resource")), entryTag.m_128459_("Value"));
            }
        }
        this.previousResourceValues.clear();
        if (tag.m_128425_("PreviousResourceValues", 9)) {
            listTag = tag.m_128437_("PreviousResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.m_128728_(i);
                this.previousResourceValues.put(new ResourceLocation(entryTag.m_128461_("Resource")), entryTag.m_128459_("Value"));
            }
        }
        this.inBetweenResourceValues.clear();
        if (tag.m_128425_("InBetweenResourceValues", 9)) {
            listTag = tag.m_128437_("InBetweenResourceValues", 10);
            for (i = 0; i < listTag.size(); ++i) {
                entryTag = listTag.m_128728_(i);
                HashMap<ResourceLocation, Double> values = new HashMap<ResourceLocation, Double>();
                ListTag valuesTag = entryTag.m_128437_("Values", 10);
                for (int j = 0; j < valuesTag.size(); ++j) {
                    CompoundTag innerTag = listTag.m_128728_(j);
                    values.put(new ResourceLocation(entryTag.m_128461_("Resource")), entryTag.m_128459_("Value"));
                }
                this.inBetweenResourceValues.put(entryTag.m_128451_("Ticks"), values);
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.cachedPreviousScales.clear();
        this.cachedPreviousPreviousScales.clear();
        this.reachedScales.clear();
        this.reachedPreviousScales.clear();
        this.targetResourceValues.clear();
        this.previousResourceValues.clear();
        this.inBetweenResourceValues.clear();
    }

    @Override
    public void tick(LivingEntity entity) {
        boolean updateMaxTicks = false;
        boolean isActive = Services.POWER.isActive(this.power, entity);
        for (ResourceLocation typeId : this.cachedScaleIds) {
            float value;
            ScaleData data = ((ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)typeId)).getScaleData((Entity)entity);
            float f = value = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers((Entity)entity, this.modifiers, (double)data.getBaseScale());
            if (DelayedApoliScaleModifier.compareFloats(this.checkScales.getOrDefault(typeId, Float.valueOf(data.getBaseScale())).floatValue(), value)) continue;
            updateMaxTicks = true;
            this.checkScales.put(typeId, Float.valueOf(value));
            this.markForUpdating(typeId, false);
        }
        if (updateMaxTicks) {
            Map<Object, Double> newPrevious = this.targetResourceValues.isEmpty() ? Services.POWER.getClosestToBaseScale(entity, this.modifiers, 1.0) : (this.ticks == this.maxTicks ? this.targetResourceValues : (Map<Object, Double>)this.inBetweenResourceValues.entrySet().stream().filter(entry -> (Integer)entry.getKey() < this.ticks).max(Comparator.comparing(entry -> Mth.m_14040_((int)((Integer)entry.getKey() - this.ticks)))).map(Map.Entry::getValue).orElse(new HashMap()));
            this.targetResourceValues = Services.POWER.iterateThroughModifierForResources(entity, this.modifiers);
            this.inBetweenResourceValues = Services.POWER.getInBetweenResources(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
            this.previousResourceValues = newPrevious;
            this.maxTicks = (int)Services.POWER.addAllInBetweensOfResourceModifiers(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
            ScaleData data = PehkuiUtil.getScaleType(this.tickUpdateScaleTypeId).getScaleData((Entity)entity);
            float currentScale = this.isMin() ? this.tickUpdatePrevious : (this.isMax() ? this.tickUpdateTarget : this.calculateScale(data, this.tickUpdateScaleTypeId, 1.0f, this.tickUpdateTarget, this.tickUpdatePrevious));
            this.tickUpdatePrevious = this.tickUpdateTarget;
            this.tickUpdateTarget = !isActive ? data.getBaseScale() : (float)Services.PLATFORM.applyModifiers((Entity)entity, this.modifiers, (double)data.getBaseScale());
            float slope = (float)this.getMaxTicks() / (this.tickUpdateTarget - this.tickUpdatePrevious);
            this.setTicks(Math.round((float)(slope * (currentScale - this.tickUpdatePrevious))));
            this.shouldUpdate = true;
            this.shouldUpdatePrevious = true;
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
            return;
        }
        int modifiedDelay = (int)Services.POWER.addAllInBetweensOfResourceModifiers(entity, this.modifiers, this.delayModifiers, this.baseMaxTicks, this.previousResourceValues);
        if (this.maxTicks != modifiedDelay) {
            int inbetween = modifiedDelay - this.maxTicks;
            this.ticks += inbetween;
            this.maxTicks += inbetween;
            Services.POWER.syncPower(entity, this.power);
        }
        if (this.getClampedTicks() < this.getMaxTicks()) {
            this.setTicks(this.getClampedTicks() + 1);
            this.shouldUpdate = true;
            this.shouldUpdatePrevious = true;
            Services.POWER.syncPower(entity, this.power);
            this.updateOthers(entity);
        }
    }

    @Override
    protected void markForUpdating(ResourceLocation typeId, boolean notOriginalCall) {
        super.markForUpdating(typeId, notOriginalCall);
        if (notOriginalCall) {
            this.cachedPreviousScales.clear();
            this.cachedPreviousPreviousScales.clear();
        }
    }

    @Override
    public float modifyScale(ScaleData scaleData, float modifiedScale, float delta) {
        Entity entity = scaleData.getEntity();
        if (!(entity instanceof LivingEntity)) {
            this.logWarn();
            return modifiedScale;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ResourceLocation scaleTypeId = this.getResourceLocationFromScaleData(scaleData);
        boolean isActive = Services.POWER.isActive(this.power, entity2);
        if (this.shouldUpdateModifiers.contains(scaleTypeId)) {
            float target = !isActive ? modifiedScale : (float)Services.PLATFORM.applyModifiers((Entity)entity2, this.modifiers, (double)modifiedScale);
            float previous = this.cachedTargetScales.getOrDefault(scaleTypeId, Float.valueOf(modifiedScale)).floatValue();
            this.cachedTargetScales.put(scaleTypeId, Float.valueOf(target));
            this.cachedPreviousScales.put(scaleTypeId, Float.valueOf(previous));
            this.shouldUpdateModifiers.remove(scaleTypeId);
            this.reachedScales.remove(scaleTypeId);
        }
        if (!this.cachedTargetScales.containsKey(scaleTypeId) || !this.cachedPreviousScales.containsKey(scaleTypeId)) {
            return modifiedScale;
        }
        if (this.isMax()) {
            this.reachedScales.remove(scaleTypeId);
            return ((Float)this.cachedTargetScales.get(scaleTypeId)).floatValue();
        }
        if (this.isMin()) {
            return this.cachedPreviousScales.get(scaleTypeId).floatValue();
        }
        if (this.reachedScales.containsKey(scaleTypeId) && this.reachedScales.get(scaleTypeId).containsKey(this.ticks) && this.reachedScales.get(scaleTypeId).get(this.ticks).keySet().stream().anyMatch(aFloat -> DelayedApoliScaleModifier.compareFloats(aFloat.floatValue(), 1.0f))) {
            return ((Float)this.reachedScales.get(scaleTypeId).get(this.ticks).entrySet().stream().filter(entry -> DelayedApoliScaleModifier.compareFloats(((Float)entry.getKey()).floatValue(), 1.0f)).findFirst().get().getValue()).floatValue();
        }
        if (this.reachedScales.containsKey(scaleTypeId) && this.reachedScales.get(scaleTypeId).containsKey(this.ticks) && this.reachedScales.get(scaleTypeId).get(this.ticks).keySet().stream().anyMatch(aFloat -> DelayedApoliScaleModifier.compareFloats(aFloat.floatValue(), delta))) {
            return ((Float)this.reachedScales.get(scaleTypeId).get(this.ticks).entrySet().stream().filter(entry -> DelayedApoliScaleModifier.compareFloats(((Float)entry.getKey()).floatValue(), delta)).findFirst().get().getValue()).floatValue();
        }
        return this.calculateScale(scaleData, scaleTypeId, delta, ((Float)this.cachedTargetScales.get(scaleTypeId)).floatValue(), this.cachedPreviousScales.get(scaleTypeId).floatValue());
    }

    private float calculateScale(ScaleData scaleData, ResourceLocation scaleTypeId, float delta, float targetScale, float previousScale) {
        Float2FloatFunction easing = this.easing.map(location -> {
            if (ScaleRegistries.SCALE_EASINGS.containsKey(location)) {
                return (Float2FloatFunction)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_EASINGS, (ResourceLocation)location);
            }
            Apugli.LOG.error("'easing' value '{}' for power '{}' is not a valid scale easing.", location, (Object)Services.POWER.getPowerId(this.power));
            return null;
        }).orElse(Optional.ofNullable(scaleData.getEasing()).orElseGet(() -> ((ScaleType)scaleData.getScaleType()).getDefaultEasing()));
        float progress = (float)this.getClampedTicks() + delta;
        int total = this.getMaxTicks();
        float range = targetScale - previousScale;
        float perTick = total == 0 ? 1.0f : ((Float)easing.apply((Object)Float.valueOf(progress / (float)total))).floatValue();
        float modified = previousScale + perTick * range;
        this.populateDeltaReachedScale(scaleTypeId, this.getClampedTicks(), delta, modified);
        return modified;
    }

    private void populateDeltaReachedScale(ResourceLocation scaleTypeId, int ticks, float delta, float modified) {
        if (!this.reachedScales.containsKey(scaleTypeId)) {
            this.reachedScales.put(scaleTypeId, new HashMap());
        }
        if (!this.reachedScales.get(scaleTypeId).containsKey(ticks)) {
            this.reachedScales.get(scaleTypeId).put(ticks, new HashMap());
        }
        if (this.reachedScales.containsKey(scaleTypeId) && ((Map)this.reachedScales.getOrDefault(scaleTypeId, new HashMap())).containsKey(ticks)) {
            this.reachedScales.get(scaleTypeId).get(ticks).put(Float.valueOf(delta), Float.valueOf(modified));
        }
    }

    @Override
    public float modifyPrevScale(ScaleData scaleData, float modifiedScale) {
        Entity entity = scaleData.getEntity();
        if (!(entity instanceof LivingEntity)) {
            this.logWarn();
            return modifiedScale;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ResourceLocation scaleTypeId = this.getResourceLocationFromScaleData(scaleData);
        boolean isActive = Services.POWER.isActive(this.power, entity2);
        if (this.shouldUpdatePreviousModifiers.contains(scaleTypeId)) {
            float target = !isActive ? modifiedScale : (float)Services.PLATFORM.applyModifiers((Entity)entity2, this.modifiers, (double)modifiedScale);
            float previous = this.cachedPreviousTargetScales.getOrDefault(scaleTypeId, Float.valueOf(modifiedScale)).floatValue();
            this.cachedPreviousTargetScales.put(scaleTypeId, Float.valueOf(target));
            this.cachedPreviousPreviousScales.put(scaleTypeId, Float.valueOf(previous));
            this.shouldUpdatePreviousModifiers.remove(scaleTypeId);
            this.reachedPreviousScales.remove(scaleTypeId);
        }
        if (!this.cachedPreviousTargetScales.containsKey(scaleTypeId) || !this.cachedPreviousPreviousScales.containsKey(scaleTypeId)) {
            return modifiedScale;
        }
        if (this.isMax()) {
            return ((Float)this.cachedPreviousTargetScales.get(scaleTypeId)).floatValue();
        }
        if (this.isMin()) {
            return this.cachedPreviousPreviousScales.get(scaleTypeId).floatValue();
        }
        if (this.reachedPreviousScales.containsKey(scaleTypeId) && ((Map)this.reachedPreviousScales.getOrDefault(scaleTypeId, new HashMap())).containsKey(this.ticks)) {
            return this.reachedPreviousScales.get(scaleTypeId).get(this.ticks).floatValue();
        }
        return this.calculatePreviousScale(scaleTypeId);
    }

    private float calculatePreviousScale(ResourceLocation scaleTypeId) {
        float targetScale = ((Float)this.cachedPreviousTargetScales.get(scaleTypeId)).floatValue();
        float previousScale = this.cachedPreviousPreviousScales.get(scaleTypeId).floatValue();
        float modified = Mth.m_14179_((float)((float)this.getClampedTicks() / (float)this.getMaxTicks()), (float)previousScale, (float)targetScale);
        this.populateReachedPreviousScale(scaleTypeId, this.ticks, modified);
        return modified;
    }

    private void populateReachedPreviousScale(ResourceLocation scaleTypeId, int ticks, float modified) {
        if (!this.reachedPreviousScales.containsKey(scaleTypeId)) {
            this.reachedPreviousScales.put(scaleTypeId, new HashMap());
        }
        if (this.reachedPreviousScales.containsKey(scaleTypeId)) {
            this.reachedPreviousScales.get(scaleTypeId).put(ticks, Float.valueOf(modified));
        }
    }
}

