/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.entity;

import io.github.apace100.calio.data.SerializableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.AreaEffectCloudEntityAccessor;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.ApugliEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class CustomAreaEffectCloud
extends AreaEffectCloud {
    private static final EntityDataAccessor<String> DATA_ENTITY_ID = SynchedEntityData.m_135353_(CustomAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final List<ResourceLocation> powersToApply = new ArrayList<ResourceLocation>();
    private Object ownerCloudBiEntityAction;
    private Object ownerTargetBiEntityAction;
    private Object cloudTargetBiEntityAction;
    private Object biEntityCondition;
    private Object ownerTargetBiEntityCondition;
    private double heightIncrease = 0.0;
    private final Map<LivingEntity, Integer> victims = new HashMap<LivingEntity, Integer>();

    public CustomAreaEffectCloud(EntityType<CustomAreaEffectCloud> entityType, Level world) {
        super(entityType, world);
        this.f_19794_ = true;
    }

    public CustomAreaEffectCloud(Level world, double x, double y, double z) {
        this(ApugliEntityTypes.CUSTOM_AREA_EFFECT_CLOUD.get(), world);
        this.m_6034_(x, y, z);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        for (Map.Entry<LivingEntity, Integer> next : this.victims.entrySet()) {
            for (ResourceLocation power : this.powersToApply) {
                Services.POWER.revokePower(power, this.getEntityId(), next.getKey());
            }
        }
        super.m_142687_(reason);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ENTITY_ID, (Object)"");
    }

    public void setHeightIncrease(double value) {
        this.heightIncrease = value;
    }

    public void setOwnerCloudBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.ownerCloudBiEntityAction = data.get(fieldName);
    }

    public void setOwnerTargetBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.ownerTargetBiEntityAction = data.get(fieldName);
    }

    public void setCloudTargetBiEntityAction(SerializableData.Instance data, String fieldName) {
        this.cloudTargetBiEntityAction = data.get(fieldName);
    }

    public void setBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.biEntityCondition = data.get(fieldName);
    }

    public void setOwnerTargetBiEntityCondition(SerializableData.Instance data, String fieldName) {
        this.ownerTargetBiEntityCondition = data.get(fieldName);
    }

    public <P> void addPowerToApply(P value) {
        ResourceLocation location = Services.POWER.getPowerFromParameter(value);
        if (location == null) {
            return;
        }
        this.powersToApply.add(location);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (!((String)this.m_20088_().m_135370_(DATA_ENTITY_ID)).equals("")) {
            compound.m_128359_("EntityId", (String)this.m_20088_().m_135370_(DATA_ENTITY_ID));
        }
        compound.m_128347_("HeightIncrease", this.heightIncrease);
        Services.CONDITION.writeBiEntityConditionToNbt(compound, "BiEntityCondition", this.biEntityCondition);
        Services.ACTION.writeBiEntityActionToNbt(compound, "OwnerCloudBiEntityAction", this.ownerCloudBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "OwnerTargetBiEntityAction", this.ownerTargetBiEntityAction);
        Services.ACTION.writeBiEntityActionToNbt(compound, "CloudTargetBiEntityAction", this.cloudTargetBiEntityAction);
        ListTag powerTag = new ListTag();
        for (ResourceLocation power : this.powersToApply) {
            powerTag.add((Object)StringTag.m_129297_((String)power.toString()));
        }
        if (!powerTag.isEmpty()) {
            compound.m_128365_("PowersToApply", (Tag)powerTag);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("EntityId", 8)) {
            this.m_20088_().m_135381_(DATA_ENTITY_ID, (Object)compound.m_128461_("EntityId"));
        }
        this.heightIncrease = compound.m_128459_("HeightIncrease");
        this.biEntityCondition = Services.CONDITION.readBiEntityConditionFromNbt(compound, "BiEntityCondition");
        this.ownerCloudBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "OwnerCloudBiEntityAction");
        this.ownerTargetBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "OwnerTargetBiEntityAction");
        this.cloudTargetBiEntityAction = Services.ACTION.readBiEntityActionFromNbt(compound, "CloudTargetBiEntityAction");
        if (compound.m_128425_("PowersToApply", 9)) {
            ListTag powerTag = compound.m_128437_("PowersToApply", 8);
            for (Tag tag : powerTag) {
                this.powersToApply.add(new ResourceLocation(tag.m_7916_()));
            }
        }
    }

    public ResourceLocation getEntityId() {
        return new ResourceLocation((String)this.m_20088_().m_135370_(DATA_ENTITY_ID));
    }

    public void setEntityId(ResourceLocation location) {
        this.m_20088_().m_135381_(DATA_ENTITY_ID, (Object)location.toString());
    }

    private boolean isOwnerRemovedOrDiscarded() {
        AreaEffectCloudEntityAccessor accessor = (AreaEffectCloudEntityAccessor)((Object)this);
        if (accessor.apugli$getOwner() == null) {
            return false;
        }
        return accessor.apugli$getOwner().m_146911_() == Entity.RemovalReason.KILLED || accessor.apugli$getOwner().m_146911_() == Entity.RemovalReason.DISCARDED;
    }

    public void m_8119_() {
        super.m_8119_();
        boolean bl = this.m_19747_();
        float f = this.m_19743_();
        if (this.m_9236_().f_46443_) {
            float g;
            int i;
            if (bl && this.f_19796_.m_188499_()) {
                return;
            }
            ParticleOptions particleOptions = this.m_19745_();
            if (bl) {
                i = 2;
                g = 0.2f;
            } else {
                i = Mth.m_14167_((float)((float)Math.PI * f * f));
                g = f;
            }
            for (int j = 0; j < i; ++j) {
                double p;
                double o;
                double n;
                float h = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float k = Mth.m_14116_((float)this.f_19796_.m_188501_()) * g;
                double d = this.m_20185_() + (double)(Mth.m_14089_((float)h) * k);
                double e = this.m_20186_();
                double l = this.m_20189_() + (double)(Mth.m_14031_((float)h) * k);
                if (particleOptions.m_6012_() != ParticleTypes.f_123811_) {
                    if (bl) {
                        n = 0.0;
                        o = 0.0;
                        p = 0.0;
                    } else {
                        n = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                        o = 0.01f;
                        p = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                    }
                } else {
                    int m = bl && this.f_19796_.m_188499_() ? 0xFFFFFF : this.m_19744_();
                    n = (float)(m >> 16 & 0xFF) / 255.0f;
                    o = (float)(m >> 8 & 0xFF) / 255.0f;
                    p = (float)(m & 0xFF) / 255.0f;
                }
                this.m_9236_().m_7107_(particleOptions, d, e, l, n, o, p);
            }
        } else {
            boolean bl2;
            if (this.isOwnerRemovedOrDiscarded()) {
                this.m_146870_();
                return;
            }
            if (this.f_19797_ >= this.m_146790_() + this.m_19748_()) {
                this.m_146870_();
                return;
            }
            boolean bl3 = bl2 = this.f_19797_ < this.m_146790_();
            if (bl != bl2) {
                this.m_19730_(bl2);
            }
            if (bl2) {
                return;
            }
            if (this.m_146788_() != 0.0f) {
                if ((f += this.m_146788_()) < 0.5f) {
                    this.m_146870_();
                    return;
                }
                this.m_19712_(f);
            }
            if (this.f_19797_ % 5 == 0) {
                List list2 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82363_(0.0, this.heightIncrease, 0.0));
                Iterator<Map.Entry<LivingEntity, Integer>> victimIterator = this.victims.entrySet().iterator();
                while (victimIterator.hasNext()) {
                    Map.Entry<LivingEntity, Integer> next = victimIterator.next();
                    if (this.f_19797_ < next.getValue() || list2.contains(next.getKey())) continue;
                    for (ResourceLocation power : this.powersToApply) {
                        Services.POWER.revokePower(power, this.getEntityId(), next.getKey());
                    }
                    victimIterator.remove();
                }
                if (!list2.isEmpty() && !this.m_213877_()) {
                    Iterator var27 = list2.iterator();
                    while (true) {
                        double r;
                        double q;
                        double s;
                        if (!var27.hasNext()) {
                            return;
                        }
                        LivingEntity livingEntity = (LivingEntity)var27.next();
                        if (!Services.CONDITION.checkBiEntity(this.biEntityCondition, (Entity)this, (Entity)livingEntity) || !Services.CONDITION.checkBiEntity(this.ownerTargetBiEntityCondition, (Entity)this.m_19749_(), (Entity)livingEntity) || !((s = (q = livingEntity.m_20185_() - this.m_20185_()) * q + (r = livingEntity.m_20189_() - this.m_20189_()) * r) <= (double)(f * f))) continue;
                        this.victims.put(livingEntity, this.f_19797_ + ((AreaEffectCloudEntityAccessor)((Object)this)).apugli$getReapplicationDelay());
                        for (ResourceLocation power : this.powersToApply) {
                            if (Services.POWER.hasPowerType(power, this.getEntityId(), livingEntity)) continue;
                            Services.POWER.grantPower(power, this.getEntityId(), livingEntity);
                        }
                        Services.ACTION.executeBiEntity(this.ownerCloudBiEntityAction, (Entity)this.m_19749_(), (Entity)this);
                        Services.ACTION.executeBiEntity(this.ownerTargetBiEntityAction, (Entity)this.m_19749_(), (Entity)livingEntity);
                        Services.ACTION.executeBiEntity(this.cloudTargetBiEntityAction, (Entity)this, (Entity)livingEntity);
                        if (this.m_146787_() != 0.0f) {
                            if ((f += this.m_146787_()) < 0.5f) {
                                this.m_146870_();
                                return;
                            }
                            this.m_19712_(f);
                        }
                        if (this.m_146789_() == 0) continue;
                        this.m_19734_(this.m_19748_() + this.m_146789_());
                        if (this.m_19748_() <= 0) break;
                    }
                    this.m_146870_();
                    return;
                }
            }
        }
    }
}

