/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.calio.data.SerializableData;
import java.util.List;
import java.util.Optional;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.data.ApugliDataTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;

public class StructureCondition
implements IConditionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("structure", ApugliDataTypes.STRUCTURE, null).add("tag", ApugliDataTypes.STRUCTURE_TAG, null);
    }

    @Override
    public boolean check(SerializableData.Instance data, Entity entity) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        Registry registry = level2.m_9598_().m_175515_(Registries.f_256944_);
        HolderSet holders = null;
        ResourceKey structure = (ResourceKey)data.get("structure");
        TagKey tag = (TagKey)data.get("tag");
        if (structure != null) {
            Optional entry = registry.m_203636_(structure);
            if (entry.isPresent()) {
                holders = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)entry.get()});
            }
        } else {
            Optional optionalList = registry.m_203431_(tag);
            if (optionalList.isPresent()) {
                holders = (HolderSet)optionalList.get();
            }
        }
        if (holders == null) {
            return false;
        }
        Pair result = level2.m_7726_().m_8481_().m_223037_(level2, holders, entity.m_20183_(), 10, false);
        if (result != null) {
            ChunkPos structureChunkPos = new ChunkPos(((BlockPos)result.getFirst()).m_123341_() >> 4, ((BlockPos)result.getFirst()).m_123343_() >> 4);
            StructureStart structureStart = level2.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)structureChunkPos, (int)0), (Structure)((Holder)result.getSecond()).m_203334_(), (StructureAccess)level2.m_46865_((BlockPos)result.getFirst()));
            List structurePieces = structureStart.m_73602_().stream().toList();
            for (StructurePiece structurePiece : structurePieces) {
                BoundingBox box = structurePiece.m_73547_();
                if (!entity.m_20191_().m_82381_(AABB.m_82321_((BoundingBox)box))) continue;
                return true;
            }
        }
        return false;
    }
}

