/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastCondition
implements IConditionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("distance", SerializableDataTypes.DOUBLE, null).add("direction", SerializableDataTypes.VECTOR, null).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("block_condition", Services.CONDITION.blockDataType(), null).add("target_condition", Services.CONDITION.entityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null);
    }

    @Override
    public boolean check(SerializableData.Instance data, Entity entity) {
        HitResult.Type entityHitResultType;
        double blockDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
        BlockHitResult blockHitResult = RaycastUtil.raycastBlock(entity, blockDistance, (Vec3)data.get("direction"), (Space)data.get("space"));
        HitResult.Type blockHitResultType = blockHitResult.m_6662_();
        double entityDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
        EntityHitResult entityHitResult = RaycastUtil.raycastEntity(blockHitResult, entity, entityDistance);
        HitResult.Type type = entityHitResultType = entityHitResult != null ? entityHitResult.m_6662_() : null;
        if (entityHitResultType == HitResult.Type.ENTITY) {
            return this.checkHitEntity(data, entity, entityHitResult);
        }
        if (blockHitResultType == HitResult.Type.BLOCK) {
            return this.checkHitBlock(data, entity, blockHitResult);
        }
        return false;
    }

    protected boolean checkHitBlock(SerializableData.Instance data, Entity entity, BlockHitResult result) {
        return Services.CONDITION.checkBlock(data, "block_condition", entity.m_9236_(), result.m_82425_());
    }

    protected boolean checkHitEntity(SerializableData.Instance data, Entity entity, EntityHitResult result) {
        return Services.CONDITION.checkEntity(data, "target_condition", entity) && Services.CONDITION.checkBiEntity(data, "bientity_condition", entity, result.m_82443_());
    }
}

