/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.EnergySwirlPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

@ParametersAreNonnullByDefault
public class EnergySwirlLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public EnergySwirlLayer(RenderLayerParent<T, M> featureRendererContext) {
        super(featureRendererContext);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        Services.POWER.getPowers((LivingEntity)entity, ApugliPowers.ENERGY_SWIRL.get()).forEach(power -> this.renderOverlay((EnergySwirlPower)((Object)power), matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
    }

    public void renderOverlay(EnergySwirlPower power, PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (power.getTextureLocation() == null && power.getTextureUrl() == null) {
            return;
        }
        float f = (float)((LivingEntity)entity).f_19797_ + tickDelta;
        VertexConsumer vertexConsumer = null;
        if (TextureUtilClient.getUrls().containsKey(power.getUrlTextureIdentifier())) {
            vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110436_((ResourceLocation)power.getUrlTextureIdentifier(), (float)(this.getEnergySwirlX(f, power.getSpeed()) % 1.0f), (float)(f * 0.01f % 1.0f)));
        } else if (power.getTextureLocation() != null) {
            vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110436_((ResourceLocation)power.getTextureLocation(), (float)(this.getEnergySwirlX(f, power.getSpeed()) % 1.0f), (float)(f * 0.01f % 1.0f)));
        }
        if (vertexConsumer != null) {
            matrices.m_85836_();
            EntityModel entityModel = this.m_117386_();
            entityModel.m_6839_(entity, limbAngle, limbDistance, tickDelta);
            this.m_117386_().m_102624_(entityModel);
            entityModel.m_6973_(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            matrices.m_85841_(power.getSize(), power.getSize(), power.getSize());
            entityModel.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 1.0f);
            matrices.m_85849_();
        }
    }

    protected float getEnergySwirlX(float partialAge, float speed) {
        return partialAge * speed;
    }
}

