/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SpawnItemAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("stack", SerializableDataTypes.ITEM_STACK, null).add("stacks", SerializableDataTypes.ITEM_STACKS, null).add("pick_up_delay", SerializableDataTypes.INT, (Object)10).add("retain_ownership", SerializableDataTypes.BOOLEAN, (Object)false).add("throw_randomly", SerializableDataTypes.BOOLEAN, (Object)false).add("space", ApoliDataTypes.SPACE, (Object)Space.LOCAL).add("velocity", SerializableDataTypes.VECTOR, null);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        Supplier<Vec3> nextVelocity;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (data.isPresent("stack")) {
            stacks.add((ItemStack)data.get("stack"));
        }
        if (data.isPresent("stacks")) {
            stacks.addAll((Collection)data.get("stacks"));
        }
        if (stacks.isEmpty()) {
            return;
        }
        int pickupDelay = data.getInt("pick_up_delay");
        boolean retainOwnership = data.getBoolean("retain_ownership");
        boolean throwRandomly = data.getBoolean("throw_randomly");
        Level level = entity.m_9236_();
        if (throwRandomly) {
            RandomSource randomSource;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                randomSource = living.m_217043_();
            } else {
                randomSource = level.f_46441_;
            }
            RandomSource random = randomSource;
            nextVelocity = () -> {
                float hVelocity = random.m_188501_() * 0.5f;
                float hRot = random.m_188501_() * ((float)Math.PI * 2);
                return new Vec3((double)(-Mth.m_14031_((float)hRot) * hVelocity), 0.2, (double)Mth.m_14089_((float)hRot));
            };
        } else {
            Vector3f vector = data.isPresent("velocity") ? new Vector3f((float)((Vec3)data.get((String)"velocity")).f_82479_, (float)((Vec3)data.get((String)"velocity")).f_82480_, (float)((Vec3)data.get((String)"velocity")).f_82481_) : new Vector3f();
            ((Space)data.get("space")).toGlobal(vector, entity);
            Vec3 velocity = new Vec3(vector);
            nextVelocity = () -> velocity;
        }
        stacks.stream().filter(ItemStack::m_41619_).map(stack -> this.createItemEntity(entity, (ItemStack)stack, pickupDelay, retainOwnership, (Vec3)nextVelocity.get())).forEach(arg_0 -> ((Level)level).m_7967_(arg_0));
    }

    private ItemEntity createItemEntity(Entity entity, ItemStack stack, int pickupDelay, boolean retainOwnership, Vec3 velocity) {
        ItemEntity itemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        itemEntity.m_32010_(pickupDelay);
        itemEntity.m_32052_(entity.m_20148_());
        if (retainOwnership) {
            itemEntity.m_32052_(entity.m_20148_());
        }
        itemEntity.m_20256_(velocity);
        return itemEntity;
    }
}

