/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.bientity;

import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RaycastBetweenAction
implements IActionFactory<Tuple<Entity, Entity>> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("block_action", Services.ACTION.blockDataType(), null).add("block_condition", Services.CONDITION.blockDataType(), null).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5);
    }

    @Override
    public void execute(SerializableData.Instance data, Tuple<Entity, Entity> pair) {
        double distance = ((Entity)pair.m_14418_()).m_20270_((Entity)pair.m_14419_());
        Vec3 direction = this.createDirectionVector(((Entity)pair.m_14418_()).m_20182_(), ((Entity)pair.m_14419_()).m_20182_());
        BlockHitResult blockHitResult = RaycastUtil.raycastBlock((Entity)pair.m_14418_(), distance, direction, Space.WORLD);
        HitResult.Type blockHitResultType = blockHitResult.m_6662_();
        if (data.isPresent("block_action") && blockHitResultType == HitResult.Type.BLOCK) {
            this.createParticlesAtHitPos(data, (Entity)pair.m_14418_(), (HitResult)blockHitResult);
            this.onHitBlock(data, (Entity)pair.m_14418_(), blockHitResult);
        } else {
            this.createParticlesAtHitPos(data, (Entity)pair.m_14418_(), (HitResult)new EntityHitResult((Entity)pair.m_14419_()));
        }
    }

    protected Vec3 createDirectionVector(Vec3 pos1, Vec3 pos2) {
        return new Vec3(pos2.m_7096_() - pos1.m_7096_(), pos2.m_7098_() - pos1.m_7098_(), pos2.m_7094_() - pos1.m_7094_()).m_82541_();
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, Entity entity, HitResult hitResult) {
        if (!data.isPresent("particle") || entity.m_9236_().m_5776_()) {
            return;
        }
        ParticleOptions particleEffect = (ParticleOptions)data.get("particle");
        double distanceTo = hitResult.m_82448_(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = Mth.m_14008_((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((ServerLevel)entity.m_9236_()).m_8767_(particleEffect, Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7096_(), (double)hitResult.m_82450_().m_7096_()), Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7098_(), (double)hitResult.m_82450_().m_7098_()), Mth.m_14139_((double)lerpValue, (double)entity.m_146892_().m_7094_(), (double)hitResult.m_82450_().m_7094_()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(SerializableData.Instance data, Entity entity, BlockHitResult result) {
        if (!data.isPresent("block_action") || !Services.CONDITION.checkBlock(data, "block_condition", entity.m_9236_(), result.m_82425_())) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.m_9236_(), result.m_82425_(), result.m_82434_());
    }
}

