/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.entity.JNEEntityType;
import net.jadenxgamer.netherexp.registry.entity.custom.Apparition;
import net.jadenxgamer.netherexp.registry.entity.custom.Vessel;
import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.jadenxgamer.netherexp.registry.misc_registry.JNEDamageSources;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stampede
extends Monster
implements NeutralMob,
ItemSteerable,
Saddleable,
PlayerRideable,
RiderShieldingMount {
    private int changeType = 1;
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(JNETags.Items.STAMPEDE_EDIBLE);
    static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = item -> !item.m_32063_() && item.m_6084_() && item.m_32055_().m_204117_(JNETags.Items.STAMPEDE_EDIBLE);
    private static final EntityDataAccessor<Integer> BOOST_TIME = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLE_ID = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PATRICK = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EATING_TIME = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGITATED = SynchedEntityData.m_135353_(Stampede.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    public final AnimationState chewAnimationState = new AnimationState();
    public final AnimationState grinAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    private int stepSoundCooldown = 0;
    private int idleAnimationTimeout = 0;
    private int angerTime;
    private UUID angryAt;
    private final ItemBasedSteering steering;

    public Stampede(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(3.5f);
        this.f_19850_ = true;
        this.steering = new ItemBasedSteering(this.f_19804_, BOOST_TIME, SADDLE_ID);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21553_(true);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.getAngry()) {
            this.grinAnimationState.m_216982_(this.f_19797_);
        } else {
            this.grinAnimationState.m_216973_();
        }
        if (this.getEating()) {
            this.chewAnimationState.m_216982_(this.f_19797_);
        } else {
            this.chewAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float v) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    private boolean isMoving() {
        return this.m_20184_().m_165924_() > (double)0.02f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 4.0).m_22268_(Attributes.f_22278_, 3.0).m_22268_(Attributes.f_22284_, 7.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.2, 32.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PickupItemGoal());
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Stray.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Vessel.class, true));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_8107_() {
        if (this.stepSoundCooldown > 0) {
            --this.stepSoundCooldown;
        }
        if (this.m_20070_()) {
            if (this.getChangeType() == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.m_146870_();
            } else {
                this.doExorcism();
            }
        }
        if (this.m_6084_()) {
            ItemStack item = this.m_6844_(EquipmentSlot.MAINHAND);
            int eating = this.getEatingTime();
            int agitated = this.getAgitated();
            if (this.m_20160_()) {
                Object object;
                if (agitated < 6000) {
                    this.setAgitated(++agitated);
                }
                if (agitated >= 6000 && (object = this.m_146895_()) instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)object;
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_AGITATED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.m_6710_(passenger);
                    passenger.m_8127_();
                }
            }
            if (!item.m_41619_()) {
                this.setEatingTime(++eating);
                this.playEatingAnimation();
                this.setEating(true);
                if (eating > 100) {
                    if (item.m_204117_(JNETags.Items.STAMPEDE_FAVORITES) && !this.getIsTamed()) {
                        if (!this.m_9236_().f_46443_ && this.f_19796_.m_188503_(5) == 0) {
                            this.setIsTamed(true);
                            List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, new AABB(this.m_20183_()).m_82377_(6.5, 6.5, 6.5));
                            for (ServerPlayer serverPlayer : nearbyPlayers) {
                                JNECriteriaTriggers.TAME_STAMPEDE.m_222618_(serverPlayer);
                            }
                        }
                        for (int i = 0; i < 12; ++i) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), 0.0, 0.0, 0.0);
                        }
                    }
                    this.m_8061_(EquipmentSlot.MAINHAND, Items.f_41852_.m_7968_());
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(item.m_204117_(JNETags.Items.STAMPEDE_FAVORITES) ? 10.0f : 5.0f);
                    }
                    this.setAgitated(agitated - (item.m_204117_(JNETags.Items.STAMPEDE_FAVORITES) ? 900 : 600));
                    if (this.getAgitated() < 0) {
                        this.setAgitated(0);
                    }
                    this.m_6710_(null);
                    this.setEatingTime(0);
                    this.setEating(false);
                }
            }
            this.setAngry(this.m_5448_() != null && !this.getEating());
        }
        if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
            if (this.m_20160_()) {
                this.damageLivingEntities(this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.f_20406_));
            } else if (this.isMoving()) {
                this.damageLivingEntities(this.m_9236_().m_6249_((Entity)this, this.m_20191_(), EntitySelector.f_20406_));
            }
        }
        super.m_8107_();
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6254_() && stack.m_41619_() && player.m_6144_()) {
            this.steering.m_20849_(false);
            player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12466_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_21008_(hand, Items.f_42450_.m_7968_());
            return InteractionResult.SUCCESS;
        }
        if (this.m_6254_() && !this.m_20160_() && !player.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6741_() && !this.m_6254_() && stack.m_150930_(Items.f_42450_)) {
            this.m_5853_(SoundSource.NEUTRAL);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void playEatingAnimation() {
        if (this.getEatingTime() % 5 == 0) {
            this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_EAT.get(), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                double d = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
                Vec3 vec32 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.8, d, 1.0 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.4);
                vec32 = vec32.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                vec32 = vec32.m_82520_(this.m_20185_(), this.m_20188_() + 1.0, this.m_20189_());
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, Items.f_42262_.m_7968_()), vec32.f_82479_, vec32.f_82480_, vec32.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
            }
        }
    }

    private void damageLivingEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_20159_() || livingEntity.m_6095_().m_204039_(JNETags.EntityTypes.STAMPEDE_CANNOT_RUN_OVER)) continue;
            entity.m_6469_(this.m_269291_().m_269298_(JNEDamageSources.STAMPEDE_CRUSH, (Entity)this), 10.0f);
        }
    }

    public double m_6048_() {
        float f = Math.min(0.25f, this.f_267362_.m_267731_());
        float g = this.f_267362_.m_267756_();
        return (double)this.m_20206_() - 0.19 + (double)(0.12f * Mth.m_14089_((float)(g * 1.5f)) * 2.0f * f);
    }

    private void doExorcism() {
        Level level;
        Strider strider = (Strider)this.m_21406_(EntityType.f_20482_, false);
        if (strider != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            strider.m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(strider.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
            strider.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            strider.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
            strider.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            if (this.m_8077_()) {
                strider.m_6593_(strider.m_7770_());
            }
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.WISP.get(), this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        ThrownPotion thrownPotion;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownPotion && this.hurtWithCleanWater(thrownPotion = (ThrownPotion)entity) && this.getChangeType() > 0) {
            this.doExorcism();
            Entity entity2 = thrownPotion.m_19749_();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                JNECriteriaTriggers.EXORCISM.m_222618_((ServerPlayer)player);
            }
        }
        return super.m_6469_(damageSource, f);
    }

    private boolean hurtWithCleanWater(ThrownPotion thrownPotion) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        return potion == Potions.f_43599_ && list.isEmpty();
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        int escapingOdds = this.f_19796_.m_188503_(this.m_9236_().m_46791_() == Difficulty.HARD ? 1 : 3);
        if (this.m_9236_().m_46791_() != Difficulty.EASY && escapingOdds == 0) {
            Apparition apparition = (Apparition)((EntityType)JNEEntityType.APPARITION.get()).m_20615_(this.m_9236_());
            if (apparition != null) {
                apparition.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                apparition.setCooldown(1200);
                apparition.setPreference(2);
                if (this.m_5448_() != null) {
                    apparition.m_6710_(this.m_5448_());
                }
            }
            this.m_9236_().m_7967_((Entity)apparition);
        }
    }

    public boolean m_6126_() {
        return true;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack holdingStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return !this.m_20160_() && holdingStack.m_41619_() && stack.m_204117_(JNETags.Items.STAMPEDE_EDIBLE);
    }

    public LivingEntity m_6688_() {
        Player player;
        Entity passenger = this.m_146895_();
        if (passenger instanceof Player && ((player = (Player)passenger).m_21205_().m_150930_((Item)JNEItems.SKULL_ON_A_STICK.get()) || player.m_21206_().m_150930_((Item)JNEItems.SKULL_ON_A_STICK.get()))) {
            return player;
        }
        return null;
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.steering.m_274606_();
        super.m_274498_(player, vec3);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.getIsTamed();
    }

    @NotNull
    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)(0.23 * (double)this.steering.m_274439_());
    }

    public boolean m_7327_(Entity target) {
        int i = this.f_19796_.m_188503_(10);
        if (i == 0) {
            this.dropStridite();
        }
        return super.m_7327_(target);
    }

    private void dropStridite() {
        int a = this.f_19796_.m_188503_(3) + 1;
        for (int d = 0; d < a; ++d) {
            this.m_19998_((ItemLike)JNEItems.STRIDITE.get());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANGRY, (Object)false);
        this.m_20088_().m_135372_(EATING, (Object)false);
        this.m_20088_().m_135372_(EATING_TIME, (Object)0);
        this.m_20088_().m_135372_(IS_PATRICK, (Object)false);
        this.m_20088_().m_135372_(BOOST_TIME, (Object)0);
        this.m_20088_().m_135372_(SADDLE_ID, (Object)false);
        this.m_20088_().m_135372_(TAMED, (Object)false);
        this.m_20088_().m_135372_(AGITATED, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Eating", this.getEating());
        nbt.m_128379_("Tamed", this.getIsTamed());
        nbt.m_128405_("Agitated", this.getAgitated());
        nbt.m_128379_("Saddled", ((Boolean)this.f_19804_.m_135370_(SADDLE_ID)).booleanValue());
        nbt.m_128379_("Patrick", this.getIsPatrick());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setEating(nbt.m_128471_("Eating"));
        this.setIsTamed(nbt.m_128471_("Tamed"));
        this.setAgitated(nbt.m_128451_("Agitated"));
        this.f_19804_.m_135381_(SADDLE_ID, (Object)nbt.m_128471_("Saddled"));
        this.setIsPatrick(nbt.m_128471_("Patrick"));
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (!this.getIsPatrick() && name != null && name.getString().equals("Patrick")) {
            this.setIsPatrick(true);
        }
    }

    public int getEatingTime() {
        return (Integer)this.f_19804_.m_135370_(EATING_TIME);
    }

    private void setEatingTime(int time) {
        this.f_19804_.m_135381_(EATING_TIME, (Object)time);
    }

    public boolean getIsTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    private void setIsTamed(boolean flag) {
        this.f_19804_.m_135381_(TAMED, (Object)flag);
    }

    public int getAgitated() {
        return (Integer)this.f_19804_.m_135370_(AGITATED);
    }

    private void setAgitated(int flag) {
        this.f_19804_.m_135381_(AGITATED, (Object)flag);
    }

    public boolean getAngry() {
        return (Boolean)this.m_20088_().m_135370_(ANGRY);
    }

    private void setAngry(boolean angry) {
        this.m_20088_().m_135381_(ANGRY, (Object)angry);
    }

    public boolean getEating() {
        return (Boolean)this.m_20088_().m_135370_(EATING);
    }

    private void setEating(boolean eating) {
        this.m_20088_().m_135381_(EATING, (Object)eating);
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public boolean getIsPatrick() {
        return (Boolean)this.m_20088_().m_135370_(IS_PATRICK);
    }

    private void setIsPatrick(boolean patrick) {
        this.m_20088_().m_135381_(IS_PATRICK, (Object)patrick);
    }

    public double m_262813_() {
        return 1.5;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.angryAt;
    }

    public void m_6925_(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public boolean m_6746_() {
        return this.steering.m_217032_(this.m_217043_());
    }

    public boolean m_6741_() {
        return this.m_6084_() && this.getIsTamed();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.steering.m_20849_(true);
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12466_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_20160_()) {
            if (this.stepSoundCooldown <= 0) {
                this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_STEP.get(), 0.7f, 1.0f);
                this.stepSoundCooldown = 8;
            }
        } else {
            this.m_5496_((SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_STEP.get(), 0.7f, 1.0f);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource arg) {
        return (SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JNESoundEvents.ENTITY_STAMPEDE_DEATH.get();
    }

    class PickupItemGoal
    extends Goal {
        public PickupItemGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Stampede.this.m_20160_()) {
                return false;
            }
            if (!Stampede.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (Stampede.this.m_5448_() == null) {
                if (Stampede.this.m_217043_().m_188503_(PickupItemGoal.m_186073_((int)10)) != 0) {
                    return false;
                }
                List<ItemEntity> list = this.getItems();
                return !list.isEmpty() && Stampede.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List<ItemEntity> list = this.getItems();
            ItemStack itemStack = Stampede.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack.m_41619_() && !list.isEmpty()) {
                Stampede.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List<ItemEntity> list = this.getItems();
            if (!list.isEmpty()) {
                Stampede.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        private List<ItemEntity> getItems() {
            return Stampede.this.m_9236_().m_6443_(ItemEntity.class, Stampede.this.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
        }
    }
}

