/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.entity.custom;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.jadenxgamer.netherexp.registry.advancements.JNECriteriaTriggers;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EctoSlab
extends Slime {
    private int changeType = 1;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState digAnimationState = new AnimationState();
    public final AnimationState attackAnimation = new AnimationState();
    private static final EntityDimensions UNDERGROUND_DIMENSIONS = new EntityDimensions(2.04f, 0.1f, true);
    private static final EntityDataAccessor<Boolean> IS_UNDERGROUND = SynchedEntityData.m_135353_(EctoSlab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(EctoSlab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Predicate<LivingEntity> ECTO_SLAB_CAN_DAMAGE = entity -> entity.m_6095_().m_204039_(JNETags.EntityTypes.ECTO_SLAB_POUNCE_DAMAGES);

    public EctoSlab(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
        this.m_252801_();
        this.m_274367_(8.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.f_21342_ = new EctoSlabMoveControl(this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20208_(0.3 * (double)this.m_33632_()), this.m_20186_(), this.m_20262_(0.3 * (double)this.m_33632_()), 0.0, 0.0, 0.0);
        if (this.m_9236_().f_46443_) {
            if (this.getIsUnderground()) {
                this.idleAnimationState.m_216973_();
                this.digAnimationState.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState.m_216982_(this.f_19797_);
                this.digAnimationState.m_216973_();
            }
            if (this.getAttack()) {
                this.attackAnimation.m_216982_(this.f_19797_);
            } else {
                this.attackAnimation.m_216973_();
            }
        }
    }

    public void m_8107_() {
        if (this.m_20070_()) {
            if (this.getChangeType() == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.m_146870_();
            } else {
                this.doExorcism();
            }
        }
        this.m_6210_();
        super.m_8107_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.4);
    }

    public static boolean checkEctoSlabSpawnRules(EntityType<MagmaCube> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this) && !levelReader.m_46855_(this.m_20191_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EctoSlabFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new EctoSlabAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new EctoSlabRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new EctoSlabMoveGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Piglin.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public int getChangeType() {
        return this.changeType;
    }

    public void setChangeType(int changeType) {
        this.changeType = changeType;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("IsUnderground", this.getIsUnderground());
        nbt.m_128405_("ChangeType", this.getChangeType());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setIsUnderground(nbt.m_128471_("IsUnderground"));
        this.setChangeType(nbt.m_128451_("ChangeType"));
    }

    public boolean m_6673_(DamageSource damageSource) {
        return this.m_213877_() || this.m_20147_() || this.getIsUnderground() && !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_19390_() || damageSource.m_269533_(DamageTypeTags.f_268745_) && this.m_5825_() || damageSource.m_269533_(DamageTypeTags.f_268549_) && this.m_6095_().m_204039_(EntityTypeTags.f_273841_);
    }

    public boolean m_6128_() {
        return this.getIsUnderground();
    }

    public boolean m_6094_() {
        return !this.getIsUnderground() && super.m_6094_();
    }

    protected void m_6138_() {
        if (!this.getIsUnderground()) {
            super.m_6138_();
        }
    }

    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (entity instanceof Piglin && this.m_7483_()) {
            this.m_33637_((LivingEntity)entity);
        }
    }

    public void m_6210_() {
        super.m_6210_();
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return this.getIsUnderground() ? UNDERGROUND_DIMENSIONS : super.m_6972_(pose);
    }

    public void m_7839_(int i, boolean bl) {
        super.m_7839_(i, bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_((double)(i * 3));
    }

    public float m_213856_() {
        return 1.0f;
    }

    @NotNull
    protected ParticleOptions m_6300_() {
        return this.getIsUnderground() ? new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()) : ParticleTypes.f_123745_;
    }

    public boolean m_6060_() {
        return false;
    }

    protected int m_7549_() {
        return super.m_7549_() * 4;
    }

    protected void m_7480_() {
        this.f_33581_ *= 0.9f;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        float f = (float)this.m_33632_() * 0.1f;
        this.m_20334_(vec3.f_82479_, this.m_6118_() + f, vec3.f_82481_);
        this.f_19812_ = true;
    }

    protected void m_203347_(TagKey<Fluid> tagKey) {
        if (tagKey == FluidTags.f_13132_ || tagKey == JNETags.Fluids.ECTOPLASM) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, 0.22f + (float)this.m_33632_() * 0.05f, vec3.f_82481_);
            this.f_19812_ = true;
        } else {
            super.m_203347_(tagKey);
        }
    }

    public void m_6123_(Player player) {
        if (!this.getIsUnderground()) {
            super.m_6123_(player);
        }
    }

    protected boolean m_7483_() {
        return this.m_21515_();
    }

    protected float m_7566_() {
        return super.m_7566_() + 2.0f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.m_33633_() ? SoundEvents.f_12110_ : SoundEvents.f_12109_;
    }

    protected SoundEvent m_5592_() {
        return this.m_33633_() ? SoundEvents.f_12101_ : SoundEvents.f_12108_;
    }

    @NotNull
    protected SoundEvent m_7905_() {
        return this.m_33633_() ? SoundEvents.f_12061_ : (SoundEvent)JNESoundEvents.ENTITY_ECTO_SLAB_SQUISH.get();
    }

    @NotNull
    protected SoundEvent m_7903_() {
        return (SoundEvent)JNESoundEvents.ENTITY_ECTO_SLAB_JUMP.get();
    }

    float m_33642_() {
        float f = this.m_33633_() ? 1.4f : 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    public boolean getIsUnderground() {
        return (Boolean)this.m_20088_().m_135370_(IS_UNDERGROUND);
    }

    private void setIsUnderground(boolean bl) {
        this.m_20088_().m_135381_(IS_UNDERGROUND, (Object)bl);
    }

    public boolean getAttack() {
        return (Boolean)this.m_20088_().m_135370_(ATTACK);
    }

    private void setAttack(boolean bl) {
        this.m_20088_().m_135381_(ATTACK, (Object)bl);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_UNDERGROUND, (Object)false);
        this.m_20088_().m_135372_(ATTACK, (Object)false);
    }

    private void damageLivingEntities(List<LivingEntity> allEntities) {
        for (LivingEntity entity : allEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.m_7566_() * 2.0f);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        ThrownPotion thrownPotion;
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownPotion && this.hurtWithCleanWater(thrownPotion = (ThrownPotion)entity)) {
            Entity entity2;
            if (this.getChangeType() > 0) {
                this.doExorcism();
            }
            if ((entity2 = thrownPotion.m_19749_()) instanceof Player) {
                Player player = (Player)entity2;
                JNECriteriaTriggers.EXORCISM.m_222618_((ServerPlayer)player);
            }
        }
        return super.m_6469_(damageSource, f);
    }

    private void doExorcism() {
        Level level;
        MagmaCube magmaCube = (MagmaCube)this.m_21406_(EntityType.f_20468_, false);
        if (magmaCube != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            magmaCube.m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(magmaCube.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, false), null);
            magmaCube.m_7839_(this.m_33632_(), true);
            magmaCube.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            magmaCube.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
            magmaCube.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
            if (this.m_8077_()) {
                magmaCube.m_6593_(magmaCube.m_7770_());
            }
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)JNESoundEvents.ENTITY_APPARITION_DEATH.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)JNEParticleTypes.WISP.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    private boolean hurtWithCleanWater(ThrownPotion thrownPotion) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        return potion == Potions.f_43599_ && list.isEmpty();
    }

    private static class EctoSlabMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final EctoSlab ectoSlab;
        private boolean isAggressive;

        public EctoSlabMoveControl(EctoSlab ectoSlab) {
            super((Mob)ectoSlab);
            this.ectoSlab = ectoSlab;
            this.yRot = 180.0f * ectoSlab.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float f, boolean bl) {
            this.yRot = f;
            this.isAggressive = bl;
        }

        public void setWantedMovement(double d) {
            this.f_24978_ = d;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.ectoSlab.getIsUnderground()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    double x = this.f_24975_ - this.f_24974_.m_20185_();
                    double z = this.f_24977_ - this.f_24974_.m_20189_();
                    double y = this.f_24976_ - this.f_24974_.m_20186_();
                    double p = x * x + y * y + z * z;
                    if (p < 2.500000277905201E-7) {
                        this.f_24974_.m_21564_(0.0f);
                        return;
                    }
                    float n = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) - 90.0f;
                    this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), n, 90.0f));
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                } else {
                    this.f_24974_.m_21564_(0.0f);
                }
            } else if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.ectoSlab.m_7549_();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.ectoSlab.m_21569_().m_24901_();
                        if (this.ectoSlab.m_33634_()) {
                            this.ectoSlab.m_5496_(this.ectoSlab.m_7903_(), this.ectoSlab.m_6121_(), this.ectoSlab.m_33642_());
                        }
                    } else {
                        this.ectoSlab.f_20900_ = 0.0f;
                        this.ectoSlab.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class EctoSlabFloatGoal
    extends Goal {
        private final EctoSlab ectoSlab;

        public EctoSlabFloatGoal(EctoSlab ectoSlab) {
            this.ectoSlab = ectoSlab;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            ectoSlab.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.ectoSlab.m_20069_() || this.ectoSlab.m_20077_()) && this.ectoSlab.m_21566_() instanceof EctoSlabMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl var2;
            if (this.ectoSlab.m_217043_().m_188501_() < 0.8f) {
                this.ectoSlab.m_21569_().m_24901_();
            }
            if ((var2 = this.ectoSlab.m_21566_()) instanceof EctoSlabMoveControl) {
                EctoSlabMoveControl slimeMoveControl = (EctoSlabMoveControl)var2;
                slimeMoveControl.setWantedMovement(1.2);
            }
        }
    }

    static class EctoSlabAttackGoal
    extends Goal {
        private final EctoSlab ectoSlab;
        private int undergroundTime;

        public EctoSlabAttackGoal(EctoSlab ectoSlab) {
            this.ectoSlab = ectoSlab;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.ectoSlab.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            return this.ectoSlab.m_6779_(livingEntity) && this.ectoSlab.m_21566_() instanceof EctoSlabMoveControl;
        }

        public void m_8056_() {
            this.undergroundTime = EctoSlabAttackGoal.m_186073_((int)(180 + this.ectoSlab.f_19796_.m_188503_(50)));
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            this.ectoSlab.setAttack(false);
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.ectoSlab.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!this.ectoSlab.m_6779_(livingEntity)) {
                return false;
            }
            return this.ectoSlab.m_33633_() ? this.undergroundTime > -240 : this.undergroundTime > -140;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            MoveControl var3;
            --this.undergroundTime;
            if (this.undergroundTime > 0) {
                this.ectoSlab.setIsUnderground(true);
                this.ectoSlab.m_6210_();
            } else {
                this.ectoSlab.setIsUnderground(false);
                this.ectoSlab.m_6210_();
                this.ectoSlab.setAttack(true);
                this.ectoSlab.damageLivingEntities(this.ectoSlab.m_9236_().m_6443_(LivingEntity.class, this.ectoSlab.m_20191_(), ECTO_SLAB_CAN_DAMAGE));
                for (int i = 0; i < 10; ++i) {
                    this.ectoSlab.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.ectoSlab.m_20075_()), this.ectoSlab.m_20208_(0.3 * (double)this.ectoSlab.m_33632_()), this.ectoSlab.m_20186_(), this.ectoSlab.m_20262_(0.3 * (double)this.ectoSlab.m_33632_()), 0.0, 0.5, 0.0);
                }
            }
            LivingEntity livingEntity = this.ectoSlab.m_5448_();
            if (livingEntity != null) {
                this.ectoSlab.m_21391_((Entity)livingEntity, 10.0f, 10.0f);
            }
            if ((var3 = this.ectoSlab.m_21566_()) instanceof EctoSlabMoveControl) {
                EctoSlabMoveControl ectoSlabMoveControl = (EctoSlabMoveControl)var3;
                ectoSlabMoveControl.setDirection(this.ectoSlab.m_146908_(), this.ectoSlab.m_7483_());
                assert (livingEntity != null);
                if (this.undergroundTime > 20) {
                    ectoSlabMoveControl.m_6849_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), this.ectoSlab.m_21133_(Attributes.f_22279_));
                }
            }
        }
    }

    private static class EctoSlabRandomDirectionGoal
    extends Goal {
        private final EctoSlab ectoSlab;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public EctoSlabRandomDirectionGoal(EctoSlab ectoSlab) {
            this.ectoSlab = ectoSlab;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.ectoSlab.m_5448_() == null && (this.ectoSlab.m_20096_() || this.ectoSlab.m_20069_() || this.ectoSlab.m_20077_() || this.ectoSlab.m_21023_(MobEffects.f_19620_)) && this.ectoSlab.m_21566_() instanceof EctoSlabMoveControl;
        }

        public void m_8037_() {
            MoveControl var2;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.ectoSlab.m_217043_().m_188503_(60));
                this.chosenDegrees = this.ectoSlab.m_217043_().m_188503_(360);
            }
            if ((var2 = this.ectoSlab.m_21566_()) instanceof EctoSlabMoveControl) {
                EctoSlabMoveControl ectoSlabMoveControl = (EctoSlabMoveControl)var2;
                ectoSlabMoveControl.setDirection(this.chosenDegrees, false);
            }
        }
    }

    private static class EctoSlabMoveGoal
    extends Goal {
        private final EctoSlab ectoSlab;

        public EctoSlabMoveGoal(EctoSlab ectoSlab) {
            this.ectoSlab = ectoSlab;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.ectoSlab.m_20159_();
        }

        public void m_8037_() {
            MoveControl var2 = this.ectoSlab.m_21566_();
            if (var2 instanceof EctoSlabMoveControl) {
                EctoSlabMoveControl ectoSlabMoveControl = (EctoSlabMoveControl)var2;
                ectoSlabMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

