/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import net.jadenxgamer.netherexp.registry.item.JNEItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WraithingLesionBlock
extends Block {
    public static final IntegerProperty SLICES = IntegerProperty.m_61631_((String)"slices", (int)1, (int)4);
    protected static final VoxelShape SHAPE_4 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public WraithingLesionBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SLICES, (Comparable)Integer.valueOf(4)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)SLICES)) {
            case 1 -> SHAPE_1;
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            default -> SHAPE_4;
        };
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int slices = (Integer)state.m_61143_((Property)SLICES);
        if (slices == 1) {
            level.m_7471_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SLICES, (Comparable)Integer.valueOf(slices - 1)), 3);
        }
        WraithingLesionBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)new ItemStack((ItemLike)JNEItems.WRAITHING_FLESH.get(), 12));
        level.m_5594_(null, pos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
        WraithingLesionBlock.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.f_123746_);
        return InteractionResult.SUCCESS;
    }

    private static void spawnParticles(Level level, BlockPos blockPos, ParticleOptions particle) {
        Direction[] var5;
        RandomSource randomSource = level.f_46441_;
        for (Direction direction : var5 = Direction.values()) {
            BlockPos blockPos2 = blockPos.m_121945_(direction);
            if (level.m_8055_(blockPos2).m_60804_((BlockGetter)level, blockPos2)) continue;
            Direction.Axis axis = direction.m_122434_();
            double e = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.m_122429_() : (double)randomSource.m_188501_();
            double f = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.m_122430_() : (double)randomSource.m_188501_();
            double g = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.m_122431_() : (double)randomSource.m_188501_();
            level.m_7106_(particle, (double)blockPos.m_123341_() + e, (double)blockPos.m_123342_() + f, (double)blockPos.m_123343_() + g, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)SLICES) < 4;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int slices = (Integer)state.m_61143_((Property)SLICES);
        if (random.m_188503_(10) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SLICES, (Comparable)Integer.valueOf(slices + 1)), 3);
            level.m_5594_(null, pos, SoundEvents.f_11765_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 3; ++i) {
                WraithingLesionBlock.spawnParticles((Level)level, pos, (ParticleOptions)ParticleTypes.f_123749_);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLICES});
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)SLICES) * 3;
    }
}

