/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import java.util.Objects;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SporeshroomBlock
extends Block
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape STANDING_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape HANGING_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (VoxelShape)Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
    protected final int type;
    protected final TagKey<Biome> biome;

    public SporeshroomBlock(BlockBehaviour.Properties properties, int type, TagKey<Biome> biome) {
        super(properties);
        this.type = type;
        this.biome = biome;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean hanging = (Boolean)state.m_61143_((Property)HANGING);
        Vec3 velocity = entity.m_20184_();
        if (!entity.m_6144_() && !hanging) {
            entity.m_5997_(velocity.f_82479_, JNEConfigs.SPORESHROOM_PUSH_VELOCITY.get().doubleValue(), velocity.f_82481_);
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.SPORESHROOM_TRAMPOLINED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean player = Objects.requireNonNull(context.m_43723_()).m_6144_();
        for (Direction direction : context.m_6232_()) {
            BlockState blockState;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockState = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(!player));
        }
        return null;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (SporeshroomBlock.attachedDirection(state).m_122424_() == direction && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected static Direction attachedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? HANGING_SHAPE : STANDING_SHAPE;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = SporeshroomBlock.attachedDirection(state).m_122424_();
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121955_(direction.m_122436_()), (Direction)direction.m_122424_());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        boolean hanging = (Boolean)state.m_61143_((Property)HANGING);
        boolean active = (Boolean)state.m_61143_((Property)ACTIVE);
        boolean homeBiome = level.m_204166_(pos).m_203656_(this.biome);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int l = 0; l < 14; ++l) {
            mutable.m_122178_(i + Mth.m_216271_((RandomSource)random, (int)-20, (int)20), j + random.m_188503_(20), k + Mth.m_216271_((RandomSource)random, (int)-20, (int)20));
            BlockState blockState = level.m_8055_((BlockPos)mutable);
            if (blockState.m_60804_((BlockGetter)level, (BlockPos)mutable) || !active || homeBiome) continue;
            this.biomeParticles(level, mutable, random);
        }
        if (active) {
            this.smokeParticles(level, pos, random, hanging);
        }
    }

    private void biomeParticles(Level level, BlockPos.MutableBlockPos mutable, RandomSource random) {
        switch (this.type) {
            default: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123784_, (double)mutable.m_123341_() + random.m_188500_(), (double)mutable.m_123342_() + random.m_188500_(), (double)mutable.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
                break;
            }
            case 2: 
            case 3: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123785_, (double)mutable.m_123341_() + random.m_188500_(), (double)mutable.m_123342_() + random.m_188500_(), (double)mutable.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void smokeParticles(Level level, BlockPos pos, RandomSource random, boolean hanging) {
        switch (this.type) {
            default: {
                level.m_7106_((ParticleOptions)JNEParticleTypes.CRIMSON_SMOG.get(), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, hanging ? -0.008 : 0.008, 0.0);
                break;
            }
            case 2: {
                level.m_7106_((ParticleOptions)JNEParticleTypes.WARPED_SMOG.get(), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, hanging ? -0.008 : 0.008, 0.0);
                break;
            }
            case 3: {
                level.m_7106_((ParticleOptions)JNEParticleTypes.UMBRAL_SMOG.get(), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, hanging ? -0.008 : 0.008, 0.0);
            }
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos blockPos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.0f, level.m_269111_().m_268989_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HANGING, WATERLOGGED, ACTIVE});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean bl) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos blockPos2 = pos.m_121955_(direction.m_122436_());
        BlockState blockState2 = level.m_8055_(blockPos2.m_7495_());
        boolean h = (Boolean)state.m_61143_((Property)HANGING);
        if (level.m_8055_(blockPos2).m_60795_() && blockState2.m_204336_(BlockTags.f_13077_) && !h) {
            level.m_7731_(blockPos2, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

