/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.jadenxgamer.netherexp.registry.block.custom.AbstractSoulCandleBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulCandleBlock
extends AbstractSoulCandleBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty CANDLES = IntegerProperty.m_61631_((String)"candles", (int)1, (int)3);
    public static final BooleanProperty LIT = AbstractSoulCandleBlock.LIT;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final ToIntFunction<BlockState> STATE_TO_LUMINANCE = state -> (Boolean)state.m_61143_((Property)LIT) != false ? 3 * (Integer)state.m_61143_((Property)CANDLES) : 0;
    private static final Int2ObjectMap<List<Vec3>> CANDLES_TO_PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        int2ObjectMap.defaultReturnValue((Object)ImmutableList.of());
        int2ObjectMap.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.75, 0.5)));
        int2ObjectMap.put(2, (Object)ImmutableList.of((Object)new Vec3(0.3125, 0.625, 0.3125), (Object)new Vec3(0.6875, 0.75, 0.6875)));
        int2ObjectMap.put(3, (Object)ImmutableList.of((Object)new Vec3(0.75, 0.5, 0.3125), (Object)new Vec3(0.5, 0.75, 0.75), (Object)new Vec3(0.25, 0.625, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap);
    });
    private static final VoxelShape ONE_CANDLE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape TWO_CANDLES_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final VoxelShape THREE_CANDLES_SHAPE = Block.m_49796_((double)1.5, (double)0.0, (double)2.5, (double)14.5, (double)10.0, (double)14.5);
    private static final VoxelShape ONE_CANDLE_COLLISION = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
    private static final VoxelShape TWO_CANDLES_COLLISION = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final VoxelShape THREE_CANDLES_COLLISION = Block.m_49796_((double)1.5, (double)0.0, (double)2.5, (double)14.5, (double)8.0, (double)14.5);

    public SoulCandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(1))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        boolean lit = (Boolean)state.m_61143_((Property)LIT);
        boolean bl = false;
        if (player.m_150110_().f_35938_ && itemStack.m_41619_() && lit) {
            SoulCandleBlock.extinguish(player, state, (LevelAccessor)level, pos);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42409_) && !lit && this.canBeLit(state)) {
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            if (!player.m_7500_()) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            bl = true;
        } else if (itemStack.m_150930_(Items.f_42613_) && !lit && this.canBeLit(state)) {
            level.m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            bl = true;
        }
        if (bl) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)CANDLES) < 3) {
            return true;
        }
        return super.m_6864_(state, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61122_((Property)CANDLES);
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.m_61143_((Property)CANDLES)) {
            default: {
                return ONE_CANDLE_SHAPE;
            }
            case 2: {
                return TWO_CANDLES_SHAPE;
            }
            case 3: 
        }
        return THREE_CANDLES_SHAPE;
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Integer)state.m_61143_((Property)CANDLES)) {
            default: {
                return ONE_CANDLE_COLLISION;
            }
            case 2: {
                return TWO_CANDLES_COLLISION;
            }
            case 3: 
        }
        return THREE_CANDLES_COLLISION;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CANDLES, LIT, FACING, WATERLOGGED});
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() || fluidState.m_76152_() != Fluids.f_76193_) {
            return false;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        if (((Boolean)newState.m_61143_((Property)LIT)).booleanValue()) {
            SoulCandleBlock.extinguish(null, state, level, pos);
        } else {
            level.m_7731_(pos, state, 3);
        }
        level.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
        return true;
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return (Iterable)CANDLES_TO_PARTICLE_OFFSETS.get((Object)state.m_61143_((Property)CANDLES));
    }

    @Override
    protected boolean canBeLit(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false && super.canBeLit(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }
}

