/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import com.google.common.collect.Maps;
import dev.architectury.core.block.ArchitecturyLiquidBlock;
import java.util.Map;
import java.util.function.Supplier;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.block.JNEBlocks;
import net.jadenxgamer.netherexp.registry.misc_registry.JNESoundEvents;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;

public class EctoplasmLiquidBlock
extends ArchitecturyLiquidBlock {
    private static Map<Block, Block> FREEZES;

    public EctoplasmLiquidBlock(Supplier<? extends FlowingFluid> fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean bl) {
        super.m_6807_(state, level, pos, oldState, bl);
        if (JNEConfigs.ECTOPLASM_RUSTS_NETHERITE.get().booleanValue()) {
            this.checkFreeze(level, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean bl) {
        super.m_6861_(state, level, pos, block, fromPos, bl);
        if (JNEConfigs.ECTOPLASM_RUSTS_NETHERITE.get().booleanValue()) {
            this.checkFreeze(level, pos);
        }
    }

    public void checkFreeze(Level level, BlockPos pos) {
        Direction[] faces;
        EctoplasmLiquidBlock.initFreeze();
        for (Direction direction : faces = Direction.values()) {
            BlockPos offset = pos.m_121955_(direction.m_122436_());
            BlockState oldState = level.m_8055_(offset);
            if (!FREEZES.containsKey(oldState.m_60734_())) continue;
            BlockState newState = FREEZES.get(oldState.m_60734_()).m_49966_();
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)JNESoundEvents.SOUL_SLATE_SOLIDIFYING.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (Property property : oldState.m_61147_()) {
                newState = newState.m_61138_(property) ? (BlockState)newState.m_61124_(property, oldState.m_61143_(property)) : newState;
            }
            level.m_7731_(offset, newState, 2);
        }
    }

    private static void initFreeze() {
        if (FREEZES != null) {
            return;
        }
        FREEZES = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put((Block)JNEBlocks.NETHERITE_PLATED_BLOCK.get(), (Block)JNEBlocks.RUSTY_NETHERITE_PLATED_BLOCK.get());
            map.put((Block)JNEBlocks.NETHERITE_GRATE.get(), (Block)JNEBlocks.RUSTY_NETHERITE_GRATE.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_BLOCK.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_BLOCK.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_SLAB.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_SLAB.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_STAIRS.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_STAIRS.get());
            map.put((Block)JNEBlocks.CUT_NETHERITE_PILLAR.get(), (Block)JNEBlocks.RUSTY_CUT_NETHERITE_PILLAR.get());
        });
    }
}

