/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.registry.block.custom;

import net.jadenxgamer.netherexp.registry.block.custom.DecayableWartBlock;
import net.jadenxgamer.netherexp.registry.misc_registry.JNETags;
import net.jadenxgamer.netherexp.registry.particle.JNEParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DecayableShroomBlock
extends Block {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)10);
    protected final int type;
    protected final Block persistent;

    public DecayableShroomBlock(BlockBehaviour.Properties properties, int type, Block persistent) {
        super(properties);
        this.type = type;
        this.persistent = persistent;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(10)));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 10;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldDecay(state)) {
            level.m_7471_(pos, false);
        }
    }

    protected boolean shouldDecay(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 10;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_7731_(pos, DecayableShroomBlock.updateDistanceFromStem(state, (LevelAccessor)level, pos), 3);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        int i = DecayableShroomBlock.getDistanceFromStem(neighborState) + 1;
        if (i != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            levelAccessor.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistanceFromStem(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
        Direction[] var5;
        int i = 10;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : var5 = Direction.values()) {
            mutableBlockPos.m_122159_((Vec3i)blockPos, direction);
            i = Math.min(i, DecayableShroomBlock.getDistanceFromStem(levelAccessor.m_8055_((BlockPos)mutableBlockPos)) + 1);
            if (i == 1) break;
        }
        return (BlockState)blockState.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceFromStem(BlockState state) {
        if (state.m_204336_(JNETags.Blocks.STEMS)) {
            return 0;
        }
        if (state.m_60734_() instanceof DecayableWartBlock) {
            return (Integer)state.m_61143_((Property)DISTANCE);
        }
        return 10;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int d = (Integer)state.m_61143_((Property)DISTANCE);
        float f = random.m_188501_();
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() - 0.05;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (d >= 10 && f < 0.3f) {
            switch (this.type) {
                default: {
                    level.m_7106_((ParticleOptions)JNEParticleTypes.FALLING_SHROOMLIGHT.get(), x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    level.m_7106_((ParticleOptions)JNEParticleTypes.FALLING_SHROOMNIGHT.get(), x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE});
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.persistent);
    }
}

