/*
 * Decompiled with CFR 0.152.
 */
package net.jadenxgamer.netherexp.mixin.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.platform.Platform;
import net.jadenxgamer.netherexp.config.JNEConfigs;
import net.jadenxgamer.netherexp.registry.entity.client.FireballModel;
import net.jadenxgamer.netherexp.registry.entity.client.GhastFireBallModel;
import net.jadenxgamer.netherexp.registry.entity.client.JNEModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.LargeFireball;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={ThrownItemRenderer.class})
public abstract class ThrownItemRendererMixin<T extends Entity>
extends EntityRenderer<T> {
    @Unique
    private GhastFireBallModel<T> largeFireballModel;
    @Unique
    private FireballModel<T> fireballModel;
    @Unique
    private boolean isConfigEnabled = JNEConfigs.REDESIGNED_FIREBALLS.get();

    protected ThrownItemRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @Unique
    private boolean noEntityTextureModelFeature() {
        return !Platform.isModLoaded((String)"entity_model_features") && !Platform.isModLoaded((String)"entity_texture_features");
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V"}, at={@At(value="TAIL")})
    private void netherexp$init(EntityRendererProvider.Context context, CallbackInfo ci) {
        if (!this.noEntityTextureModelFeature()) {
            return;
        }
        if (this.isConfigEnabled) {
            this.largeFireballModel = new GhastFireBallModel(context.m_174023_(JNEModelLayers.GHAST_FIREBALL_LAYER));
            this.fireballModel = new FireballModel(context.m_174023_(JNEModelLayers.FIREBALL_LAYER));
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;FZ)V"}, at={@At(value="TAIL")})
    private void netherexp$initTwo(EntityRendererProvider.Context context, float f, boolean bl, CallbackInfo ci) {
        if (!this.noEntityTextureModelFeature()) {
            return;
        }
        if (this.isConfigEnabled) {
            this.largeFireballModel = new GhastFireBallModel(context.m_174023_(JNEModelLayers.GHAST_FIREBALL_LAYER));
            this.fireballModel = new FireballModel(context.m_174023_(JNEModelLayers.FIREBALL_LAYER));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$render(T entity, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo cir) {
        if (this.isConfigEnabled) {
            if (entity instanceof LargeFireball && this.largeFireballModel != null) {
                cir.cancel();
                poseStack.m_85836_();
                poseStack.m_85841_(1.5f, 1.5f, 1.5f);
                poseStack.m_85837_(0.0, -0.8, 0.0);
                VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.m_5478_((Entity)entity)));
                this.largeFireballModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            } else if (entity instanceof Fireball && this.fireballModel != null) {
                cir.cancel();
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, -1.0, 0.0);
                VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)this.m_5478_((Entity)entity)));
                this.fireballModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                poseStack.m_85849_();
            }
        }
    }

    @Inject(method={"getTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    private void netherexp$getTextureLocation(Entity entity, CallbackInfoReturnable<ResourceLocation> cir) {
        if (this.isConfigEnabled) {
            if (entity instanceof LargeFireball) {
                cir.setReturnValue((Object)new ResourceLocation("netherexp", "textures/entity/ghast_fireball.png"));
            } else if (entity instanceof Fireball) {
                cir.setReturnValue((Object)new ResourceLocation("netherexp", "textures/entity/fireball.png"));
            }
        }
    }
}

