/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysiclite;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.ICreativeLoader;
import team.creative.creativecore.client.ClientLoader;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.itemphysiclite.ItemPhysicLiteConfig;
import team.creative.itemphysiclite.mixin.EntityAccessor;

@Mod(value="itemphysiclite")
public class ItemPhysicLite
implements ClientLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"itemphysiclite");
    public static final String MODID = "itemphysiclite";
    private static Minecraft mc = Minecraft.m_91087_();
    public static ItemPhysicLiteConfig CONFIG;
    public static long lastTickTime;
    private static final double RANDOM_Y_OFFSET_SCALE = 0.007957747154594767;

    public static boolean render(ItemEntity entity, float entityYaw, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, ItemRenderer itemRenderer, RandomSource rand) {
        boolean applyEffects;
        Vec3 motionMultiplier;
        if (entity.m_32059_() == 0) {
            return false;
        }
        pose.m_85836_();
        ItemStack itemstack = entity.m_32055_();
        rand.m_188584_(itemstack.m_41619_() ? 187L : (long)(Item.m_41393_((Item)itemstack.m_41720_()) + itemstack.m_41773_()));
        BakedModel bakedmodel = itemRenderer.m_174264_(itemstack, entity.m_9236_(), (LivingEntity)null, entity.m_19879_());
        boolean flag = bakedmodel.m_7539_();
        int j = ItemPhysicLite.getModelCount(itemstack);
        float rotateBy = (float)(System.nanoTime() - lastTickTime) / 2.0E8f * ItemPhysicLite.CONFIG.rotateSpeed;
        if (mc.m_91104_()) {
            rotateBy = 0.0f;
        }
        if ((motionMultiplier = ItemPhysicLite.getStuckSpeedMultiplier((Entity)entity)) != null && motionMultiplier.m_82556_() > 0.0) {
            rotateBy = (float)((double)rotateBy * (motionMultiplier.f_82479_ * 0.2));
        }
        pose.m_252781_(Axis.f_252529_.m_252961_(1.5707964f));
        pose.m_252781_(Axis.f_252403_.m_252961_(entity.m_146908_()));
        boolean bl = applyEffects = entity.m_32059_() != 0 && (flag || ItemPhysicLite.mc.f_91066_ != null);
        if (applyEffects) {
            if (flag) {
                if (!entity.m_20096_()) {
                    rotateBy *= 2.0f;
                    fluid = ItemPhysicLite.getFluid(entity);
                    if (fluid == null) {
                        fluid = ItemPhysicLite.getFluid(entity, true);
                    }
                    if (fluid != null) {
                        rotateBy /= 1.0f + ItemPhysicLite.getViscosity(fluid, entity.m_9236_());
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                }
            } else if (!(entity == null || Double.isNaN(entity.m_20185_()) || Double.isNaN(entity.m_20186_()) || Double.isNaN(entity.m_20189_()) || entity.m_9236_() == null)) {
                if (entity.m_20096_()) {
                    if (!flag) {
                        entity.m_146926_(0.0f);
                    }
                } else {
                    rotateBy *= 2.0f;
                    fluid = ItemPhysicLite.getFluid(entity);
                    if (fluid != null) {
                        rotateBy /= 1.0f + ItemPhysicLite.getViscosity(fluid, entity.m_9236_());
                    }
                    entity.m_146926_(entity.m_146909_() + rotateBy);
                }
            }
            if (flag) {
                pose.m_85837_(0.0, -0.2, -0.08);
            } else if (ItemPhysicLite.CONFIG.blockRequireOffset.is(entity.m_9236_().m_8055_(entity.m_20183_())) || ItemPhysicLite.CONFIG.blockBelowRequireOffset.is(entity.m_9236_().m_8055_(entity.m_20183_().m_7495_()))) {
                pose.m_85837_(0.0, 0.0, -0.14 - (double)entity.f_31983_ * 0.007957747154594767);
            } else {
                pose.m_85837_(0.0, 0.0, -0.04 - (double)entity.f_31983_ * 0.007957747154594767);
            }
            double height = 0.2;
            if (flag) {
                pose.m_85837_(0.0, height, 0.0);
            }
            pose.m_252781_(Axis.f_252436_.m_252961_(entity.m_146909_()));
            if (flag) {
                pose.m_85837_(0.0, -height, 0.0);
            }
        }
        if (!flag) {
            float f7 = -0.0f * (float)(j - 1) * 0.5f;
            float f8 = -0.0f * (float)(j - 1) * 0.5f;
            float f9 = -0.09375f * (float)(j - 1) * 0.5f;
            pose.m_252880_(f7, f8, f9);
        }
        for (int k = 0; k < j; ++k) {
            pose.m_85836_();
            if (k > 0 && flag) {
                float f11 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                float f13 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                float f10 = (rand.m_188501_() * 2.0f - 1.0f) * 0.15f;
                pose.m_252880_(f11, f13, f10);
            }
            itemRenderer.m_115143_(itemstack, ItemDisplayContext.GROUND, false, pose, buffer, packedLight, OverlayTexture.f_118083_, bakedmodel);
            pose.m_85849_();
            if (flag) continue;
            pose.m_85837_(0.0, 0.0, 0.09375);
        }
        pose.m_85849_();
        return true;
    }

    public static Fluid getFluid(ItemEntity item) {
        return ItemPhysicLite.getFluid(item, false);
    }

    public static Fluid getFluid(ItemEntity item, boolean below) {
        FluidState state;
        Fluid fluid;
        if (item.m_9236_() == null) {
            return null;
        }
        double d0 = item.m_20182_().f_82480_;
        BlockPos pos = item.m_20183_();
        if (below) {
            pos = pos.m_7495_();
        }
        if ((fluid = (state = item.m_9236_().m_6425_(pos)).m_76152_()) == null || fluid.m_6718_((LevelReader)item.m_9236_()) == 0) {
            return null;
        }
        if (below) {
            return fluid;
        }
        double filled = state.m_76155_((BlockGetter)item.m_9236_(), pos);
        if (d0 - (double)pos.m_123342_() - 0.2 <= filled) {
            return fluid;
        }
        return null;
    }

    public static int getModelCount(ItemStack stack) {
        if (stack.m_41613_() > 48) {
            return 5;
        }
        if (stack.m_41613_() > 32) {
            return 4;
        }
        if (stack.m_41613_() > 16) {
            return 3;
        }
        if (stack.m_41613_() > 1) {
            return 2;
        }
        return 1;
    }

    public static Vec3 getStuckSpeedMultiplier(Entity entity) {
        return ((EntityAccessor)entity).getStuckSpeedMultiplier();
    }

    public static float getViscosity(Fluid fluid, Level level) {
        if (fluid == null) {
            return 0.0f;
        }
        return CreativeCore.loader().getFluidViscosityMultiplier(fluid, level);
    }

    public ItemPhysicLite() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerClient((ClientLoader)this);
    }

    public void onInitializeClient() {
        ICreativeLoader loader = CreativeCore.loader();
        loader.registerDisplayTest(() -> loader.ignoreServerNetworkConstant(), (a, b) -> true);
        loader.registerClientRenderGui(x -> {
            lastTickTime = System.nanoTime();
        });
        CONFIG = new ItemPhysicLiteConfig();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG, ConfigSynchronization.CLIENT, false);
    }
}

