/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import fuzs.forgeconfigscreens.client.gui.screens.ConfigScreen;
import fuzs.forgeconfigscreens.client.gui.widget.ConfigEditBox;
import fuzs.forgeconfigscreens.client.gui.widget.MutableIconButton;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class EditListScreen
extends Screen {
    private final Screen lastScreen;
    private final List<MutableObject<String>> values;
    private final Predicate<String> validator;
    private final Consumer<List<String>> onSave;
    private final Set<EditEntry> invalidEntries = Sets.newHashSet();
    private EditList list;
    private Button doneButton;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends FormattedCharSequence> activeTooltip;
    private int tooltipTicks;

    public EditListScreen(Screen lastScreen, Component title, List<String> listValue, Predicate<String> validator, Consumer<List<String>> onSave) {
        super(title);
        this.lastScreen = lastScreen;
        this.values = listValue.stream().map(MutableObject::new).collect(Collectors.toList());
        this.validator = validator;
        this.onSave = onSave;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    protected void m_7856_() {
        this.list = new EditList(this.values);
        this.m_7787_((GuiEventListener)this.list);
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.onSave.accept(this.values.stream().map(MutableObject::getValue).collect(Collectors.toList()));
            this.f_96541_.m_91152_(this.lastScreen);
        }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.lastScreen)).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<? extends FormattedCharSequence> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        this.m_280273_(guiGraphics);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 14, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            guiGraphics.m_280245_(this.f_96547_, this.activeTooltip, mouseX, mouseY);
        }
    }

    public void m_86600_() {
        if (this.activeTextField != null) {
            this.activeTextField.m_94120_();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    private void updateDoneButton() {
        if (this.doneButton != null) {
            this.doneButton.f_93623_ = this.invalidEntries.isEmpty();
        }
    }

    void markInvalid(EditEntry entry) {
        this.invalidEntries.add(entry);
        this.updateDoneButton();
    }

    void clearInvalid(EditEntry entry) {
        this.invalidEntries.remove((Object)entry);
        this.updateDoneButton();
    }

    public class EditList
    extends ContainerObjectSelectionList<EditListEntry> {
        public EditList(List<MutableObject<String>> values) {
            super(EditListScreen.this.f_96541_, EditListScreen.this.f_96543_, EditListScreen.this.f_96544_, 36, EditListScreen.this.f_96544_ - 36, 24);
            values.forEach(value -> this.m_7085_((AbstractSelectionList.Entry)new EditEntry(this, (MutableObject<String>)value)));
            this.m_7085_((AbstractSelectionList.Entry)new AddEntry(this, values));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        protected int addEntry(int index, EditListEntry entry) {
            this.m_6702_().add(index, entry);
            return this.m_6702_().size() - 1;
        }

        protected boolean removeEntry(EditListEntry entry) {
            return super.m_93502_((AbstractSelectionList.Entry)entry);
        }
    }

    private class EditEntry
    extends EditListEntry {
        private final MutableObject<String> holder;
        private final ConfigEditBox textField;
        private final Button deleteButton;

        public EditEntry(EditList list, MutableObject<String> holder) {
            this(list, holder, false);
        }

        public EditEntry(EditList list, MutableObject<String> holder, boolean withFocus) {
            this.holder = holder;
            this.textField = new ConfigEditBox(EditListScreen.this.f_96547_, 0, 0, 236, 18, () -> EditListScreen.this.activeTextField, activeTextField -> {
                EditListScreen.this.activeTextField = activeTextField;
            }){

                @Override
                public void m_93692_(boolean focused) {
                    super.m_93692_(focused);
                    EditListScreen.this.activeTextField = focused ? this : null;
                }
            };
            this.textField.m_94151_(input -> {
                if (EditListScreen.this.validator.test((String)input)) {
                    this.textField.markInvalid(false);
                    this.holder.setValue(input);
                    EditListScreen.this.clearInvalid(this);
                } else {
                    this.textField.markInvalid(true);
                    EditListScreen.this.markInvalid(this);
                }
            });
            this.textField.m_94199_(32500);
            this.textField.m_94144_((String)holder.getValue());
            this.textField.m_93692_(withFocus);
            final List tooltip = ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configmenusforge.gui.tooltip.remove"), 200);
            this.deleteButton = new MutableIconButton(0, 0, 20, 20, 100, 0, ConfigScreen.ICONS_LOCATION, button -> {
                EditListScreen.this.values.remove(holder);
                list.removeEntry(this);
                EditListScreen.this.clearInvalid(this);
            }){

                @Override
                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.f_93623_) {
                        EditListScreen.this.activeTooltip = tooltip;
                    }
                }
            };
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.textField.m_252865_(entryLeft);
            this.textField.m_253211_(entryTop + 1);
            this.textField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.deleteButton.m_252865_(entryLeft + rowWidth - 21);
            this.deleteButton.m_253211_(entryTop);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)((Object)this.textField), (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169143_(NarratedElementType.TITLE, (String)EditEntry.this.holder.getValue());
                }
            }, (Object)((Object)this.textField), (Object)this.deleteButton);
        }
    }

    private class AddEntry
    extends EditListEntry {
        private final Button addButton;

        public AddEntry(EditList list, List<MutableObject<String>> values) {
            final List tooltip = ((EditListScreen)EditListScreen.this).f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"configmenusforge.gui.tooltip.add"), 200);
            this.addButton = new MutableIconButton(0, 0, 20, 20, 80, 0, ConfigScreen.ICONS_LOCATION, button -> {
                MutableObject holder = new MutableObject((Object)"");
                values.add(holder);
                list.addEntry(list.m_6702_().size() - 1, new EditEntry(list, (MutableObject<String>)holder, true));
            }){

                @Override
                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.f_93623_) {
                        EditListScreen.this.activeTooltip = tooltip;
                    }
                }
            };
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            this.addButton.m_252865_(entryLeft + rowWidth - 21);
            this.addButton.m_253211_(entryTop);
            this.addButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.addButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                }
            }, (Object)this.addButton);
        }
    }

    public static abstract class EditListEntry
    extends ContainerObjectSelectionList.Entry<EditListEntry> {
    }
}

