/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.EntryData;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.helper.ScreenTextHelper;
import fuzs.forgeconfigscreens.client.gui.screens.EditEnumScreen;
import fuzs.forgeconfigscreens.client.gui.screens.EditListScreen;
import fuzs.forgeconfigscreens.client.gui.screens.EditStringScreen;
import fuzs.forgeconfigscreens.client.gui.widget.ConfigEditBox;
import fuzs.forgeconfigscreens.client.gui.widget.MutableIconButton;
import fuzs.forgeconfigscreens.client.helper.ServerConfigUploader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigScreen
extends Screen {
    public static final ResourceLocation ICONS_LOCATION = ForgeConfigScreens.id("textures/gui/icons.png");
    public static final Component SORTING_AZ_TOOLTIP = Component.m_237110_((String)"configmenusforge.gui.tooltip.sorting", (Object[])new Object[]{Component.m_237115_((String)"configmenusforge.gui.tooltip.sorting.az")});
    public static final Component SORTING_ZA_TOOLTIP = Component.m_237110_((String)"configmenusforge.gui.tooltip.sorting", (Object[])new Object[]{Component.m_237115_((String)"configmenusforge.gui.tooltip.sorting.za")});
    final Screen lastScreen;
    private final List<IEntryData> searchEntries;
    private final List<IEntryData> screenEntries;
    final Map<Object, IEntryData> valueToData;
    private ConfigList list;
    EditBox searchTextField;
    private Button reverseButton;
    private Button filterButton;
    private Button searchFilterButton;
    private final int[] buttonData;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends FormattedCharSequence> activeTooltip;
    private int tooltipTicks;

    private ConfigScreen(Screen lastScreen, Component title, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, int[] buttonData) {
        super(title);
        this.lastScreen = lastScreen;
        this.valueToData = valueToData;
        this.buttonData = buttonData;
        this.searchEntries = this.gatherEntriesRecursive(config, valueToData);
        this.screenEntries = config.valueMap().values().stream().map(valueToData::get).toList();
        this.buildSubScreens(this.screenEntries);
    }

    private List<IEntryData> gatherEntriesRecursive(UnmodifiableConfig mainConfig, Map<Object, IEntryData> allEntries) {
        ArrayList entries = Lists.newArrayList();
        this.gatherEntriesRecursive(mainConfig, entries, allEntries);
        return ImmutableList.copyOf((Collection)entries);
    }

    private void gatherEntriesRecursive(UnmodifiableConfig mainConfig, List<IEntryData> entries, Map<Object, IEntryData> allEntries) {
        mainConfig.valueMap().values().forEach(value -> {
            entries.add((IEntryData)allEntries.get(value));
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig config = (UnmodifiableConfig)value;
                this.gatherEntriesRecursive(config, entries, allEntries);
            }
        });
    }

    private void buildSubScreens(List<IEntryData> screenEntries) {
        for (IEntryData unit : screenEntries) {
            if (!(unit instanceof EntryData.CategoryEntryData)) continue;
            EntryData.CategoryEntryData categoryEntryData = (EntryData.CategoryEntryData)unit;
            categoryEntryData.setScreen(new Sub(this, categoryEntryData.getTitle(), categoryEntryData.getConfig()));
        }
    }

    public static ConfigScreen create(Screen lastScreen, Component title, ModConfig config, Map<Object, IEntryData> valueToData) {
        UnmodifiableConfig unmodifiableConfig = ServerConfigUploader.findForgeConfigSpec(config.getSpec()).map(ForgeConfigSpec::getValues).orElseThrow();
        return new Main(lastScreen, title, unmodifiableConfig, valueToData, () -> ServerConfigUploader.saveAndUpload(config));
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean focus = this.searchTextField != null && this.searchTextField.m_93696_();
        this.searchTextField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 121, 22, 242, 20, this.searchTextField, CommonComponents.f_237098_){

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.m_94213_() && button == 1) {
                    this.m_94144_("");
                }
                return super.m_6375_(mouseX, mouseY, button);
            }
        };
        this.searchTextField.m_94151_(query -> this.updateList((String)query, true));
        this.searchTextField.m_93692_(focus);
        this.list = new ConfigList(this.getConfigListEntries(this.searchTextField.m_94155_()));
        this.m_7787_((GuiEventListener)this.list);
        this.m_7787_((GuiEventListener)this.searchTextField);
        this.reverseButton = (Button)this.m_142416_((GuiEventListener)new MutableIconButton(this.f_96543_ / 2 - 126 - 20, 22, 20, 20, this.buttonData[0] == 1 ? 20 : 0, 0, ICONS_LOCATION, button -> {
            this.buttonData[0] = (this.buttonData[0] + 1) % 2;
            this.updateList(true);
            ((MutableIconButton)button).setTexture(this.buttonData[0] == 1 ? 20 : 0, 0);
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.f_93623_ && this.m_198029_()) {
                    guiGraphics.m_280557_(ConfigScreen.this.f_96547_, ConfigScreen.this.buttonData[0] == 1 ? SORTING_ZA_TOOLTIP : SORTING_AZ_TOOLTIP, mouseX, mouseY);
                }
            }
        });
        this.filterButton = (Button)this.m_142416_((GuiEventListener)new MutableIconButton(this.f_96543_ / 2 + 126, 22, 20, 20, EntryFilter.values()[this.buttonData[1]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[1] = EntryFilter.cycle(this.buttonData[1], false, Screen.m_96638_());
            this.updateList(true);
            ((MutableIconButton)button).setTexture(EntryFilter.values()[this.buttonData[1]].getTextureX(), 0);
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.f_93623_ && this.m_198029_()) {
                    guiGraphics.m_280557_(ConfigScreen.this.f_96547_, EntryFilter.values()[ConfigScreen.this.buttonData[1]].getMessage(), mouseX, mouseY);
                }
            }
        });
        this.searchFilterButton = (Button)this.m_142416_((GuiEventListener)new MutableIconButton(this.f_96543_ / 2 + 126 + 24, 22, 20, 20, EntryFilter.values()[this.buttonData[2]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[2] = EntryFilter.cycle(this.buttonData[2], true, Screen.m_96638_());
            this.updateList(true);
            ((MutableIconButton)button).setTexture(EntryFilter.values()[this.buttonData[2]].getTextureX(), 0);
        }){

            @Override
            public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.f_93623_ && this.m_198029_()) {
                    guiGraphics.m_280557_(ConfigScreen.this.f_96547_, EntryFilter.values()[ConfigScreen.this.buttonData[2]].getMessage(), mouseX, mouseY);
                }
            }
        });
    }

    public void updateList(boolean resetScroll) {
        this.updateList(this.searchTextField.m_94155_(), resetScroll);
    }

    private void updateList(String query, boolean resetScroll) {
        this.list.replaceEntries(this.getConfigListEntries(query), resetScroll);
        this.onSearchFieldChanged(query.trim().isEmpty());
    }

    private List<Entry> getConfigListEntries(String query) {
        return this.getConfigListEntries(!(query = query.toLowerCase(Locale.ROOT).trim()).isEmpty() ? this.searchEntries : this.screenEntries, query);
    }

    List<Entry> getConfigListEntries(List<IEntryData> entries, String searchHighlight) {
        boolean empty = searchHighlight.isEmpty();
        return entries.stream().filter(data -> data.mayInclude(searchHighlight) && EntryFilter.values()[empty ? this.buttonData[1] : this.buttonData[2]].test((IEntryData)data, empty)).sorted(IEntryData.getSearchComparator(searchHighlight, this.buttonData[0] == 1)).map(entryData -> this.makeEntry((IEntryData)entryData, searchHighlight)).filter(Objects::nonNull).toList();
    }

    void onSearchFieldChanged(boolean isEmpty) {
        this.reverseButton.f_93624_ = isEmpty;
        this.filterButton.f_93624_ = isEmpty;
        this.searchFilterButton.f_93624_ = !isEmpty;
    }

    public void m_86600_() {
        this.searchTextField.m_94120_();
        if (this.activeTextField != null) {
            this.activeTextField.m_94120_();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<? extends FormattedCharSequence> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        this.m_280273_(guiGraphics);
        this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawBaseTitle(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            guiGraphics.m_280245_(this.f_96547_, this.activeTooltip, mouseX, mouseY);
        }
    }

    void drawBaseTitle(GuiGraphics guiGraphics) {
        guiGraphics.m_280653_(this.f_96547_, this.m_96636_(), this.f_96543_ / 2, 7, 0xFFFFFF);
    }

    public abstract void m_7379_();

    void setActiveTooltip(@Nullable List<? extends FormattedCharSequence> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    Entry makeEntry(IEntryData entryData, String searchHighlight) {
        if (entryData instanceof EntryData.CategoryEntryData) {
            EntryData.CategoryEntryData categoryData = (EntryData.CategoryEntryData)entryData;
            return new CategoryEntry(categoryData, searchHighlight);
        }
        if (entryData instanceof EntryData.ConfigEntryData) {
            EntryData.ConfigEntryData configEntryData = (EntryData.ConfigEntryData)entryData;
            Object currentValue = configEntryData.getCurrentValue();
            if (currentValue instanceof Boolean) {
                return new BooleanEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof Integer) {
                return new NumberEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, Integer::parseInt);
            }
            if (currentValue instanceof Double) {
                return new NumberEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, Double::parseDouble);
            }
            if (currentValue instanceof Long) {
                return new NumberEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, Long::parseLong);
            }
            if (currentValue instanceof Enum) {
                return new EnumEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof String) {
                return new StringEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof List) {
                List listValue = (List)currentValue;
                Object value = this.getListValue((List)((EntryData.ConfigEntryData)entryData).getDefaultValue(), listValue);
                try {
                    return this.makeListEntry(entryData, searchHighlight, value);
                }
                catch (RuntimeException e) {
                    ForgeConfigScreens.LOGGER.warn("Unable to add list entry containing class type {}", (Object)(value != null ? value.getClass().getSimpleName() : "null"), (Object)e);
                    return null;
                }
            }
            ForgeConfigScreens.LOGGER.warn("Unsupported config value of class type {}", (Object)currentValue.getClass().getSimpleName());
        }
        return null;
    }

    private ListEntry<?> makeListEntry(IEntryData entryData, String searchHighlight, Object value) throws RuntimeException {
        if (value instanceof Boolean) {
            return new ListEntry<Boolean>((EntryData.ConfigEntryData)entryData, searchHighlight, "Boolean", v -> switch (v.toLowerCase(Locale.ROOT)) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException("unable to convert boolean value");
            });
        }
        if (value instanceof Integer) {
            return new ListEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, "Integer", Integer::parseInt);
        }
        if (value instanceof Double) {
            return new ListEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, "Double", Double::parseDouble);
        }
        if (value instanceof Long) {
            return new ListEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, "Long", Long::parseLong);
        }
        if (value instanceof Enum) {
            return new EnumListEntry((EntryData.ConfigEntryData)entryData, searchHighlight, value.getClass());
        }
        if (value instanceof String) {
            return new ListEntry<String>((EntryData.ConfigEntryData)entryData, searchHighlight, "String", s -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }
        return new DangerousListEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
    }

    @Nullable
    private Object getListValue(List<?> defaultValue, List<?> currentValue) {
        if (!defaultValue.isEmpty()) {
            return defaultValue.get(0);
        }
        if (!currentValue.isEmpty()) {
            return currentValue.get(0);
        }
        return null;
    }

    private static class Sub
    extends ConfigScreen {
        private Sub(ConfigScreen lastScreen, Component title, UnmodifiableConfig config) {
            super(lastScreen, title, config, lastScreen.valueToData, lastScreen.buttonData);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20).m_253136_());
            this.makeNavigationButtons().forEach(x$0 -> {
                Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
            });
            this.onSearchFieldChanged(this.searchTextField.m_94155_().trim().isEmpty());
        }

        private List<Button> makeNavigationButtons() {
            List<Screen> lastScreens = this.getLastScreens();
            int maxSize = 5;
            LinkedList buttons = Lists.newLinkedList();
            int size = Math.min(5, lastScreens.size());
            for (int i = 0; i < size; ++i) {
                Screen screen = lastScreens.get(size - 1 - i);
                final boolean otherScreen = screen != this;
                Component title = i == 0 && lastScreens.size() > 5 ? Component.m_237113_((String)". . .") : screen.m_96636_();
                buttons.add(new Button(0, 1, this.f_96547_.m_92852_((FormattedText)title) + 4, 20, title, button -> {
                    if (otherScreen) {
                        this.f_96541_.m_91152_(screen);
                    }
                }, Supplier::get){

                    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        int color = otherScreen && this.m_198029_() ? 0xFFFF55 : 0xFFFFFF;
                        guiGraphics.m_280653_(f_96547_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, color);
                        if (this.m_198029_() && otherScreen && this.f_93623_) {
                            guiGraphics.m_280557_(f_96547_, CommonComponents.f_130660_, mouseX, mouseY + 24);
                        }
                    }

                    public void m_7435_(SoundManager soundManager) {
                        if (otherScreen) {
                            super.m_7435_(soundManager);
                        }
                    }
                });
                if (i >= size - 1) continue;
                buttons.add(new Button(0, 1, this.f_96547_.m_92895_(">") + 4, 20, (Component)Component.m_237113_((String)">"), button -> {}, Supplier::get){

                    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        guiGraphics.m_280653_(f_96547_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, 0xFFFFFF);
                    }

                    public void m_7435_(SoundManager soundManager) {
                    }
                });
            }
            this.setButtonPosX(buttons);
            return buttons;
        }

        private List<Screen> getLastScreens() {
            Sub lastScreen = this;
            LinkedList lastScreens = Lists.newLinkedList();
            while (lastScreen instanceof ConfigScreen) {
                ConfigScreen configScreen = lastScreen;
                lastScreens.add(lastScreen);
                lastScreen = configScreen.lastScreen;
            }
            return lastScreens;
        }

        private void setButtonPosX(List<Button> buttons) {
            int posX = (this.f_96543_ - buttons.stream().mapToInt(AbstractWidget::m_5711_).sum()) / 2;
            for (Button navigationButton : buttons) {
                navigationButton.m_252865_(posX);
                posX += navigationButton.m_5711_();
            }
        }

        @Override
        void drawBaseTitle(GuiGraphics guiGraphics) {
        }

        @Override
        public void m_7379_() {
            if (!this.searchTextField.m_94155_().isEmpty()) {
                this.searchTextField.m_94144_("");
            } else {
                this.f_96541_.m_91152_(this.lastScreen);
            }
        }
    }

    private static class Main
    extends ConfigScreen {
        private final Runnable onSave;
        private Button doneButton;
        private Button cancelButton;
        private Button backButton;

        private Main(Screen lastScreen, Component title, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, Runnable onSave) {
            super(lastScreen, title, config, valueToData, new int[3]);
            this.onSave = onSave;
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
                if (this.valueToData.values().stream().anyMatch(Predicate.not(IEntryData::mayDiscardChanges))) {
                    this.valueToData.values().forEach(IEntryData::saveConfigValue);
                    this.onSave.run();
                }
                this.f_96541_.m_91152_(this.lastScreen);
            }).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20).m_253136_());
            this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20).m_253136_());
            this.backButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> this.searchTextField.m_94144_("")).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 28, 200, 20).m_253136_());
            this.onSearchFieldChanged(this.searchTextField.m_94155_().trim().isEmpty());
        }

        @Override
        void onSearchFieldChanged(boolean empty) {
            super.onSearchFieldChanged(empty);
            this.doneButton.f_93624_ = empty;
            this.cancelButton.f_93624_ = empty;
            this.backButton.f_93624_ = !empty;
        }

        @Override
        public void m_7379_() {
            if (!this.searchTextField.m_94155_().isEmpty()) {
                this.searchTextField.m_94144_("");
            } else {
                Object confirmScreen = this.valueToData.values().stream().allMatch(IEntryData::mayDiscardChanges) ? this.lastScreen : new ConfirmScreen(result -> {
                    if (result) {
                        this.valueToData.values().forEach(IEntryData::discardCurrentValue);
                        this.f_96541_.m_91152_(this.lastScreen);
                    } else {
                        this.f_96541_.m_91152_((Screen)this);
                    }
                }, (Component)Component.m_237115_((String)"configmenusforge.gui.message.discard"), (Component)Component.m_237119_());
                this.f_96541_.m_91152_(confirmScreen);
            }
        }
    }

    public class ConfigList
    extends ContainerObjectSelectionList<Entry> {
        public ConfigList(List<Entry> entries) {
            super(ConfigScreen.this.f_96541_, ConfigScreen.this.f_96543_, ConfigScreen.this.f_96544_, 50, ConfigScreen.this.f_96544_ - 36, 24);
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        protected void replaceEntries(Collection<Entry> entries, boolean resetScroll) {
            super.m_5988_(entries);
            if (resetScroll) {
                this.m_93410_(0.0);
            }
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            Entry entry;
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.m_5953_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.m_5747_() + ConfigScreen.this.list.m_5759_() - 67 && (entry = (Entry)this.m_168795_()) != null) {
                ConfigScreen.this.setActiveTooltip(entry.getTooltip());
            }
        }
    }

    private static enum EntryFilter {
        ALL(6, "configmenusforge.gui.tooltip.showing.all", data -> true),
        ENTRIES(2, "configmenusforge.gui.tooltip.showing.entries", Predicate.not(IEntryData::category), true),
        CATEGORIES(8, "configmenusforge.gui.tooltip.showing.categories", IEntryData::category, true),
        EDITED(3, "configmenusforge.gui.tooltip.showing.edited", Predicate.not(IEntryData::mayDiscardChanges)),
        RESETTABLE(7, "configmenusforge.gui.tooltip.showing.resettable", IEntryData::mayResetValue);

        private static final String SHOWING_TRANSLATION_KEY = "configmenusforge.gui.tooltip.showing";
        private static final int[] DEFAULT_FILTERS_INDICES;
        private final int textureX;
        private final Component message;
        private final Predicate<IEntryData> predicate;
        private final boolean searchOnly;

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate) {
            this(textureIndex, translationKey, predicate, false);
        }

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate, boolean searchOnly) {
            this.textureX = textureIndex * 20;
            this.message = Component.m_237110_((String)SHOWING_TRANSLATION_KEY, (Object[])new Object[]{Component.m_237115_((String)translationKey)});
            this.predicate = predicate;
            this.searchOnly = searchOnly;
        }

        public int getTextureX() {
            return this.textureX;
        }

        public Component getMessage() {
            return this.message;
        }

        public boolean test(IEntryData data, boolean empty) {
            return this.predicate.test(data) || empty && data.category();
        }

        private boolean searchOnly() {
            return this.searchOnly;
        }

        public static int cycle(int index, boolean search, boolean reversed) {
            if (!search) {
                for (int i = 0; i < DEFAULT_FILTERS_INDICES.length; ++i) {
                    if (DEFAULT_FILTERS_INDICES[i] != index) continue;
                    index = i;
                    break;
                }
            }
            int length = search ? EntryFilter.values().length : DEFAULT_FILTERS_INDICES.length;
            int amount = reversed ? -1 : 1;
            index = (index + amount + length) % length;
            return search ? index : DEFAULT_FILTERS_INDICES[index];
        }

        static {
            DEFAULT_FILTERS_INDICES = Stream.of(EntryFilter.values()).filter(Predicate.not(EntryFilter::searchOnly)).mapToInt(Enum::ordinal).toArray();
        }
    }

    private class CategoryEntry
    extends Entry {
        private final Button button;

        public CategoryEntry(EntryData.CategoryEntryData data, String searchHighlight) {
            super(data, searchHighlight);
            this.button = Button.m_253074_((Component)this.getTitle(), button -> {
                ConfigScreen.this.searchTextField.m_94144_("");
                ConfigScreen.this.searchTextField.m_93692_(false);
                ConfigScreen.this.f_96541_.m_91152_((Screen)data.getScreen());
            }).m_252987_(10, 5, 260, 20).m_253136_();
        }

        @Override
        void addLines(Font font, IEntryData data, String searchHighlight, List<FormattedText> lines) {
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                lines.addAll(font.m_92865_().m_92432_(comment, 200, Style.f_131099_));
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.button);
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return this.button.m_198029_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.m_252865_(entryLeft - 1);
            this.button.m_253211_(entryTop);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            super.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, selected, partialTicks);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, CategoryEntry.this.getTitle());
                }
            }, (Object)this.button);
        }
    }

    private class BooleanEntry
    extends ConfigEntry<Boolean> {
        private final Button button;

        public BooleanEntry(EntryData.ConfigEntryData<Boolean> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight);
            this.button = Button.m_253074_((Component)CommonComponents.m_130666_((boolean)configEntryData.getCurrentValue()), button -> {
                boolean newValue = (Boolean)configEntryData.getCurrentValue() == false;
                configEntryData.setCurrentValue(newValue);
                this.onConfigValueChanged(newValue, false);
            }).m_252987_(10, 5, 44, 20).m_253136_();
            this.m_6702_().add((AbstractWidget)this.button);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.m_252865_(entryLeft + rowWidth - 67);
            this.button.m_253211_(entryTop);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(Boolean newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            this.button.m_93666_(CommonComponents.m_130666_((boolean)newValue));
        }
    }

    private class NumberEntry<T>
    extends ConfigEntry<T> {
        private final ConfigEditBox textField;

        public NumberEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, Function<String, T> parser) {
            super(configEntryData, searchHighlight);
            this.textField = new ConfigEditBox(ConfigScreen.this.f_96547_, 0, 0, 42, 18, () -> ConfigScreen.this.activeTextField, activeTextField -> {
                ConfigScreen.this.activeTextField = activeTextField;
            });
            this.textField.m_94151_(input -> {
                T number = null;
                try {
                    Object parsed = parser.apply((String)input);
                    if (configEntryData.getValueSpec().test(parsed)) {
                        number = (T)parsed;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (number != null) {
                    this.textField.markInvalid(false);
                    configEntryData.setCurrentValue(number);
                    this.onConfigValueChanged(number, false);
                } else {
                    this.textField.markInvalid(true);
                    configEntryData.resetCurrentValue();
                    this.resetButton.f_93623_ = true;
                }
            });
            this.textField.m_94144_(configEntryData.getCurrentValue().toString());
            this.m_6702_().add((AbstractWidget)this.textField);
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.textField.m_252865_(entryLeft + rowWidth - 66);
            this.textField.m_253211_(entryTop + 1);
            this.textField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(T newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            if (reset) {
                this.textField.m_94144_(newValue.toString());
            }
        }
    }

    private class EnumEntry
    extends EditScreenEntry<Enum<?>> {
        public EnumEntry(EntryData.ConfigEntryData<Enum<?>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "Enum", (Component)Component.m_237115_((String)"configmenusforge.gui.select"));
        }

        @Override
        String valueToString(Enum<?> value) {
            return ScreenTextHelper.toFormattedString(value.name().toLowerCase(Locale.ROOT));
        }

        @Override
        Screen makeEditScreen(String type, Enum<?> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<Enum<?>> onSave) {
            return new EditEnumScreen(ConfigScreen.this, (Component)Component.m_237110_((String)"configmenusforge.gui.value.select", (Object[])new Object[]{type}), currentValue, (Enum[])currentValue.getDeclaringClass().getEnumConstants(), arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private class StringEntry
    extends EditScreenEntry<String> {
        public StringEntry(EntryData.ConfigEntryData<String> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String");
        }

        @Override
        String valueToString(String value) {
            return value;
        }

        @Override
        Screen makeEditScreen(String type, String currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<String> onSave) {
            return new EditStringScreen(ConfigScreen.this, (Component)Component.m_237110_((String)"configmenusforge.gui.value.edit", (Object[])new Object[]{type}), currentValue, arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private class ListEntry<T>
    extends EditScreenEntry<List<T>> {
        private final Function<String, T> fromString;

        public ListEntry(EntryData.ConfigEntryData<List<T>> configEntryData, String searchHighlight, String type, Function<String, T> fromString) {
            super(configEntryData, searchHighlight, type);
            this.fromString = fromString;
        }

        @Override
        final String valueToString(List<T> value) {
            return "[" + value.stream().map(this::listValueToString).collect(Collectors.joining(", ")) + "]";
        }

        String listValueToString(Object value) {
            return value.toString();
        }

        @Override
        Screen makeEditScreen(String type, List<T> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<T>> onSave) {
            return new EditListScreen(ConfigScreen.this, (Component)Component.m_237110_((String)"configmenusforge.gui.list.edit", (Object[])new Object[]{type}), currentValue.stream().map(this::listValueToString).collect(Collectors.toList()), input -> {
                try {
                    this.fromString.apply((String)input);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }, list -> {
                List values = list.stream().map(this.fromString).collect(Collectors.toList());
                valueSpec.correct((Object)valueSpec);
                onSave.accept(values);
            });
        }
    }

    private class EnumListEntry
    extends ListEntry<Enum<?>> {
        public <T extends Enum<T>> EnumListEntry(EntryData.ConfigEntryData<List<Enum<?>>> configEntryData, String searchHighlight, Class<Enum<?>> clazz) {
            super(configEntryData, searchHighlight, "Enum", (String v) -> Enum.valueOf(clazz, v));
        }

        @Override
        String listValueToString(Object value) {
            String string;
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                string = e.name();
            } else {
                string = super.listValueToString(value);
            }
            return string;
        }
    }

    private class DangerousListEntry
    extends ListEntry<String> {
        public DangerousListEntry(EntryData.ConfigEntryData<List<String>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String", (String s) -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }

        @Override
        Screen makeEditScreen(String type, List<String> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<String>> onSave) {
            MutableComponent component1 = Component.m_237115_((String)"configmenusforge.gui.message.dangerous.title").m_130940_(ChatFormatting.RED);
            return new ConfirmScreen(result -> {
                if (result) {
                    ConfigScreen.this.f_96541_.m_91152_(super.makeEditScreen(type, currentValue, valueSpec, onSave));
                } else {
                    ConfigScreen.this.f_96541_.m_91152_((Screen)ConfigScreen.this);
                }
            }, (Component)component1, (Component)Component.m_237115_((String)"configmenusforge.gui.message.dangerous.text"), CommonComponents.f_130659_, CommonComponents.f_130660_);
        }
    }

    public abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final Component title;
        @Nullable
        private final List<? extends FormattedCharSequence> tooltip;

        protected Entry(IEntryData data, String searchHighlight) {
            this.title = data.getDisplayTitle(searchHighlight);
            ArrayList lines = Lists.newArrayList();
            this.addLines(ConfigScreen.this.f_96547_, data, searchHighlight, lines);
            this.tooltip = lines.isEmpty() ? null : Language.m_128107_().m_128112_((List)lines);
        }

        public final Component getTitle() {
            return this.title;
        }

        abstract void addLines(Font var1, IEntryData var2, String var3, List<FormattedText> var4);

        @Nullable
        public final List<? extends FormattedCharSequence> getTooltip() {
            return this.tooltip;
        }

        abstract boolean isHovered(int var1, int var2);

        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (this.isHovered(mouseX, mouseY)) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, Entry.this.title);
                }
            });
        }
    }

    private abstract class EditScreenEntry<T>
    extends ConfigEntry<T> {
        private final Button button;

        public EditScreenEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, String type) {
            this(configEntryData, searchHighlight, type, (Component)Component.m_237115_((String)"configmenusforge.gui.edit"));
        }

        public EditScreenEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, String type, Component message) {
            super(configEntryData, searchHighlight);
            this.button = Button.m_253074_((Component)message, button -> {
                try {
                    ConfigScreen.this.f_96541_.m_91152_(this.makeEditScreen(type, configEntryData.getCurrentValue(), configEntryData.getValueSpec(), currentValue -> {
                        configEntryData.setCurrentValue(currentValue);
                        this.onConfigValueChanged(currentValue, false);
                    }));
                }
                catch (RuntimeException e) {
                    ForgeConfigScreens.LOGGER.warn("Unable to handle list entry containing class type {}", (Object)type, (Object)e);
                    button.f_93623_ = false;
                }
            }).m_252987_(10, 5, 44, 20).m_253136_();
            this.m_6702_().add((AbstractWidget)this.button);
        }

        @Override
        abstract String valueToString(T var1);

        abstract Screen makeEditScreen(String var1, T var2, ForgeConfigSpec.ValueSpec var3, Consumer<T> var4);

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.m_252865_(entryLeft + rowWidth - 67);
            this.button.m_253211_(entryTop);
            this.button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    private abstract class ConfigEntry<T>
    extends Entry {
        private static final Component RESET_TOOLTIP = Component.m_237115_((String)"configmenusforge.gui.tooltip.reset");
        private final List<AbstractWidget> children;
        private final EntryData.ConfigEntryData<T> configEntryData;
        private final FormattedCharSequence visualTitle;
        final Button resetButton;

        public ConfigEntry(EntryData.ConfigEntryData<T> data, String searchHighlight) {
            super(data, searchHighlight);
            this.children = Lists.newArrayList();
            this.configEntryData = data;
            FormattedText truncatedTitle = ScreenTextHelper.truncateText(ConfigScreen.this.f_96547_, this.getTitle(), 190, Style.f_131099_);
            this.visualTitle = Language.m_128107_().m_5536_(truncatedTitle);
            final List tooltip = ConfigScreen.this.f_96547_.m_92923_((FormattedText)RESET_TOOLTIP, 200);
            this.resetButton = new MutableIconButton(0, 0, 20, 20, 140, 0, ICONS_LOCATION, button -> {
                data.resetCurrentValue();
                this.onConfigValueChanged(data.getCurrentValue(), true);
                ConfigScreen.this.updateList(false);
            }){

                @Override
                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.f_93623_ && this.m_198029_()) {
                        ConfigScreen.this.setActiveTooltip(tooltip);
                    }
                }
            };
            this.resetButton.f_93623_ = data.mayResetValue();
            this.children.add((AbstractWidget)this.resetButton);
        }

        @Override
        void addLines(Font font, IEntryData data, String searchHighlight, List<FormattedText> lines) {
            MutableComponent component = Component.m_237113_((String)data.getPath()).m_130940_(ChatFormatting.YELLOW);
            lines.addAll(font.m_92865_().m_92414_((FormattedText)component, 200, Style.f_131099_));
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                int i;
                List splitLines = font.m_92865_().m_92432_(comment, 200, Style.f_131099_);
                int rangeIndex = -1;
                for (i = 0; i < splitLines.size(); ++i) {
                    String text = ((FormattedText)splitLines.get(i)).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    rangeIndex = i;
                    break;
                }
                if (rangeIndex != -1) {
                    for (i = rangeIndex; i < splitLines.size(); ++i) {
                        splitLines.set(i, Component.m_237113_((String)((FormattedText)splitLines.get(i)).getString()).m_130940_(ChatFormatting.GRAY));
                    }
                }
                lines.addAll(splitLines);
            }
            EntryData.ConfigEntryData configData = (EntryData.ConfigEntryData)data;
            lines.addAll(font.m_92865_().m_92414_((FormattedText)Component.m_237110_((String)"configmenusforge.gui.tooltip.default", (Object[])new Object[]{this.valueToString(configData.getDefaultValue())}).m_130940_(ChatFormatting.GRAY), 200, Style.f_131099_));
            if (searchHighlight != null && !searchHighlight.isEmpty()) {
                Component pathComponent = configData.getFullPath().stream().map(ScreenTextHelper::toFormattedComponent).reduce((o1, o2) -> Component.m_237113_((String)"").m_7220_(o1).m_130946_(" > ").m_7220_(o2)).orElse((Component)Component.m_237119_());
                lines.addAll(font.m_92865_().m_92414_((FormattedText)Component.m_237110_((String)"configmenusforge.gui.tooltip.path", (Object[])new Object[]{pathComponent}).m_130940_(ChatFormatting.GRAY), 200, Style.f_131099_));
            }
        }

        String valueToString(T value) {
            return value.toString();
        }

        public void onConfigValueChanged(T newValue, boolean reset) {
            this.resetButton.f_93623_ = this.configEntryData.mayResetValue();
        }

        public List<AbstractWidget> m_6702_() {
            return this.children;
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return ConfigScreen.this.list != null && this.m_5953_(mouseX, mouseY) && mouseX < ConfigScreen.this.list.m_5747_() + ConfigScreen.this.list.m_5759_() - 67;
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int color = this.isHovered(mouseX, mouseY) ? 0xFFFF55 : 0xFFFFFF;
            guiGraphics.m_280648_(ConfigScreen.this.f_96547_, this.visualTitle, entryLeft, entryTop + 6, color);
            this.resetButton.m_252865_(entryLeft + rowWidth - 21);
            this.resetButton.m_253211_(entryTop);
            this.resetButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            super.m_6311_(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    String comment = ConfigEntry.this.configEntryData.getValueSpec().getComment();
                    if (comment != null) {
                        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)"").m_7220_(ConfigEntry.this.getTitle()).m_130946_(", " + comment));
                    } else {
                        output.m_169146_(NarratedElementType.TITLE, ConfigEntry.this.getTitle());
                    }
                }
            });
            builder.addAll(this.children);
            return builder.build();
        }
    }
}

