/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.data;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.forgeconfigscreens.client.gui.data.EntryData;
import fuzs.forgeconfigscreens.client.helper.ServerConfigUploader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public interface IEntryData {
    public String getPath();

    @Nullable
    public String getComment();

    public Component getTitle();

    default public Component getDisplayTitle(String searchHighlight) {
        List<Integer> indices;
        if (searchHighlight != null && !searchHighlight.isEmpty() && !(indices = this.getSearchIndices(this.getSearchableTitle(), searchHighlight)).isEmpty()) {
            return this.getColoredTitle(this.getTitle().getString(), searchHighlight.length(), indices);
        }
        return this.getTitle();
    }

    private Component getColoredTitle(String title, int length, List<Integer> indices) {
        MutableComponent component = Component.m_237113_((String)title.substring(0, indices.get(0))).m_130940_(ChatFormatting.GRAY);
        int indicesSize = indices.size();
        for (int i = 0; i < indicesSize; ++i) {
            int start = indices.get(i);
            int end = start + length;
            component.m_7220_((Component)Component.m_237113_((String)title.substring(start, end)).m_130940_(ChatFormatting.WHITE));
            int j = i;
            int nextStart = ++j < indicesSize ? indices.get(j).intValue() : title.length();
            component.m_7220_((Component)Component.m_237113_((String)title.substring(end, nextStart)).m_130940_(ChatFormatting.GRAY));
        }
        return component;
    }

    private List<Integer> getSearchIndices(String title, String query) {
        LinkedList indices = Lists.newLinkedList();
        if (!query.isEmpty()) {
            int index = title.indexOf(query);
            while (index >= 0) {
                indices.add(index);
                index = title.indexOf(query, index + 1);
            }
        }
        return indices;
    }

    default public String getSearchableTitle() {
        return this.getTitle().getString().toLowerCase(Locale.ROOT);
    }

    default public boolean mayInclude(String searchHighlight) {
        return searchHighlight == null || searchHighlight.isEmpty() || this.getSearchableTitle().contains(searchHighlight);
    }

    public boolean mayResetValue();

    public boolean mayDiscardChanges();

    public void resetCurrentValue();

    public void discardCurrentValue();

    public void saveConfigValue();

    public boolean category();

    public static Comparator<IEntryData> getDefaultComparator(boolean reversed) {
        Comparator<IEntryData> defaultComparator = Comparator.comparing(o -> o.getTitle().getString());
        return Comparator.comparing(IEntryData::category).reversed().thenComparing(reversed ? defaultComparator.reversed() : defaultComparator);
    }

    public static Comparator<IEntryData> getSearchComparator(String searchHighlight, boolean reversed) {
        if (searchHighlight != null && !searchHighlight.isEmpty()) {
            return Comparator.comparingInt(o -> o.getSearchableTitle().indexOf(searchHighlight)).thenComparing(IEntryData.getDefaultComparator(false));
        }
        return IEntryData.getDefaultComparator(reversed);
    }

    public static Map<Object, IEntryData> makeValueToDataMap(ModConfig config) {
        ForgeConfigSpec spec = ServerConfigUploader.findForgeConfigSpec(config.getSpec()).orElse(null);
        if (config.getConfigData() == null || spec == null || !spec.isLoaded()) {
            return Map.of();
        }
        HashMap allData = Maps.newHashMap();
        IEntryData.makeValueToDataMap(spec, spec.getValues(), config.getConfigData(), allData);
        return ImmutableMap.copyOf((Map)allData);
    }

    private static void makeValueToDataMap(ForgeConfigSpec spec, UnmodifiableConfig values, CommentedConfig comments, Map<Object, IEntryData> allData) {
        values.valueMap().forEach((path, value) -> {
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig category = (UnmodifiableConfig)value;
                EntryData.CategoryEntryData data = new EntryData.CategoryEntryData((String)path, category, comments.getComment(path));
                allData.put(category, data);
                IEntryData.makeValueToDataMap(spec, category, (CommentedConfig)comments.valueMap().get(path), allData);
            } else if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                EntryData.ConfigEntryData data = new EntryData.ConfigEntryData((String)path, configValue, (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath()));
                allData.put(configValue, data);
            }
        });
    }
}

