/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;

public class UpdateChecker {
    private static final String UPDATE_URL = "https://api.github.com/repos/EuphoriaPatches/PatcherUpdateChecker/releases/latest";
    private static final String MOD_VERSION = "_1.4.1".replace("_", "");
    public static String NEW_MOD_VERSION = null;
    public static boolean NEW_VERSION_AVAILABLE = false;
    private static boolean UPDATE_CHECK_PERFORMED = false;

    public static void checkForUpdates() {
        if (UPDATE_CHECK_PERFORMED) {
            return;
        }
        UPDATE_CHECK_PERFORMED = true;
        try {
            NEW_MOD_VERSION = UpdateChecker.fetchLatestVersion();
            if (NEW_MOD_VERSION == null) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to fetch the latest version.");
                return;
            }
            if (UpdateChecker.isNewerVersion(NEW_MOD_VERSION)) {
                NEW_VERSION_AVAILABLE = true;
                EuphoriaPatcher.log(2, "[UPDATE CHECKER] A new version of the EuphoriaPatcher Mod is available: " + NEW_MOD_VERSION);
                EuphoriaPatcher.log(2, "[UPDATE CHECKER] Download it from Modrinth: https://euphoriapatches.com/download");
                EuphoriaPatcher.log(1, 8, "[UPDATE CHECKER] Current Version: " + MOD_VERSION);
                EuphoriaPatcher.log(1, 8, "[UPDATE CHECKER] Check logs for more info");
            } else {
                EuphoriaPatcher.log(0, "[UPDATE CHECKER] The EuphoriaPatcher Mod is up to date");
            }
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Update check failed: " + e.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private static String fetchLatestVersion() throws Exception {
        URL url = new URL(UPDATE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (connection.getResponseCode() != 200) {
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Connection timed out.");
            return null;
        }
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                JsonElement jsonElement = new JsonParser().parse((Reader)reader);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                String string = jsonObject.get("tag_name").getAsString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private static boolean isNewerVersion(String latestVersion) {
        String[] latest = latestVersion.split("\\.");
        String[] current = MOD_VERSION.split("\\.");
        for (int i = 0; i < Math.min(latest.length, current.length); ++i) {
            int currentPart;
            int latestPart = Integer.parseInt(latest[i]);
            if (latestPart == (currentPart = Integer.parseInt(current[i]))) continue;
            return latestPart > currentPart;
        }
        return latest.length > current.length;
    }
}

