/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;

public class UpdateShaderLoaderConfig {
    private static Path getShaderLoaderPath() {
        Path shaderLoaderConfig = EuphoriaPatcher.configDirectory.resolve("iris.properties");
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = EuphoriaPatcher.configDirectory.resolve("oculus.properties");
        }
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = EuphoriaPatcher.shaderpacks.getParent().resolve("optionsshaders.txt");
        }
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = null;
        }
        return shaderLoaderConfig;
    }

    public static void updateShaderLoaderConfig(boolean styleUnbound, boolean styleReimagined) {
        block30: {
            Path shaderLoaderConfig = UpdateShaderLoaderConfig.getShaderLoaderPath();
            if (shaderLoaderConfig == null) {
                EuphoriaPatcher.log(0, "No shader loader config found");
                return;
            }
            String shaderLoaderName = shaderLoaderConfig.toString().contains("iris") ? "iris.properties" : (shaderLoaderConfig.toString().contains("oculus") ? "oculus.properties" : "OptiFine's optionsshaders.txt");
            File fileToBeModified = shaderLoaderConfig.toFile();
            StringBuilder oldContent = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new FileReader(fileToBeModified));){
                String line;
                while ((line = reader.readLine()) != null) {
                    oldContent.append(line).append(System.lineSeparator());
                }
                if (!oldContent.toString().contains("EuphoriaPatches") || oldContent.toString().contains("_1.4.1")) break block30;
                String newContent = UpdateShaderLoaderConfig.setNewShaderLoaderSelectedPackName(oldContent, styleUnbound, styleReimagined);
                try (FileWriter writer = new FileWriter(fileToBeModified);){
                    writer.write(newContent);
                }
                catch (IOException e) {
                    EuphoriaPatcher.log(3, 0, "Error writing to " + shaderLoaderName + " config file: " + e.getMessage());
                }
                EuphoriaPatcher.log(0, "Successfully applied new version in " + shaderLoaderName + " config file!");
                EuphoriaPatcher.log(0, oldContent.toString().split("shaderPack=")[1] + " -> " + newContent.split("shaderPack=")[1]);
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error reading or writing to " + shaderLoaderName + " config file: " + e.getMessage());
            }
        }
    }

    private static String setNewShaderLoaderSelectedPackName(StringBuilder oldContent, boolean styleUnbound, boolean styleReimagined) {
        String style;
        String string = style = styleUnbound ? "Unbound" : "Reimagined";
        if (styleUnbound && styleReimagined) {
            style = oldContent.toString().contains("EuphoriaPatches") && !oldContent.toString().contains("_1.4.1") && oldContent.toString().contains("Unbound") ? "Unbound" : "Reimagined";
        }
        String newName = "Complementary" + style + "_r5.3" + " + " + "EuphoriaPatches" + "_1.4.1";
        return oldContent.toString().replaceAll("shaderPack=.*", "shaderPack=" + newName);
    }
}

