/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.gui;

import com.chaosthedude.endermail.EnderMail;
import com.chaosthedude.endermail.gui.StampTextField;
import com.chaosthedude.endermail.network.StampPackagePacket;
import com.chaosthedude.endermail.util.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StampScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("endermail", "textures/gui/stamp.png");
    private Button confirmButton;
    private Button cancelButton;
    private StampTextField xTextField;
    private StampTextField yTextField;
    private StampTextField zTextField;
    private StampTextField lockerIDTextField;
    private Level level;
    private Player player;
    private BlockPos packagePos;
    private boolean errored;

    public StampScreen(Level level, Player player, BlockPos packagePos) {
        super((Component)Component.m_237113_((String)""));
        this.level = level;
        this.player = player;
        this.packagePos = packagePos;
    }

    public void m_7856_() {
        this.setupWidgets();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int xSize = 178;
        int ySize = 222;
        int i = (this.f_96543_ - xSize) / 2;
        int j = (this.f_96544_ - ySize) / 2;
        guiGraphics.m_280218_(TEXTURE, i, j, 0, 0, xSize, ySize);
        if (this.errored) {
            RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, I18n.m_118938_((String)"string.endermail.error", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ - 65, 0xAAAAAA);
        }
        RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, I18n.m_118938_((String)"string.endermail.deliveryLocation", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 - 42, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, "X", this.f_96543_ / 2 - 45, this.f_96544_ / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, "Y", this.f_96543_ / 2 + 0, this.f_96544_ / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, "Z", this.f_96543_ / 2 + 45, this.f_96544_ / 2 - 5, 0xAAAAAA);
        RenderUtils.drawCenteredStringWithoutShadow(guiGraphics, I18n.m_118938_((String)"string.endermail.lockerID", (Object[])new Object[0]), this.f_96543_ / 2, this.f_96544_ / 2 + 13, 0xAAAAAA);
        this.lockerIDTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.xTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.yTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.zTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        this.lockerIDTextField.m_94120_();
        this.xTextField.m_94120_();
        this.yTextField.m_94120_();
        this.zTextField.m_94120_();
        this.confirmButton.f_93623_ = !this.lockerIDTextField.m_94155_().isEmpty() && this.xTextField.m_94155_().isEmpty() && this.yTextField.m_94155_().isEmpty() && this.zTextField.m_94155_().isEmpty() || StampScreen.isNumeric(this.xTextField.m_94155_()) && (this.yTextField.m_94155_().isEmpty() || StampScreen.isNumeric(this.yTextField.m_94155_())) && StampScreen.isNumeric(this.zTextField.m_94155_());
    }

    private void setupWidgets() {
        this.m_169413_();
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"string.endermail.cancel"), onPress -> this.f_96541_.m_91152_(null)).m_252987_(20, this.f_96544_ - 40, 80, 20).m_253136_());
        this.confirmButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"string.endermail.confirm"), onPress -> {
            try {
                String lockerID = this.lockerIDTextField.m_94155_();
                int x = -1;
                int y = -1;
                int z = -1;
                if (lockerID.isEmpty() || !this.xTextField.m_94155_().isEmpty() && !this.yTextField.m_94155_().isEmpty() && !this.zTextField.m_94155_().isEmpty()) {
                    x = Integer.valueOf(this.xTextField.m_94155_());
                    if (!this.yTextField.m_94155_().isEmpty()) {
                        y = Integer.valueOf(this.yTextField.m_94155_());
                    }
                    z = Integer.valueOf(this.zTextField.m_94155_());
                }
                BlockPos deliveryPos = new BlockPos(x, y, z);
                EnderMail.network.sendToServer((Object)new StampPackagePacket(this.packagePos, deliveryPos, lockerID, !this.xTextField.m_94155_().isEmpty() && !this.zTextField.m_94155_().isEmpty()));
                this.f_96541_.m_91152_(null);
            }
            catch (NumberFormatException e) {
                this.errored = true;
            }
        }).m_252987_(this.f_96543_ - 100, this.f_96544_ - 40, 80, 20).m_253136_());
        this.confirmButton.f_93623_ = false;
        this.xTextField = (StampTextField)this.m_142416_((GuiEventListener)new StampTextField(this.f_96547_, this.f_96543_ / 2 - 65, this.f_96544_ / 2 - 30, 40, 20, (Component)Component.m_237113_((String)"")));
        this.yTextField = (StampTextField)this.m_142416_((GuiEventListener)new StampTextField(this.f_96547_, this.f_96543_ / 2 - 20, this.f_96544_ / 2 - 30, 40, 20, (Component)Component.m_237113_((String)"")));
        this.zTextField = (StampTextField)this.m_142416_((GuiEventListener)new StampTextField(this.f_96547_, this.f_96543_ / 2 + 25, this.f_96544_ / 2 - 30, 40, 20, (Component)Component.m_237113_((String)"")));
        this.lockerIDTextField = (StampTextField)this.m_142416_((GuiEventListener)new StampTextField(this.f_96547_, this.f_96543_ / 2 - 65, this.f_96544_ / 2 + 25, 130, 20, (Component)Component.m_237113_((String)"")));
        this.lockerIDTextField.m_94199_(12);
        this.m_264313_((GuiEventListener)this.xTextField);
        this.xTextField.m_93692_(true);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(s.charAt(i)) || i == 0 && size > 1 && s.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }
}

