/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.block.entity;

import com.chaosthedude.endermail.block.LockerBlock;
import com.chaosthedude.endermail.data.LockerData;
import com.chaosthedude.endermail.gui.container.LockerMenu;
import com.chaosthedude.endermail.registry.EnderMailBlockEntities;
import com.chaosthedude.endermail.registry.EnderMailItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LockerBlockEntity
extends BaseContainerBlockEntity {
    public static final String NAME = "locker";
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    protected String lockerID = "";

    public LockerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderMailBlockEntities.LOCKER.get(), pos, state);
    }

    public LockerBlockEntity(NonNullList<ItemStack> contents, BlockPos pos, BlockState state) {
        this(pos, state);
        this.contents = contents;
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.contents) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.contents);
        this.lockerID = tag.m_128461_("LockerID");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.contents);
        tag.m_128359_("LockerID", this.lockerID);
    }

    public CompoundTag writeItems(CompoundTag compound) {
        if (!this.contents.isEmpty()) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.contents);
        }
        return compound;
    }

    public int m_6893_() {
        return 64;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack result = ContainerHelper.m_18969_(this.contents, (int)index, (int)count);
        LockerBlock.setFilled(!this.m_7983_(), this.f_58857_, this.f_58858_);
        return result;
    }

    public ItemStack m_8016_(int index) {
        ItemStack result = ContainerHelper.m_18966_(this.contents, (int)index);
        LockerBlock.setFilled(!this.m_7983_(), this.f_58857_, this.f_58858_);
        return result;
    }

    public void m_6836_(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.contents.get(index);
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack);
        this.contents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        LockerBlock.setFilled(!this.m_7983_(), this.f_58857_, this.f_58858_);
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return stack.m_41720_() == EnderMailItems.PACKAGE.get();
    }

    public void m_6211_() {
        this.contents.clear();
        LockerBlock.setFilled(!this.m_7983_(), this.f_58857_, this.f_58858_);
    }

    public AbstractContainerMenu m_6555_(int windowID, Inventory playerInventory) {
        return new LockerMenu(windowID, playerInventory, (Container)this, this.f_58858_, this.lockerID);
    }

    public Component m_5446_() {
        return this.lockerID != null && !this.lockerID.isEmpty() ? Component.m_237113_((String)this.lockerID) : Component.m_237115_((String)"block.endermail.locker");
    }

    public void removeData() {
        if (this.f_58857_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            LockerData data = LockerData.get(serverLevel);
            data.removeLocker(this.lockerID);
        }
    }

    public boolean isFull() {
        for (ItemStack stack : this.contents) {
            if (!stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean addPackage(ItemStack stack) {
        for (int i = 0; i < this.contents.size(); ++i) {
            if (!((ItemStack)this.contents.get(i)).m_41619_()) continue;
            this.m_6836_(i, stack);
            LockerBlock.setFilled(true, this.f_58857_, this.f_58858_);
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }

    public void setLockerID(String lockerID) {
        if (this.f_58857_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            LockerData data = LockerData.get(serverLevel);
            data.removeLocker(this.lockerID);
            this.lockerID = data.createLocker(lockerID, this.f_58858_);
        }
    }

    public String getLockerID() {
        return this.lockerID;
    }

    public boolean hasLockerID() {
        return this.lockerID != null && !this.lockerID.isEmpty();
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.endermail.locker");
    }
}

