/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class FormattedStringDecomposer {
    public static int stringWidth(Font font, @Nullable String content, int skip) {
        if (content == null) {
            return 0;
        }
        MutableFloat mutableFloat = new MutableFloat();
        FormattedStringDecomposer.iterateFormatted(content, Style.f_131099_, (index, style, j) -> {
            if (index >= skip) {
                mutableFloat.add(font.m_92865_().m_92336_(FormattedCharSequence.m_13714_((String)Character.toString(j), (Style)style)));
            }
            return true;
        });
        return Mth.m_14167_((float)mutableFloat.floatValue());
    }

    public static boolean isAllowedChatCharacter(char character) {
        return character >= ' ' && character != '\u007f';
    }

    public static String filterText(String input) {
        return FormattedStringDecomposer.filterText(input, false);
    }

    public static String filterText(String string, boolean keepLinesBreaks) {
        char[] var3;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : var3 = string.toCharArray()) {
            if (FormattedStringDecomposer.isAllowedChatCharacter(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (!keepLinesBreaks || c != '\n') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int plainIndexAtWidth(Font font, String content, int skip, int maxWidth, Style style) {
        WidthLimitedCharSink widthLimitedCharSink = new WidthLimitedCharSink(font.m_92865_(), maxWidth, skip);
        FormattedStringDecomposer.iterateFormatted(content, style, widthLimitedCharSink);
        return widthLimitedCharSink.getPosition();
    }

    public static String plainHeadByWidth(Font font, String content, int skip, int maxWidth, Style style) {
        return content.substring(skip, FormattedStringDecomposer.plainIndexAtWidth(font, content, skip, maxWidth, style));
    }

    public static String plainTailByWidth(Font font, String content, int maxWidth, Style style) {
        MutableFloat mutableFloat = new MutableFloat();
        MutableInt mutableInt = new MutableInt(content.length());
        FormattedStringDecomposer.iterateFormattedBackwards(content, style, (j, stylex, k) -> {
            float stringWidth = font.m_92865_().m_92336_(FormattedCharSequence.m_13714_((String)Character.toString(k), (Style)stylex));
            float f = mutableFloat.addAndGet(stringWidth);
            if (f > (float)maxWidth) {
                return false;
            }
            mutableInt.setValue(j);
            return true;
        });
        return content.substring(mutableInt.intValue());
    }

    public static boolean iterateFormatted(String text, Style defaultStyle, FormattedCharSink sink) {
        int textLength = text.length();
        Style currentStyle = defaultStyle;
        for (int position = 0; position < textLength; ++position) {
            char character = text.charAt(position);
            if (character == '\u00a7') {
                if (position + 1 < textLength) {
                    char d = text.charAt(position + 1);
                    ChatFormatting chatFormatting = ChatFormatting.m_126645_((char)d);
                    if (chatFormatting != null) {
                        Style style = currentStyle = chatFormatting == ChatFormatting.RESET ? defaultStyle : currentStyle.m_131164_(chatFormatting);
                    }
                    if (FormattedStringDecomposer.feedChar(text, defaultStyle, sink, position, character, textLength) == -1) {
                        return false;
                    }
                    if (FormattedStringDecomposer.feedChar(text, defaultStyle, sink, ++position, text.charAt(position), textLength) != -1) continue;
                    return false;
                }
                return FormattedStringDecomposer.feedChar(text, defaultStyle, sink, position, character, textLength) != -1;
            }
            if ((position = FormattedStringDecomposer.feedChar(text, currentStyle, sink, position, character, textLength)) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean iterateFormattedBackwards(String text, Style defaultStyle, FormattedCharSink sink) {
        ArrayList list = Lists.newArrayList();
        FormattedStringDecomposer.iterateFormatted(text, defaultStyle, (index, style, j) -> {
            list.add(FormattedCharSequence.m_13714_((String)Character.toString(j), (Style)style));
            return true;
        });
        for (int i = list.size() - 1; i >= 0; --i) {
            if (((FormattedCharSequence)list.get(i)).m_13731_(sink)) continue;
            return false;
        }
        return true;
    }

    private static int feedChar(String text, Style style, FormattedCharSink sink, int position, char character, int textLength) {
        if (Character.isHighSurrogate(character)) {
            if (position + 1 >= textLength) {
                if (!sink.m_6411_(position, style, 65533)) {
                    return -1;
                }
                return textLength;
            }
            char d = text.charAt(position + 1);
            if (Character.isLowSurrogate(d)) {
                if (!sink.m_6411_(position, style, Character.toCodePoint(character, d))) {
                    return -1;
                }
                ++position;
            } else if (!sink.m_6411_(position, style, 65533)) {
                return -1;
            }
        } else if (!FormattedStringDecomposer.feedChar(style, sink, position, character)) {
            return -1;
        }
        return position;
    }

    private static boolean feedChar(Style style, FormattedCharSink sink, int position, char character) {
        return Character.isSurrogate(character) ? sink.m_6411_(position, style, 65533) : sink.m_6411_(position, style, (int)character);
    }

    private static class WidthLimitedCharSink
    implements FormattedCharSink {
        private final StringSplitter splitter;
        private float maxWidth;
        private final int skip;
        private int position;

        public WidthLimitedCharSink(StringSplitter splitter, float f, int skip) {
            this.splitter = splitter;
            this.maxWidth = f;
            this.skip = skip;
        }

        public boolean m_6411_(int i, Style style, int j) {
            if (i >= this.skip) {
                this.maxWidth -= this.splitter.m_92336_(FormattedCharSequence.m_13714_((String)Character.toString(j), (Style)style));
            }
            if (this.maxWidth >= 0.0f) {
                this.position = i + Character.charCount(j);
                return true;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public void resetPosition() {
            this.position = 0;
        }
    }

    public static class LengthLimitedCharSink
    implements FormattedCharSink {
        private final int skip;
        private int maxLength;

        public LengthLimitedCharSink(int maxLength, int skip) {
            this.maxLength = maxLength;
            this.skip = skip;
        }

        public boolean m_6411_(int i, Style style, int j) {
            if (i >= this.skip) {
                this.maxLength -= Character.charCount(j);
            } else {
                return false;
            }
            return this.maxLength >= 0;
        }
    }
}

