/*
 * Decompiled with CFR 0.152.
 */
package elocindev.customitemattributes.config;

import elocindev.customitemattributes.api.GenericAttribute;
import elocindev.customitemattributes.api.ItemProperty;
import elocindev.necronomicon.api.config.v1.NecConfigAPI;
import elocindev.necronomicon.config.Comment;
import elocindev.necronomicon.config.Comments;
import elocindev.necronomicon.config.NecConfig;
import java.nio.file.Path;
import java.util.List;

public class CIAConfig {
    public static final String FOLDER = "custom_item_attributes";
    public static final String FILE_NAME = "overrides.json5";
    public static final int CURRENT_CONFIG_VERSION = 2;
    @NecConfig
    public static CIAConfig INSTANCE;
    @Comments(value={@Comment(value="---------------------------------------------------------------------------------------------------------------------------------"), @Comment(value="                                           Custom Item Attributes (CIA) by ElocinDev"), @Comment(value="---------------------------------------------------------------------------------------------------------------------------------"), @Comment(value="                                                       Overrides Config "), @Comment(value="                               Reloaded via datapack reload (/reload) or by restarting the game"), @Comment(value="---------------------------------------------------------------------------------------------------------------------------------"), @Comment(value="Option Index:"), @Comment(value="      item        :           The item's identifier. You can get this using the autocomplete of the /give command."), @Comment(value="      slot        :           A list of slots where the attributes should be applied."), @Comment(value="      attribute   :           The Identifier of the attribute. You can get it using the autocomplete of the /attribute command."), @Comment(value="      value       :           The value of the desired attribute. You can use negatives too, must be a decimal number."), @Comment(value="      operation   :           The operation to calculate the attribute. Addition or Multiply."), @Comment(value="      unbreakable :           Whether or not the item should be unbreakable."), @Comment(value="      force_unbreakable :     Force the unbreakable tag over other mods. Setting this to true will break the Hardening Catalyst from Things from being used on that item!"), @Comment(value="---------------------------------------------------------------------------------------------------------------------------------"), @Comment(value="Slots:"), @Comment(value="      mainhand    :   The main hand slot."), @Comment(value="      offhand     :   The off hand slot."), @Comment(value="      head        :   The head slot."), @Comment(value="      chest       :   The chest slot."), @Comment(value="      legs        :   The legs slot."), @Comment(value="------------------------------------------------------------------------------------------------------------------------------"), @Comment(value="The example showcases a config to add +10 attack damage and +20% attack speed to an \"example_item\", on both the main hand and off hand."), @Comment(value="Each of the attributes are overrides for modifiers of the same attribute type, depending on each slot correspondingly.")})
    public List<ItemProperty> items = List.of(new ItemProperty("examplemod:example_item", List.of("mainhand", "offhand"), List.of(new GenericAttribute<String, Double>("minecraft:generic.attack_damage", 10.0, "ADDITION"), new GenericAttribute<String, Double>("minecraft:generic.attack_speed", 0.2, "MULTIPLY_BASE"))));
    @Comment(value="Don't touch this!")
    public int CONFIG_VERSION = 2;

    public static String getFile() {
        Path folder = Path.of(NecConfigAPI.getFile((String)FOLDER), new String[0]);
        if (!folder.toFile().exists()) {
            folder.toFile().mkdirs();
        }
        return folder.toString() + "/overrides.json5";
    }
}

