/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.core.config.formats;

import java.io.File;
import shadow.hypherionmc.moonconfig.core.Config;

public abstract class AbstractConfigFormat<S> {
    private final File configPath;
    private final Runnable onSave;

    public void register(S conf) {
        if (!this.configPath.exists() || this.configPath.length() < 2L) {
            this.saveConfig(conf);
        } else {
            this.migrateConfig(conf);
        }
    }

    public boolean wasConfigChanged(Config old, Config newConfig) {
        return true;
    }

    public abstract void saveConfig(S var1);

    public abstract S readConfig(S var1);

    public abstract void migrateConfig(S var1);

    public AbstractConfigFormat(File configPath, Runnable onSave) {
        this.configPath = configPath;
        this.onSave = onSave;
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public Runnable getOnSave() {
        return this.onSave;
    }
}

