/*
 * Decompiled with CFR 0.152.
 */
package org.shadowmaster435.biomeparticleweather.util;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import org.shadowmaster435.biomeparticleweather.BiomeParticleWeather;
import org.shadowmaster435.biomeparticleweather.util.FloatifiedForLoop;
import org.shadowmaster435.biomeparticleweather.util.ParticleSettings;
import org.shadowmaster435.biomeparticleweather.util.ParticleUtil;
import org.shadowmaster435.biomeparticleweather.util.Vector3;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticle;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticleBehavior;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.CustomParticleRegistry;
import org.shadowmaster435.biomeparticleweather.util.custom_particle.spawn.SpawnRangeParameters;

public class ParticleEngine {
    public static void try_spawn_particles() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        try {
            if (player != null && !class_310.method_1551().method_1493()) {
                FloatifiedForLoop.run(i -> {
                    ParticleEngine.rain();
                    ParticleEngine.fog();
                    ParticleEngine.wind();
                    ParticleEngine.sandstorm();
                    ParticleEngine.snow();
                    ParticleEngine.updraft();
                    ParticleEngine.warped_spore();
                    ParticleEngine.weeping_tears();
                    ParticleEngine.soul_storm();
                    ParticleEngine.custom();
                }, ParticleSettings.get_float("global_multiplier"));
            }
        }
        catch (Exception e) {
            System.out.println("Config File Read Error Loading Default Values");
            System.out.println(e.getMessage());
            ParticleSettings.load_defaults();
        }
    }

    public static void rain() {
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        class_638 world = class_310.method_1551().field_1687;
        if (world.method_8419() && ParticleUtil.can_rain(player_pos)) {
            float thunder_amount = ParticleSettings.get_float("heavy_rain_amount");
            float amount = ParticleSettings.get_float("rain_amount");
            if (world.method_8546()) {
                amount = thunder_amount;
            }
            FloatifiedForLoop.run(i -> {
                Vector3 rand = ParticleEngine.get_rand_radius();
                Vector3 pos = new Vector3(player_pos.method_1019(new Vector3(rand.field_1352, 8.0, rand.field_1350)));
                if (pos.method_1023(0.0, 8.0, 0.0).method_1022((class_243)player_pos) > 1.0 && world.method_8311(pos.to_blockpos())) {
                    ParticleEngine.spawn_particle((class_2394)BiomeParticleWeather.RAIN, pos);
                }
            }, amount);
        }
    }

    public static void sandstorm() {
        boolean normal_desert;
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        class_638 world = class_310.method_1551().field_1687;
        boolean a = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_9424);
        boolean b = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_9415);
        boolean c = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_9443);
        boolean d = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_35110);
        boolean bl = normal_desert = !b && !c && !d;
        if (world.method_8419() && (a || b || c || d)) {
            float red_sand_amount = ParticleSettings.get_float("red_sand_mote_amount");
            float sand_amount = ParticleSettings.get_float("sand_mote_amount");
            float tumblebush_amount = ParticleSettings.get_float("tumblebush_amount");
            Vector3 rand_offset = player_pos.with_random_offset(16.0f);
            if (world.method_8320(rand_offset.to_blockpos()).method_26215()) {
                if (normal_desert) {
                    ParticleEngine.try_spawn_particle_in_height_range((class_2394)BiomeParticleWeather.SAND_MOTE, player_pos, new Vector3(ParticleEngine.get_rand_radius().field_1352, 8.0, ParticleEngine.get_rand_radius().field_1352), sand_amount, 63.0f, 196.0f);
                } else {
                    ParticleEngine.try_spawn_particle_in_height_range((class_2394)BiomeParticleWeather.RED_SAND_MOTE, player_pos, new Vector3(ParticleEngine.get_rand_radius().field_1352, 8.0, ParticleEngine.get_rand_radius().field_1352), red_sand_amount, 63.0f, 196.0f);
                }
                FloatifiedForLoop.run(i -> ParticleEngine.spawn_particle_on_surface((class_2394)BiomeParticleWeather.TUMBLE_BUSH, player_pos.field_1352 - 8.0, player_pos.field_1350, 0.0, 1.25f, ParticleEngine.get_rand_radius()), tumblebush_amount);
            }
        }
    }

    public static void weeping_tears() {
        class_638 world = class_310.method_1551().field_1687;
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        if (world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_22077)) {
            float amount = ParticleSettings.get_float("weeping_tear_amount");
            ParticleEngine.try_spawn_particle_under_block((class_2394)BiomeParticleWeather.WEEPING_TEAR, class_2246.field_10541, player_pos, Math.round(amount * 0.75f));
            ParticleEngine.try_spawn_particle_under_block((class_2394)BiomeParticleWeather.WEEPING_TEAR, class_2246.field_22121, player_pos, Math.round(amount * 0.25f));
        }
    }

    public static void warped_spore() {
        class_638 world = class_310.method_1551().field_1687;
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        if (world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_22075)) {
            float amount = ParticleSettings.get_float("spore_amount");
            ParticleEngine.try_spawn_particle((class_2394)BiomeParticleWeather.WARPED_SPORE, player_pos, ParticleEngine.get_rand_radius(), amount);
        }
    }

    public static void soul_storm() {
        class_638 world = class_310.method_1551().field_1687;
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        if (world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_22076)) {
            float amount = ParticleSettings.get_float("soul_amount");
            ParticleEngine.try_spawn_particle_above_block((class_2394)BiomeParticleWeather.STORM_SOUL, class_2246.field_10114, player_pos, (int)Math.floor(ParticleEngine.get_rand_radius().field_1352), 4, amount * 0.5f);
            ParticleEngine.try_spawn_particle_above_block((class_2394)BiomeParticleWeather.STORM_SOUL, class_2246.field_22090, player_pos, (int)Math.floor(ParticleEngine.get_rand_radius().field_1352), 4, amount * 0.5f);
        }
    }

    public static void snow() {
        class_638 world = class_310.method_1551().field_1687;
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        Vector3 rand_ofs = player_pos.with_random_offset((float)ParticleEngine.get_rand_radius().field_1352);
        if (((class_1959)world.method_23753(rand_ofs.to_blockpos()).comp_349()).method_48162(rand_ofs.to_blockpos()) == class_1959.class_1963.field_9383) {
            float snow_amount = ParticleSettings.get_float("snow_amount");
            float blizzard_snow_amount = ParticleSettings.get_float("blizzard_snow_amount");
            float blizzard_wind_amount = ParticleSettings.get_float("blizzard_wind_amount");
            if (world.method_8546()) {
                ParticleEngine.try_spawn_particle_in_height_range((class_2394)BiomeParticleWeather.BLIZZARD_SNOW, new Vector3(player_pos.method_1031(0.0, 0.0, 8.0)), new Vector3((float)ParticleEngine.get_rand_radius().field_1352, 8.0f), blizzard_snow_amount, 63.0f, 256.0f);
                ParticleEngine.try_spawn_particle_in_height_range((class_2394)BiomeParticleWeather.BLIZZARD_WIND, player_pos, new Vector3((float)ParticleEngine.get_rand_radius().field_1352, 8.0f), blizzard_wind_amount, 63.0f, 256.0f);
            } else if (world.method_8419()) {
                FloatifiedForLoop.run(i -> {
                    Vector3 rand = ParticleEngine.get_rand_radius();
                    Vector3 pos = new Vector3(player_pos.method_1019(new Vector3(rand.field_1352, 8.0, rand.field_1350)));
                    if (pos.method_1023(0.0, 8.0, 0.0).method_1022((class_243)player_pos) > 1.0 && world.method_8311(pos.to_blockpos())) {
                        ParticleEngine.spawn_particle((class_2394)BiomeParticleWeather.SNOW, pos);
                    }
                }, snow_amount);
            }
        }
    }

    public static void updraft() {
        Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
        class_638 world = class_310.method_1551().field_1687;
        boolean a = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_23859);
        boolean b = world.method_23753(player_pos.to_blockpos()).method_40225(class_1972.field_9461);
        if (a || b) {
            ParticleEngine.try_spawn_particle((class_2394)BiomeParticleWeather.UPDRAFT, player_pos, new Vector3(16.0f, 8.0f), ParticleSettings.get_float("updraft_amount"));
        }
    }

    public static void fog() {
        class_6880<class_1959> biome = ParticleUtil.get_biome_at(class_2338.method_49638((class_2374)ParticleUtil.get_player_pos_plus_vel(2.0f)));
        if ((biome.method_40225(class_1972.field_9471) || biome.method_40225(class_1972.field_38748)) && ParticleUtil.get_world().method_8419()) {
            Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
            FloatifiedForLoop.run(i -> {
                Vector3 rand = ParticleEngine.get_rand_radius();
                Vector3 pos = new Vector3(player_pos.method_1019(new Vector3(rand.field_1352, 8.0, rand.field_1350)));
                ParticleEngine.spawn_particle_on_surface((class_2394)BiomeParticleWeather.FOG, pos.field_1352, pos.field_1350, pos.field_1351, class_3532.method_32750((class_5819)class_5819.method_43053(), (float)0.15f, (float)0.35f), new Vector3(0.0f));
            }, ParticleSettings.get_float("fog_amount"));
        }
    }

    public static void wind() {
        class_6880<class_1959> biome = ParticleUtil.get_biome_at(class_2338.method_49638((class_2374)ParticleUtil.get_player_pos_plus_vel(2.0f)));
        class_638 world = class_310.method_1551().field_1687;
        boolean a1 = biome.method_40225(class_1972.field_9449) || biome.method_40225(class_1972.field_9430);
        boolean b1 = biome.method_40225(class_1972.field_35114);
        if (world.method_8419() && (a1 || b1)) {
            Vector3 player_pos = ParticleUtil.get_player_pos_plus_vel(2.0f);
            ParticleEngine.spawn_particle((class_2394)BiomeParticleWeather.WIND, player_pos, ParticleSettings.get_float("wind_amount"), new Vector3(ParticleEngine.get_rand_radius().field_1352, 8.0, ParticleEngine.get_rand_radius().field_1352));
        }
    }

    public static void custom() {
        try {
            for (String string : CustomParticleRegistry.behaviors.keySet()) {
                int amount = CustomParticleRegistry.behaviors.get(string).particle_parameters().amount();
                FloatifiedForLoop.run(i -> ParticleEngine.try_spawn_custom_particle(string, ParticleUtil.get_player_pos_plus_vel(2.0f)), amount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void spawn_particle_on_surface(class_2394 effect, double x, double z, double ypos, float y_offset, Vector3 rand_ofs) {
        class_638 world = ParticleUtil.get_world();
        class_243 pos = new Vector3((class_2382)world.method_8598(class_2902.class_2903.field_13197, class_2338.method_49637((double)x, (double)ypos, (double)z))).method_1019(Vector3.rand_between(rand_ofs.negate(), rand_ofs).with_y(0.0));
        ParticleEngine.spawn_particle(effect, new Vector3(pos.method_10216(), pos.method_10214() + (double)y_offset, pos.method_10215()));
    }

    public static void try_spawn_particle_in_height_range(class_2394 effect, Vector3 pos_origin, Vector3 max_ofs, float amount, float min_y, float max_y) {
        class_638 world = class_310.method_1551().field_1687;
        FloatifiedForLoop.run(i -> {
            boolean in_range;
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_2338 bp = pos.to_blockpos();
            class_2680 block_at = world.method_8320(bp);
            boolean is_not_solid = !block_at.method_26212((class_1922)world, bp);
            boolean bl = in_range = pos.field_1351 > (double)min_y && pos.field_1351 < (double)max_y;
            if (is_not_solid && in_range) {
                ParticleEngine.spawn_particle(effect, pos);
            }
        }, amount);
    }

    public static void try_spawn_particle(class_2394 effect, Vector3 pos_origin, Vector3 max_ofs, float amount) {
        class_638 world = class_310.method_1551().field_1687;
        FloatifiedForLoop.run(i -> {
            boolean is_not_solid;
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_2338 bp = pos.to_blockpos();
            class_2680 block_at = world.method_8320(bp);
            boolean bl = is_not_solid = !block_at.method_26212((class_1922)world, bp);
            if (is_not_solid) {
                ParticleEngine.spawn_particle(effect, pos);
            }
        }, amount);
    }

    public static void try_spawn_particle(class_2394 effect, Vector3 pos_origin, float max_ofs, float amount) {
        class_638 world = class_310.method_1551().field_1687;
        FloatifiedForLoop.run(i -> {
            boolean is_not_solid;
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_2338 bp = pos.to_blockpos();
            class_2680 block_at = world.method_8320(bp);
            boolean bl = is_not_solid = !block_at.method_26212((class_1922)world, bp);
            if (is_not_solid) {
                ParticleEngine.spawn_particle(effect, pos);
            }
        }, amount);
    }

    public static void try_spawn_particle_under_block(class_2394 effect, class_2248 block, Vector3 pos, float tries) {
        class_638 world = ParticleUtil.get_world();
        FloatifiedForLoop.run(i -> {
            Vector3 ofs = pos.with_random_offset(ParticleEngine.get_rand_radius());
            class_2680 bs = world.method_8320(ofs.to_blockpos());
            class_2680 bs_under = world.method_8320(ofs.to_blockpos().method_10093(class_2350.field_11033));
            Vector3 under_pos = ofs.with_y(Math.floor(ofs.field_1351) - (double)0.05f);
            if (bs.method_27852(block) && bs_under.method_26215()) {
                ParticleEngine.spawn_particle(effect, under_pos);
            }
        }, tries);
    }

    public static void try_spawn_particle_above_block(class_2394 effect, class_2248 block, Vector3 pos, int y_ofs, float tries) {
        class_638 world = ParticleUtil.get_world();
        FloatifiedForLoop.run(i -> {
            class_2680 bs = world.method_8320(pos.to_blockpos());
            class_2680 bs_over = world.method_8320(pos.to_blockpos().method_10079(class_2350.field_11036, y_ofs));
            Vector3 over_pos = pos.with_y(Math.floor(pos.field_1351) + (double)y_ofs);
            if (bs.method_27852(block) && bs_over.method_26215()) {
                ParticleEngine.spawn_particle(effect, over_pos);
            }
        }, tries);
    }

    public static void try_spawn_particle_above_block(class_2394 effect, class_2248 block, Vector3 pos_origin, int max_ofs, int y_ofs, float tries) {
        class_638 world = ParticleUtil.get_world();
        FloatifiedForLoop.run(i -> {
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_2680 bs = world.method_8320(pos.to_blockpos());
            class_2680 bs_over = world.method_8320(pos.to_blockpos().method_10079(class_2350.field_11036, y_ofs));
            Vector3 over_pos = pos.with_y(Math.floor(pos.field_1351) + (double)y_ofs);
            if (bs.method_27852(block) && bs_over.method_26215()) {
                ParticleEngine.spawn_particle(effect, over_pos);
            }
        }, tries);
    }

    public static void spawn_particle(class_2394 effect, Vector3 pos) {
        class_310.method_1551().field_1687.method_8406(effect, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
    }

    public static void spawn_particle(class_2394 effect, Vector3 pos_origin, float tries, float max_ofs) {
        FloatifiedForLoop.run(i -> {
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_310.method_1551().field_1687.method_8406(effect, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
        }, tries);
    }

    public static void spawn_particle(class_2394 effect, Vector3 pos_origin, float tries, Vector3 max_ofs) {
        FloatifiedForLoop.run(i -> {
            Vector3 pos = pos_origin.with_random_offset(max_ofs);
            class_310.method_1551().field_1687.method_8406(effect, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
        }, tries);
    }

    public static Vector3 get_rand_radius() {
        return Vector3.rand_between(new Vector3(-ParticleSettings.get_int("spawn_radius")), new Vector3(ParticleSettings.get_int("spawn_radius")));
    }

    public static void try_spawn_custom_particle(String particle_name, Vector3 pos) {
        try {
            CustomParticleBehavior behavior;
            class_638 world = class_310.method_1551().field_1687;
            if (world != null && (behavior = (CustomParticleBehavior)CustomParticleRegistry.behaviors.getOrDefault(particle_name, null)) != null) {
                CustomParticle particle;
                SpawnRangeParameters range = behavior.parameters().range_parameters();
                Vector3 min = range.min_range();
                Vector3 max = range.max_range();
                Vector3 rand = new Vector3(Vector3.rand_between(min, max).method_1019(pos));
                if (behavior.parameters().conditions().test((class_1937)world, rand.to_blockpos()) && (particle = (CustomParticle)class_310.method_1551().field_1713.method_3056((class_2394)BiomeParticleWeather.CUSTOM, rand.field_1352, rand.field_1351, rand.field_1350, 0.0, 0.0, 0.0)) != null) {
                    particle.particle_name = particle_name;
                    particle.init();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

