/*
 * Decompiled with CFR 0.152.
 */
package einstein.armortrimitemfix;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmorTrimItemFix {
    public static final String MOD_ID = "armortrimitemfix";
    public static final String MOD_NAME = "ArmorTrimItemFix";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ArmorTrimItemFix");
    public static final ResourceLocation TRIM_PATTERN_PREDICATE_ID = ArmorTrimItemFix.loc("trim_pattern");
    public static final float DEFAULT_TRIM_VALUE = 0.001f;
    public static final Map<Item, TrimmableData> TRIMMABLES = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(Items.f_42407_, new TrimmableData("leather", ArmorItem.Type.HELMET));
        map.put(Items.f_42408_, new TrimmableData("leather", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42462_, new TrimmableData("leather", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42463_, new TrimmableData("leather", ArmorItem.Type.BOOTS));
        map.put(Items.f_42464_, new TrimmableData("chainmail", ArmorItem.Type.HELMET));
        map.put(Items.f_42465_, new TrimmableData("chainmail", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42466_, new TrimmableData("chainmail", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42467_, new TrimmableData("chainmail", ArmorItem.Type.BOOTS));
        map.put(Items.f_42468_, new TrimmableData("iron", ArmorItem.Type.HELMET));
        map.put(Items.f_42469_, new TrimmableData("iron", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42470_, new TrimmableData("iron", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42471_, new TrimmableData("iron", ArmorItem.Type.BOOTS));
        map.put(Items.f_42476_, new TrimmableData("golden", ArmorItem.Type.HELMET));
        map.put(Items.f_42477_, new TrimmableData("golden", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42478_, new TrimmableData("golden", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42479_, new TrimmableData("golden", ArmorItem.Type.BOOTS));
        map.put(Items.f_42472_, new TrimmableData("diamond", ArmorItem.Type.HELMET));
        map.put(Items.f_42473_, new TrimmableData("diamond", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42474_, new TrimmableData("diamond", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42475_, new TrimmableData("diamond", ArmorItem.Type.BOOTS));
        map.put(Items.f_42480_, new TrimmableData("netherite", ArmorItem.Type.HELMET));
        map.put(Items.f_42481_, new TrimmableData("netherite", ArmorItem.Type.CHESTPLATE));
        map.put(Items.f_42482_, new TrimmableData("netherite", ArmorItem.Type.LEGGINGS));
        map.put(Items.f_42483_, new TrimmableData("netherite", ArmorItem.Type.BOOTS));
        map.put(Items.f_42354_, new TrimmableData("turtle", ArmorItem.Type.HELMET));
    });
    public static final TreeSet<MaterialData> TRIM_MATERIALS = (TreeSet)Util.m_137469_(new TreeSet(), list -> {
        list.add(new MaterialData("quartz", 0.1f));
        list.add(new MaterialData("iron", 0.2f, (ArmorMaterial)ArmorMaterials.IRON, "iron_darker"));
        list.add(new MaterialData("netherite", 0.3f, (ArmorMaterial)ArmorMaterials.NETHERITE, "netherite_darker"));
        list.add(new MaterialData("redstone", 0.4f));
        list.add(new MaterialData("copper", 0.5f));
        list.add(new MaterialData("gold", 0.6f, (ArmorMaterial)ArmorMaterials.GOLD, "gold_darker"));
        list.add(new MaterialData("emerald", 0.7f));
        list.add(new MaterialData("diamond", 0.8f, (ArmorMaterial)ArmorMaterials.DIAMOND, "diamond_darker"));
        list.add(new MaterialData("lapis", 0.9f));
        list.add(new MaterialData("amethyst", 1.0f));
    });
    public static final Map<ResourceLocation, Float> TRIM_PATTERNS = ArmorTrimItemFix.createValueSortedMap((Map)Util.m_137469_(new HashMap(), map -> {
        List locations = (List)Util.m_137469_(new ArrayList(), list -> {
            list.add(TrimPatterns.f_265866_.m_135782_());
            list.add(TrimPatterns.f_265941_.m_135782_());
            list.add(TrimPatterns.f_265901_.m_135782_());
            list.add(TrimPatterns.f_266087_.m_135782_());
            list.add(TrimPatterns.f_266074_.m_135782_());
            list.add(TrimPatterns.f_266091_.m_135782_());
            list.add(TrimPatterns.f_266039_.m_135782_());
            list.add(TrimPatterns.f_266069_.m_135782_());
            list.add(TrimPatterns.f_266083_.m_135782_());
            list.add(TrimPatterns.f_266089_.m_135782_());
            list.add(TrimPatterns.f_265976_.m_135782_());
            list.add(TrimPatterns.f_276615_.m_135782_());
            list.add(TrimPatterns.f_276604_.m_135782_());
            list.add(TrimPatterns.f_276510_.m_135782_());
            list.add(TrimPatterns.f_276435_.m_135782_());
            list.add(TrimPatterns.f_276573_.m_135782_());
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("storm"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("ram"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("myth"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("greed"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("beast"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("fever"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("wraith"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("nihility"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("horizon"));
            list.add(ArmorTrimItemFix.moreArmorTrimsLoc("origin"));
        });
        float f = 0.0f;
        float f1 = 1.0f / (float)(locations.size() + 1);
        for (ResourceLocation location : locations) {
            map.put(location, Float.valueOf(f += f1));
        }
    }), Float::compare);

    public static void init() {
    }

    public static void clientSetup() {
        for (Item trimmable : TRIMMABLES.keySet()) {
            ArmorTrimItemFix.registerArmorTrimProperty(trimmable);
        }
    }

    public static void registerArmorTrimProperty(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)TRIM_PATTERN_PREDICATE_ID, (stack, level, entity, seed) -> {
            CompoundTag trimTag;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128441_("Trim") && (trimTag = tag.m_128469_("Trim")).m_128441_("pattern")) {
                String pattern = trimTag.m_128461_("pattern");
                Float value = TRIM_PATTERNS.get(ResourceLocation.m_135820_((String)pattern));
                return value == null ? 0.001f : value.floatValue();
            }
            return 0.0f;
        });
    }

    public static void registerDevCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnArmorTrimItemFrames").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            Level level = player.m_9236_();
            RegistryAccess registryAccess = level.m_9598_();
            Registry materialRegistry = registryAccess.m_175515_(Registries.f_266076_);
            Registry patternRegistry = registryAccess.m_175515_(Registries.f_266063_);
            BlockPos playerPos = player.m_20183_();
            BlockPos.MutableBlockPos pos = playerPos.m_122032_();
            int[] zOffset = new int[]{pos.m_123343_()};
            TRIMMABLES.forEach((item, type) -> {
                if (pos.m_123341_() - playerPos.m_123341_() >= (materialRegistry.m_13562_() + 1) * 5) {
                    zOffset[0] = pos.m_123343_() + patternRegistry.m_13562_() + 1;
                    pos.m_142451_(playerPos.m_123341_());
                    pos.m_142443_(zOffset[0]);
                }
                materialRegistry.forEach(material -> {
                    pos.m_142451_(pos.m_123341_() + 1);
                    patternRegistry.forEach(pattern -> {
                        ItemFrame itemFrame = new ItemFrame(level, level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos.m_142443_(pos.m_123343_() + 1)), Direction.UP);
                        ItemStack stack = new ItemStack((ItemLike)item);
                        ArmorTrim.m_266570_((RegistryAccess)registryAccess, (ItemStack)stack, (ArmorTrim)new ArmorTrim(materialRegistry.m_263177_(material), patternRegistry.m_263177_(pattern)));
                        itemFrame.m_31805_(stack);
                        level.m_7967_((Entity)itemFrame);
                    });
                    pos.m_142443_(zOffset[0]);
                });
                pos.m_142451_(pos.m_123341_() + 1);
            });
            source.m_288197_(() -> Component.m_237113_((String)"Spawned item frames with armor trims"), true);
            return 1;
        }));
    }

    public static ResourceLocation overrideName(TrimmableData data, ResourceLocation item, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("item/" + data.armorMaterial() + "/" + data.type().m_266355_() + "/" + item.m_135815_() + "_" + patternName + "_" + materialName + "_trim");
    }

    public static ResourceLocation vanillaOverrideName(ResourceLocation item, String materialName) {
        return new ResourceLocation(item.m_135815_() + "_" + materialName + "_trim");
    }

    public static ResourceLocation layerLoc(ArmorItem.Type armorType, String patternName, String materialName) {
        return ArmorTrimItemFix.loc("trims/items/" + armorType.m_266355_() + "/" + armorType.m_266355_() + "_" + patternName + "_trim_" + materialName);
    }

    public static boolean isDoubleLayered(Item item) {
        return item == Items.f_42407_ || item == Items.f_42408_ || item == Items.f_42462_ || item == Items.f_42463_;
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private static ResourceLocation moreArmorTrimsLoc(String path) {
        return new ResourceLocation("more_armor_trims", path);
    }

    public static <K, V> Map<K, V> createValueSortedMap(Map<K, V> map, Comparator<V> comparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(comparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public record TrimmableData(String armorMaterial, ArmorItem.Type type) {
    }

    public record MaterialData(String materialName, float propertyValue, ArmorMaterial armorMaterial, String overrideName) implements Comparable<MaterialData>
    {
        public MaterialData(String materialName, float propertyValue) {
            this(materialName, propertyValue, null, null);
        }

        public String getName(Item item) {
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                if (this.armorMaterial != null && this.overrideName != null && armorItem.m_40401_() == this.armorMaterial) {
                    return this.overrideName;
                }
            }
            return this.materialName;
        }

        @Override
        public int compareTo(@NotNull MaterialData o) {
            return Float.compare(this.propertyValue(), o.propertyValue());
        }
    }
}

