/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.data.server.modifiers;

import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.ParentModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAMobEffects;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FilledBucketTrigger;
import net.minecraft.advancements.critereon.FishingRodHookedTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public final class UAAdvancementModifierProvider
extends AdvancementModifierProvider {
    private static final EntityType<?>[] MOBS_TO_KILL = new EntityType[]{(EntityType)UAEntityTypes.THRASHER.get(), (EntityType)UAEntityTypes.GREAT_THRASHER.get(), (EntityType)UAEntityTypes.FLARE.get()};

    public UAAdvancementModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("upgrade_aquatic", output, provider);
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        String name;
        MobEffectsPredicate predicate = MobEffectsPredicate.m_56552_();
        UAMobEffects.MOB_EFFECTS.getEntries().forEach(mobEffect -> {
            MobEffect effect = (MobEffect)mobEffect.get();
            if (!effect.m_8093_()) {
                predicate.m_56553_(effect);
            }
        });
        this.entry("nether/all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, predicate), new ICondition[0]);
        this.entry("nether/all_potions").selects(new String[]{"nether/all_potions"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, predicate), new ICondition[0]);
        CriteriaModifier.Builder balancedDiet = CriteriaModifier.builder((String)this.modId);
        UAItems.HELPER.getDeferredRegister().getEntries().forEach(registryObject -> {
            Item item = (Item)registryObject.get();
            if (item.m_41472_()) {
                balancedDiet.addCriterion(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)item));
            }
        });
        this.entry("husbandry/balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)balancedDiet.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder fishyBusiness = CriteriaModifier.builder((String)this.modId);
        fishyBusiness.addCriterion("pike", (CriterionTriggerInstance)FishingRodHookedTrigger.TriggerInstance.m_40447_((ItemPredicate)ItemPredicate.f_45028_, (EntityPredicate)EntityPredicate.f_36550_, (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)UAItems.PIKE.get()}).m_45077_()));
        fishyBusiness.addCriterion("lionfish", (CriterionTriggerInstance)FishingRodHookedTrigger.TriggerInstance.m_40447_((ItemPredicate)ItemPredicate.f_45028_, (EntityPredicate)EntityPredicate.f_36550_, (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)UAItems.LIONFISH.get()}).m_45077_()));
        fishyBusiness.addCriterion("perch", (CriterionTriggerInstance)FishingRodHookedTrigger.TriggerInstance.m_40447_((ItemPredicate)ItemPredicate.f_45028_, (EntityPredicate)EntityPredicate.f_36550_, (ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)UAItems.PERCH.get()}).m_45077_()));
        this.entry("husbandry/fishy_business").selects(new String[]{"husbandry/fishy_business"}).addModifier((ObjectModifier)fishyBusiness.addIndexedRequirements(0, false, new String[]{"pike", "lionfish", "perch"}).build(), new ICondition[0]);
        CriteriaModifier.Builder killAMob = CriteriaModifier.builder((String)this.modId);
        CriteriaModifier.Builder killAllMobs = CriteriaModifier.builder((String)this.modId);
        ArrayList<String> names = new ArrayList<String>();
        for (EntityType<?> entityType : MOBS_TO_KILL) {
            name = ForgeRegistries.ENTITY_TYPES.getKey(entityType).m_135815_();
            KilledTrigger.TriggerInstance triggerInstance = KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType));
            killAMob.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            killAllMobs.addCriterion(name, (CriterionTriggerInstance)triggerInstance);
            names.add(name);
        }
        this.entry("adventure/kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)killAMob.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)killAllMobs.requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        CriteriaModifier.Builder tacticalFishing = CriteriaModifier.builder((String)this.modId);
        names = new ArrayList();
        for (RegistryObject object : UAItems.HELPER.getDeferredRegister().getEntries()) {
            Item item = (Item)object.get();
            if (!(item instanceof MobBucketItem)) continue;
            name = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
            tacticalFishing.addCriterion(name, (CriterionTriggerInstance)FilledBucketTrigger.TriggerInstance.m_38793_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()));
            names.add(name);
        }
        tacticalFishing.addCriterion("jellyfish_bucket", (CriterionTriggerInstance)FilledBucketTrigger.TriggerInstance.m_38793_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)UAItems.JELLYFISH_BUCKET.get()}).m_45077_()));
        names.add("jellyfish_bucket");
        this.entry("husbandry/tactical_fishing").selects(new String[]{"husbandry/tactical_fishing"}).addModifier((ObjectModifier)tacticalFishing.addIndexedRequirements(0, false, names.toArray(new String[0])).build(), new ICondition[0]);
        this.entry("adventure/throw_trident").selects(new String[]{"adventure/throw_trident"}).addModifier((ObjectModifier)new ParentModifier(new ResourceLocation("upgrade_aquatic", "adventure/tooth_fairy")), new ICondition[0]);
    }
}

