/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.google.common.collect.Lists;
import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedBlock;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedDoublePlantBlock;
import com.teamabnormals.upgrade_aquatic.common.block.PickerelweedPlantBlock;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.HideInPickerelweedGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeAttackGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeSwimToItemsGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.pike.PikeTemptGoal;
import com.teamabnormals.upgrade_aquatic.common.entity.animal.PikeType;
import com.teamabnormals.upgrade_aquatic.core.other.UADataSerializers;
import com.teamabnormals.upgrade_aquatic.core.other.tags.UABlockTags;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.upgrade_aquatic.core.registry.UAParticleTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UASoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Pike
extends BucketableWaterAnimal {
    private static final EntityDataAccessor<PikeType> TYPE = SynchedEntityData.m_135353_(Pike.class, UADataSerializers.PIKE_TYPE);
    private static final EntityDataAccessor<Boolean> DROP_ITEM = SynchedEntityData.m_135353_(Pike.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(Pike.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LIT = SynchedEntityData.m_135353_(Pike.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_COOLDOWN = SynchedEntityData.m_135353_(Pike.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<ItemEntity> ITEM_SELECTOR = entity -> !entity.m_32063_() && entity.m_6084_() && entity.m_20069_() && entity.m_32055_().m_204117_(ItemTags.f_13156_);
    private int eatTicks;
    private int dropEatingLootCooldown;

    public Pike(EntityType<? extends Pike> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.m_6672_(InteractionHand.MAIN_HAND);
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.9);
    }

    protected void m_8099_() {
        super.m_8099_();
        if (this.getPikeType() != PikeType.SPECTRAL) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Pike>((PathfinderMob)this, Pike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_SPECTRAL::test){

                public boolean m_8036_() {
                    return super.m_8036_() && this.f_25015_ != null && ((Pike)this.f_25015_).getPikeType() != PikeType.SPECTRAL;
                }
            });
        }
        this.f_21345_.m_25352_(3, (Goal)new PikeTemptGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.1, 40){

            public boolean m_8036_() {
                return ((Pike)this.f_25725_).isHidingInPickerelweed() ? super.m_8036_() && this.f_25725_.m_217043_().m_188503_(6) == 0 : super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new HideInPickerelweedGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PikeSwimToItemsGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new PikeAttackGoal((PathfinderMob)this, 12.0, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<AbstractFish>((Mob)this, AbstractFish.class, true){

            public boolean m_8036_() {
                return ((Pike)this.f_26135_).getAttackCooldown() <= 0 && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Turtle>((Mob)this, Turtle.class, 10, true, false, UAEntityPredicates.IS_CHILD::test){

            public boolean m_8036_() {
                return ((Pike)this.f_26135_).getAttackCooldown() <= 0 && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)PikeType.AMUR);
        this.f_19804_.m_135372_(DROP_ITEM, (Object)true);
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(LIT, (Object)false);
        this.f_19804_.m_135372_(ATTACK_COOLDOWN, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(TYPE)) {
            this.m_6210_();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("PikeType", this.getPikeType().id);
        compound.m_128405_("AttackCooldown", this.getAttackCooldown());
        compound.m_128405_("EatingLootDropCooldown", this.dropEatingLootCooldown);
        compound.m_128379_("DoesDropItem", this.shouldDropItem());
        compound.m_128379_("Lit", this.isLit());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPikeType(PikeType.getTypeById(Mth.m_14045_((int)compound.m_128451_("PikeType"), (int)1, (int)21)));
        this.dropEatingLootCooldown = compound.m_128451_("EatingLootDropCooldown");
        this.setAttackCooldown(compound.m_128451_("AttackCooldown"));
        this.setToDropItem(compound.m_128471_("DoesDropItem"));
        this.setLit(compound.m_128471_("Lit"));
    }

    public void m_8107_() {
        int i;
        LivingEntity caughtEntity;
        super.m_8107_();
        ++this.eatTicks;
        if (this.dropEatingLootCooldown > 0) {
            --this.dropEatingLootCooldown;
        }
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        if (this.m_9236_().m_46467_() % 20L == 0L && (caughtEntity = this.getCaughtEntity()) != null && (!this.isPickerelweedNearby() || this.isHidingInPickerelweed())) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)UASoundEvents.PIKE_BITE.get(), SoundSource.HOSTILE, 0.8f, 0.9f);
            if (this.m_9236_().f_46443_ && caughtEntity.m_21223_() <= 1.0f && this.getPikeType() == PikeType.SPECTRAL) {
                for (i = 0; i < 3; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)UAParticleTypes.SPECTRAL_CONSUME.get(), caughtEntity.m_20185_() + (caughtEntity.m_217043_().m_188500_() - 0.5) * (double)caughtEntity.m_20205_(), caughtEntity.m_20186_() + caughtEntity.m_217043_().m_188500_() * (double)caughtEntity.m_20206_() - 0.25, caughtEntity.m_20189_() + (caughtEntity.m_217043_().m_188500_() - 0.5) * (double)caughtEntity.m_20205_(), (this.getCaughtEntity().m_217043_().m_188500_() - 0.5) * 2.0, -caughtEntity.m_217043_().m_188500_(), (caughtEntity.m_217043_().m_188500_() - 0.5) * 2.0);
                }
            }
            caughtEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 1.0f);
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_() && !itemstack.m_41619_() && this.canEatItem(itemstack) && this.m_20069_()) {
            if (this.eatTicks > 600) {
                ItemStack itemstackFood = itemstack.m_41671_(this.m_9236_(), (LivingEntity)this);
                if (!itemstack.m_41619_()) {
                    this.m_8061_(EquipmentSlot.MAINHAND, itemstackFood);
                }
                if (this.dropEatingLootCooldown <= 0) {
                    if (this.f_19796_.m_188501_() < 0.2f) {
                        for (ItemStack stacks : this.generateFishingLoot()) {
                            if (stacks.m_41613_() > 0) {
                                stacks.m_41774_(stacks.m_41613_() - 1);
                            }
                            this.spitOutItem(stacks);
                        }
                    } else {
                        this.spitOutItem(new ItemStack((ItemLike)Items.f_42499_));
                    }
                    this.dropEatingLootCooldown = 3600 + this.m_217043_().m_188503_(400);
                }
                this.m_5634_(6.0f);
                this.eatTicks = 0;
            } else if (this.eatTicks > 560 && this.f_19796_.m_188501_() < 0.1f) {
                this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                this.m_9236_().m_7605_((Entity)this, (byte)45);
            }
        }
        if (this.isMoving() && this.m_20069_() && this.getPikeType() == PikeType.SUPERCHARGED) {
            Vec3 vec3d1 = this.m_20252_(0.0f);
            for (int i2 = 0; i2 < 2; ++i2) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82479_ * 1.5, this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - vec3d1.f_82480_ * 1.5, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82481_ * 1.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.getPikeType() == PikeType.OBSIDIAN && this.isLit() && this.m_9236_().f_46443_) {
            for (i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - 0.25, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    public void m_7023_(Vec3 p_213352_1_) {
        if (this.m_21515_() && this.m_20069_()) {
            float speed = this.getPikeType() == PikeType.SUPERCHARGED ? 0.05f : 0.01f;
            this.m_19920_(speed, p_213352_1_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_213352_1_);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entitySource = source.m_7639_();
        if (!(this.hasCaughtEntity() || !(entitySource instanceof LivingEntity) || entitySource instanceof Player && ((Player)entitySource).m_150110_().f_35937_)) {
            this.m_6710_((LivingEntity)source.m_7639_());
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int type = PikeType.getRandom((RandomSource)this.f_19796_, (Holder<Biome>)this.m_9236_().m_204166_((BlockPos)this.m_20183_()), (boolean)(reason == MobSpawnType.BUCKET ? true : false)).id;
        if (dataTag != null && dataTag.m_128425_("BucketVariantTag", 3)) {
            this.setPikeType(PikeType.getTypeById(dataTag.m_128451_("BucketVariantTag")));
            this.dropEatingLootCooldown = dataTag.m_128451_("EatingLootDropCooldown");
            if (dataTag.m_128441_("PikeHeldItem")) {
                this.m_6672_(InteractionHand.MAIN_HAND);
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("PikeHeldItem")));
            }
            if (dataTag.m_128441_("ShouldDropItem")) {
                this.setToDropItem(dataTag.m_128471_("ShouldDropItem"));
            }
            if (dataTag.m_128441_("IsLit")) {
                this.setLit(dataTag.m_128471_("IsLit"));
            }
            return spawnDataIn;
        }
        if (spawnDataIn instanceof PikeData) {
            type = ((PikeData)spawnDataIn).typeData;
        } else if (!this.m_27487_()) {
            spawnDataIn = new PikeData(type);
        }
        this.setPikeType(PikeType.getTypeById(type));
        if (this.f_19796_.m_188501_() <= 0.1f && this.m_21515_()) {
            List<ItemStack> generatedFishingLoot = this.generateFishingLoot();
            for (ItemStack itemstack : generatedFishingLoot) {
                this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            }
            this.setToDropItem(false);
        }
        this.m_6210_();
        return spawnDataIn;
    }

    public static boolean checkPikeSpawnRules(EntityType<? extends Pike> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        int count = BlockPos.m_121990_((BlockPos)pos.m_7918_(-4, -6, -4), (BlockPos)pos.m_7918_(4, 3, 4)).filter(offsetPos -> level.m_8055_(offsetPos).m_204336_(UABlockTags.PIKE_SPAWNERS)).toList().size();
        return random.m_188501_() < 0.05f * (float)count && WaterAnimal.m_218282_(entityType, (LevelAccessor)level, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42409_) {
            itemstack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(hand));
            this.m_5496_(SoundEvents.f_11942_, 1.0f, 1.0f);
            this.setLit(true);
            return InteractionResult.SUCCESS;
        }
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn){

            protected boolean m_7632_() {
                return super.m_7632_() || this.f_26494_.m_146900_().m_60734_() instanceof PickerelweedBlock;
            }

            public boolean m_6342_(BlockPos pos) {
                return super.m_6342_(pos) || this.f_26494_.m_146900_().m_60734_() instanceof PickerelweedBlock;
            }
        };
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UAItems.PIKE_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_6872_(ItemStack bucket) {
        super.m_6872_(bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        CompoundTag compoundnbt1 = new CompoundTag();
        compoundnbt.m_128405_("BucketVariantTag", this.getPikeType().id);
        compoundnbt.m_128405_("EatingLootDropCooldown", this.dropEatingLootCooldown);
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            this.m_6844_(EquipmentSlot.MAINHAND).m_41739_(compoundnbt1);
        }
        compoundnbt.m_128365_("PikeHeldItem", (Tag)compoundnbt1);
        compoundnbt.m_128379_("ShouldDropItem", this.shouldDropItem());
        compoundnbt.m_128379_("IsLit", this.isLit());
    }

    @Nullable
    public LivingEntity getCaughtEntity() {
        List passengers = this.m_20197_();
        if (!passengers.isEmpty()) {
            Entity passenger = (Entity)passengers.get(0);
            return passenger instanceof AbstractFish || passenger instanceof Animal ? (LivingEntity)passenger : null;
        }
        return null;
    }

    public boolean hasCaughtEntity() {
        return this.getCaughtEntity() != null;
    }

    public void spitOutItem(ItemStack stackIn) {
        if (!stackIn.m_41619_() && !this.m_9236_().f_46443_) {
            ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stackIn);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_20148_());
            this.m_5496_((SoundEvent)UASoundEvents.PIKE_SPIT.get(), 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)itementity);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    private boolean canEatItem(ItemStack itemstack) {
        return itemstack.m_204117_(ItemTags.f_13156_);
    }

    public boolean isPickerelweedNearby() {
        return this.getNearbyPickerelweeds().size() > 0;
    }

    public boolean isHidingInPickerelweed() {
        return this.m_20193_().m_8055_(this.m_20183_()).m_60734_() instanceof PickerelweedPlantBlock || this.m_20193_().m_8055_(this.m_20183_()).m_60734_() instanceof PickerelweedDoublePlantBlock;
    }

    public List<BlockPos> getNearbyPickerelweeds() {
        ArrayList pickerelweeds = Lists.newArrayList();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int yy = this.m_20183_().m_123342_() - 6;
        while ((double)yy <= this.m_20186_() + 6.0) {
            int xx = this.m_20183_().m_123341_() - 12;
            while ((double)xx <= this.m_20185_() + 12.0) {
                int zz = this.m_20183_().m_123343_() - 12;
                while ((double)zz <= this.m_20189_() + 12.0) {
                    mutable.m_122178_(xx, yy, zz);
                    Block block = this.m_9236_().m_8055_((BlockPos)mutable).m_60734_();
                    if (block instanceof PickerelweedPlantBlock || block instanceof PickerelweedDoublePlantBlock) {
                        pickerelweeds.add(mutable);
                    }
                    ++zz;
                }
                ++xx;
            }
            ++yy;
        }
        return pickerelweeds;
    }

    private List<ItemStack> generateFishingLoot() {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42523_)).m_287239_(2.0f);
        builder.m_287286_(LootContextParams.f_81458_, (Object)this).m_287286_(LootContextParams.f_81455_, (Object)this);
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.m_217043_().m_188501_() >= 0.1f ? BuiltInLootTables.f_78721_ : BuiltInLootTables.f_78722_);
        return loottable.m_287195_(builder.m_287235_(LootContextParamSets.f_81414_));
    }

    public int m_5792_() {
        return 3;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.6f;
    }

    public boolean m_21531_() {
        return this.m_20069_() && super.m_21531_();
    }

    protected float m_21519_(EquipmentSlot p_205712_1_) {
        return this.shouldDropItem() ? 100.0f : 0.0f;
    }

    public boolean m_7066_(ItemStack p_213365_1_) {
        EquipmentSlot equipmentslottype = Mob.m_147233_((ItemStack)p_213365_1_);
        if (!this.m_6844_(equipmentslottype).m_41619_()) {
            return false;
        }
        return equipmentslottype == EquipmentSlot.MAINHAND && super.m_7066_(p_213365_1_);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.m_32055_();
        if (this.m_7252_(itemstack) && !this.m_6844_(EquipmentSlot.MAINHAND).m_204117_(ItemTags.f_13156_)) {
            int i = itemstack.m_41613_();
            if (i > 1) {
                this.spawnItem(itemstack.m_41620_(i - 1));
            }
            this.spitOutItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.m_7938_((Entity)itemEntity, itemstack.m_41613_());
            itemEntity.m_146870_();
            this.eatTicks = 0;
        }
    }

    private void spawnItem(ItemStack stack) {
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
    }

    public void m_7938_(Entity entityIn, int quantity) {
        super.m_7938_(entityIn, quantity);
        this.setToDropItem(true);
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction function) {
        if (passenger instanceof AbstractFish || passenger instanceof Animal) {
            float distance = 0.7f;
            double dx = Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vec3 riderPos = new Vec3(this.m_20185_() + dx, this.m_20186_() + this.m_6048_() + this.m_146895_().m_6049_(), this.m_20189_() + dz);
            function.m_20372_(passenger, riderPos.f_82479_, riderPos.f_82480_, riderPos.f_82481_);
        } else {
            super.m_7332_(passenger);
        }
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)this.m_20089_()).f_20378_ * 0.075;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.PIKE_SPAWN_EGG.get());
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getPikeType().pikeSize.boxSize);
    }

    public boolean isLit() {
        return (Boolean)this.f_19804_.m_135370_(LIT);
    }

    private void setLit(boolean lit) {
        this.f_19804_.m_135381_(LIT, (Object)lit);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    private void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public int getAttackCooldown() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int ticks) {
        this.f_19804_.m_135381_(ATTACK_COOLDOWN, (Object)ticks);
    }

    public boolean shouldDropItem() {
        return (Boolean)this.f_19804_.m_135370_(DROP_ITEM);
    }

    public void setToDropItem(boolean bool) {
        this.f_19804_.m_135381_(DROP_ITEM, (Object)bool);
    }

    public PikeType getPikeType() {
        return (PikeType)((Object)this.f_19804_.m_135370_(TYPE));
    }

    public void setPikeType(PikeType type) {
        this.f_19804_.m_135381_(TYPE, (Object)type);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UASoundEvents.PIKE_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UASoundEvents.PIKE_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UASoundEvents.PIKE_HURT.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASoundEvents.PIKE_FLOP.get();
    }

    protected void m_7355_(BlockPos p_27482_, BlockState p_27483_) {
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Pike pike;

        MoveHelperController(Pike pike) {
            super((Mob)pike);
            this.pike = pike;
        }

        public void m_8126_() {
            if (this.pike.m_204029_(FluidTags.f_13131_)) {
                this.pike.m_20256_(this.pike.m_20184_().m_82520_(0.0, 0.001, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.pike.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.pike.m_20185_();
                double d1 = this.f_24976_ - this.pike.m_20186_();
                double d2 = this.f_24977_ - this.pike.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.pike.m_146922_(this.m_24991_(this.pike.m_146908_(), f, 90.0f));
                this.pike.f_20883_ = this.pike.m_146908_();
                float f1 = (float)(this.f_24978_ * this.pike.m_21051_(Attributes.f_22279_).m_22135_());
                this.pike.m_7910_(Mth.m_14179_((float)0.125f, (float)this.pike.m_6113_(), (float)f1));
                this.pike.m_20256_(this.pike.m_20184_().m_82520_(0.0, (double)this.pike.m_6113_() * d1 * 0.04, 0.0));
                this.pike.setMoving(true);
            } else {
                if (this.pike.getPikeType() == PikeType.SUPERCHARGED) {
                    this.pike.m_7910_(0.0f);
                }
                this.pike.setMoving(false);
            }
        }
    }

    static class PikeData
    implements SpawnGroupData {
        public final int typeData;

        public PikeData(int type) {
            this.typeData = type;
        }
    }
}

