/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.animal;

import com.teamabnormals.blueprint.common.entity.BucketableWaterAnimal;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.core.UAConfig;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Nautilus
extends BucketableWaterAnimal {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(Nautilus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.m_135353_(Nautilus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Nautilus(EntityType<? extends Nautilus> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public Nautilus(Level world, double posX, double posY, double posZ) {
        this((EntityType<? extends Nautilus>)((EntityType)UAEntityTypes.NAUTILUS.get()), world);
        this.m_6034_(posX, posY, posZ);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0);
    }

    public static boolean checkNautilusSpawnRules(EntityType<? extends PathfinderMob> entityType, LevelAccessor level, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return pos.m_123342_() <= (Integer)UAConfig.COMMON.nautilusMaxSpawnHeight.get() && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.65));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 9.0f, 1.5, 1.2, EntitySelector.f_20408_::test){

            public void m_8056_() {
                ((Nautilus)this.f_25015_).setFleeing(true);
                super.m_8056_();
            }

            public void m_8041_() {
                ((Nautilus)this.f_25015_).setFleeing(false);
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Squid>((PathfinderMob)this, Squid.class, 9.0f, 1.5, 1.2, EntitySelector.f_20408_::test){

            public void m_8056_() {
                ((Nautilus)this.f_25015_).setFleeing(true);
                super.m_8056_();
            }

            public void m_8041_() {
                ((Nautilus)this.f_25015_).setFleeing(false);
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal<Thrasher>((PathfinderMob)this, Thrasher.class, 9.0f, 1.5, 1.2, EntitySelector.f_20408_::test){

            public void m_8056_() {
                ((Nautilus)this.f_25015_).setFleeing(true);
                super.m_8056_();
            }

            public void m_8041_() {
                ((Nautilus)this.f_25015_).setFleeing(false);
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SwimGoal(this));
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12531_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12536_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.f_19804_.m_135370_(FLEEING);
    }

    public void setFleeing(boolean p_203706_1_) {
        this.f_19804_.m_135381_(FLEEING, (Object)p_203706_1_);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setMoving(boolean p_203706_1_) {
        this.f_19804_.m_135381_(MOVING, (Object)p_203706_1_);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Moving", this.isMoving());
        compound.m_128379_("Fleeing", this.isMoving());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMoving(compound.m_128471_("Moving"));
        this.setMoving(compound.m_128471_("Fleeing"));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)UAItems.NAUTILUS_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_8107_() {
        if (this.isMoving() && this.m_20069_() && this.f_19800_) {
            Vec3 vec3d1 = this.m_20252_(0.0f);
            if (this.m_20193_().m_46467_() % 2L == 0L) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82479_ * 0.75, this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - vec3d1.f_82480_ * 1.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() - vec3d1.f_82481_ * 0.75, 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public void m_7023_(Vec3 p_213352_1_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_213352_1_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_213352_1_);
        }
    }

    public void m_20321_(boolean downwards) {
    }

    public void m_6845_(boolean downwards) {
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.65f;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)UAItems.NAUTILUS_SPAWN_EGG.get());
    }

    public int m_5792_() {
        return 8;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Nautilus nautilus;

        MoveHelperController(Nautilus nautilus) {
            super((Mob)nautilus);
            this.nautilus = nautilus;
        }

        public void m_8126_() {
            if (this.nautilus.m_204029_(FluidTags.f_13131_)) {
                this.nautilus.m_20256_(this.nautilus.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.nautilus.m_21573_().m_26571_()) {
                double d0 = this.f_24975_ - this.nautilus.m_20185_();
                double d1 = this.f_24976_ - this.nautilus.m_20186_();
                double d2 = this.f_24977_ - this.nautilus.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.nautilus.m_146922_(this.m_24991_(this.nautilus.m_146908_(), f, 90.0f));
                this.nautilus.f_20883_ = this.nautilus.m_146908_();
                float f1 = (float)(this.f_24978_ * this.nautilus.m_21051_(Attributes.f_22279_).m_22135_());
                this.nautilus.m_7910_(Mth.m_14179_((float)0.125f, (float)this.nautilus.m_6113_(), (float)f1));
                this.nautilus.m_20256_(this.nautilus.m_20184_().m_82520_(0.0, (double)this.nautilus.m_6113_() * d1 * 0.03, 0.0));
                this.nautilus.setMoving(true);
            } else {
                this.nautilus.m_7910_(0.0f);
                this.nautilus.setMoving(false);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        public final Nautilus nautilus;

        public SwimGoal(Nautilus nautilus) {
            super((PathfinderMob)nautilus, 1.0, 30);
            this.nautilus = nautilus;
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }
}

