/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.common.entity.ai.goal.thrasher;

import com.teamabnormals.blueprint.core.endimator.PlayableEndimation;
import com.teamabnormals.blueprint.core.util.EntityUtil;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import com.teamabnormals.upgrade_aquatic.common.entity.monster.Thrasher;
import com.teamabnormals.upgrade_aquatic.common.entity.projectile.SonarWave;
import com.teamabnormals.upgrade_aquatic.core.registry.UAEntityTypes;
import com.teamabnormals.upgrade_aquatic.core.registry.UAPlayableEndimations;
import java.util.EnumSet;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.HitResult;

public class ThrasherFireSonarGoal
extends Goal {
    public Thrasher thrasher;
    private int turnTicks;
    private int sonarTicks;
    private int sonarFireDuration;
    private float originalYaw;
    private float originalPitch;
    @Nullable
    private SonarPhase sonarPhase;

    public ThrasherFireSonarGoal(Thrasher thrasher) {
        this.thrasher = thrasher;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        return SonarPhase.shouldContinueExecutingPhase(null, this.thrasher, this.sonarTicks) && this.thrasher.getTicksSinceLastSonarFire() > 55 && this.thrasher.isNoEndimationPlaying();
    }

    public boolean m_8045_() {
        boolean shouldContinue = SonarPhase.shouldContinueExecutingPhase(this.sonarPhase, this.thrasher, this.sonarTicks);
        return shouldContinue && (this.sonarPhase != SonarPhase.FIRE || this.thrasher.m_5448_() == null && (this.sonarTicks == 0 || this.sonarTicks == this.sonarFireDuration) || this.sonarTicks < this.sonarFireDuration);
    }

    public void m_8056_() {
        this.sonarPhase = SonarPhase.TURN;
        this.sonarFireDuration = this.thrasher.m_217043_().m_188503_(3) * 5 + 30;
    }

    public void m_8041_() {
        this.sonarFireDuration = 0;
        this.sonarTicks = 0;
        this.turnTicks = 0;
        this.sonarPhase = null;
        this.thrasher.setPossibleDetectionPoint(null);
        ((Thrasher.ThrasherLookController)this.thrasher.m_21563_()).setTurningForSonar(false);
    }

    public void m_8037_() {
        this.thrasher.m_21573_().m_26573_();
        if (this.sonarPhase == SonarPhase.TURN) {
            ++this.turnTicks;
            BlockPos pos = this.thrasher.getPossibleDetectionPoint();
            ((Thrasher.ThrasherLookController)this.thrasher.m_21563_()).setTurningForSonar(true);
            this.thrasher.m_21563_().m_24950_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 90.0f, 90.0f);
            if (this.turnTicks > 50) {
                this.sonarPhase = SonarPhase.FIRE;
            }
        } else {
            if (this.sonarTicks == 0 && SonarPhase.shouldContinueExecutingPhase(SonarPhase.FIRE, this.thrasher, this.sonarTicks)) {
                this.originalYaw = this.thrasher.m_146908_();
                this.originalPitch = this.thrasher.m_146909_();
                NetworkUtil.setPlayingAnimation((Entity)this.thrasher, (PlayableEndimation)UAPlayableEndimations.THRASHER_SONAR_FIRE);
                this.thrasher.m_5496_(this.thrasher.getSonarFireSound(), 3.5f, 1.0f);
            }
            ++this.sonarTicks;
            this.stablilizeDirection();
            if (this.sonarTicks % 5 == 0 && this.sonarTicks < this.sonarFireDuration) {
                SonarWave sonarWave = (SonarWave)((EntityType)UAEntityTypes.SONAR_WAVE.get()).m_20615_(this.thrasher.m_9236_());
                sonarWave.fireSonarWave(this.thrasher);
                this.thrasher.m_9236_().m_7967_((Entity)sonarWave);
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    private void stablilizeDirection() {
        this.thrasher.f_19859_ = this.originalYaw;
        this.thrasher.f_19860_ = this.originalPitch;
        this.thrasher.m_146922_(this.originalYaw);
        this.thrasher.m_146926_(this.originalPitch);
    }

    static enum SonarPhase {
        TURN(null),
        FIRE((thrasher, sonarTicks) -> sonarTicks <= 15 || EntityUtil.rayTrace((Entity)thrasher, (double)32.0, (float)1.0f).m_6662_() == HitResult.Type.MISS);

        @Nullable
        private final BiPredicate<Thrasher, Integer> phaseCondition;

        private SonarPhase(BiPredicate<Thrasher, Integer> phaseCondition) {
            this.phaseCondition = phaseCondition;
        }

        public static boolean shouldContinueExecutingPhase(@Nullable SonarPhase phase, Thrasher thrasher, int sonarTicks) {
            boolean defaultCondition;
            boolean bl = defaultCondition = !thrasher.isStunned() && thrasher.m_20069_() && thrasher.m_20197_().isEmpty() && thrasher.m_5448_() == null && thrasher.getPossibleDetectionPoint() != null && thrasher.m_9236_().m_8055_(thrasher.m_20183_().m_7495_()).m_60734_() == Blocks.f_49990_;
            if (phase == null) {
                return defaultCondition;
            }
            return defaultCondition && (phase.phaseCondition == null || phase.phaseCondition.test(thrasher, sonarTicks));
        }
    }
}

