/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.mixin;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.content.trading_depot.behavior.CommonTradingDepotBehaviorAccess;
import com.cak.trading_floor.foundation.AttachedTradingDepotFinder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.WorkAtComposter;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.LevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorkAtComposter.class})
public class WorkAtComposterMixin
extends WorkAtPoi {
    @Inject(method={"useWorkstation"}, at={@At(value="HEAD")})
    public void useWorkstation(ServerLevel level, Villager villager, CallbackInfo ci) {
        this.trading_floor$innerUseWorkstation(level, villager, ci);
    }

    @Unique
    private void trading_floor$innerUseWorkstation(ServerLevel level, Villager villager, CallbackInfo ci) {
        Optional jobSite = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (jobSite.isEmpty()) {
            return;
        }
        BlockPos jobSitePos = ((GlobalPos)jobSite.get()).m_122646_();
        List<BlockPos> tradingDepotPositions = AttachedTradingDepotFinder.lookForTradingDepots((LevelAccessor)level, jobSitePos);
        List<CommonTradingDepotBlockEntity> tradingDepots = tradingDepotPositions.stream().map(pos -> (CommonTradingDepotBlockEntity)level.m_7702_(pos)).filter(Objects::nonNull).filter(CommonTradingDepotBlockEntity::hasInputStack).toList();
        List<CommonTradingDepotBehaviorAccess> tradingDepotBehaviours = tradingDepots.stream().map(CommonTradingDepotBlockEntity::getCommonTradingDepotBehaviour).toList();
        tradingDepots.forEach(depot -> depot.tryTradeWith(villager, tradingDepotBehaviours));
    }
}

