/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.BitSetUtil;
import folk.sisby.surveyor.util.ListUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record S2CUpdateRegionPacket(boolean shared, class_1923 regionPos, List<Integer> biomePalette, List<Integer> blockPalette, BitSet set, List<ChunkSummary> chunks) implements S2CPacket
{
    public static final class_2960 ID = new class_2960("surveyor", "s2c_update_region");

    public static S2CUpdateRegionPacket of(boolean shared, class_1923 regionPos, RegionSummary summary, BitSet keys) {
        return summary.createUpdatePacket(shared, regionPos, keys);
    }

    public static S2CUpdateRegionPacket read(class_2540 buf) {
        return new S2CUpdateRegionPacket(buf.readBoolean(), buf.method_36133(), buf.method_34066(class_2540::method_10816), buf.method_34066(class_2540::method_10816), buf.method_33558(), (List)buf.method_34068(ArrayList::new, ChunkSummary::new));
    }

    @Override
    public void writeBuf(class_2540 buf) {
        buf.writeBoolean(this.shared);
        buf.method_36130(this.regionPos);
        buf.method_34062(this.biomePalette, class_2540::method_10804);
        buf.method_34062(this.blockPalette, class_2540::method_10804);
        buf.method_33557(this.set);
        buf.method_34062(this.chunks, (b, summary) -> summary.writeBuf((class_2540)b));
    }

    @Override
    public Collection<class_2540> toBufs() {
        ArrayList<class_2540> bufs = new ArrayList<class_2540>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        this.writeBuf(buf);
        if (buf.readableBytes() < 0x100000) {
            bufs.add(buf);
        } else {
            if (this.set.cardinality() == 1) {
                int bit = this.set.stream().findFirst().orElseThrow();
                Surveyor.LOGGER.error("Couldn't create a terrain update packet at {} - an individual chunk would be too large to send!", (Object)"[%d,%d]".formatted(this.regionPos.field_9181 + RegionSummary.xForBit(bit), this.regionPos.field_9180 + RegionSummary.zForBit(bit)));
                return List.of();
            }
            for (BitSet splitChunks : BitSetUtil.half(this.set)) {
                bufs.addAll(new S2CUpdateRegionPacket(this.shared, this.regionPos, this.biomePalette, this.blockPalette, splitChunks, ListUtil.splitSet(this.chunks, splitChunks, this.set)).toBufs());
            }
        }
        return bufs;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }
}

