/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils.forge;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.registries.ForgeRegistries;

public class FlowerPotHandlerImpl {
    private static Map<Block, Map<ResourceLocation, Supplier<? extends Block>>> FULL_POTS;

    public static Block getFullPot(FlowerPotBlock emptyPot, Block flowerBlock) {
        return FULL_POTS.get(emptyPot.getEmptyPot()).getOrDefault(Utils.getID((Block)flowerBlock), () -> Blocks.f_50016_).get();
    }

    public static boolean isEmptyPot(Block b) {
        return FULL_POTS != null && b != null && FULL_POTS.containsKey(b);
    }

    public static void setup() {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(Utils.getID((Item)ModRegistry.FLAX_ITEM.get()), ModRegistry.FLAX_POT);
        HashSet<FlowerPotBlock> emptyPots = new HashSet<FlowerPotBlock>();
        for (Block b : ForgeRegistries.BLOCKS) {
            if (!(b instanceof FlowerPotBlock)) continue;
            FlowerPotBlock flowerPotBlock = (FlowerPotBlock)b;
            emptyPots.add(flowerPotBlock.getEmptyPot());
        }
        FULL_POTS = new IdentityHashMap<Block, Map<ResourceLocation, Supplier<? extends Block>>>();
        for (FlowerPotBlock pot : emptyPots) {
            FULL_POTS.put((Block)pot, pot.getFullPotsView());
        }
    }

    public static Block getEmptyPot(FlowerPotBlock fullPot) {
        return fullPot.getEmptyPot();
    }
}

