/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.simplybuttons.network.packet;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import earth.terrarium.heracles.client.handlers.ClientQuests;
import earth.terrarium.heracles.common.menus.quests.QuestsContent;
import earth.terrarium.heracles.common.utils.ModUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.moddercoder.simplybuttons.util.ReLo;

public record SyncQuestStatusS2CPacket(Map<String, ModUtils.QuestStatus> questStatuses) implements Packet<SyncQuestStatusS2CPacket>
{
    public static final ClientboundPacketType<SyncQuestStatusS2CPacket> TYPE = new Type();

    public PacketType<SyncQuestStatusS2CPacket> type() {
        return TYPE;
    }

    private static class Type
    implements ClientboundPacketType<SyncQuestStatusS2CPacket> {
        private Type() {
        }

        public SyncQuestStatusS2CPacket decode(FriendlyByteBuf buffer) {
            HashMap<String, ModUtils.QuestStatus> questStatuses = new HashMap<String, ModUtils.QuestStatus>();
            int questStatusCount = buffer.readInt();
            for (int i = 0; i < questStatusCount; ++i) {
                String questId = buffer.m_130277_();
                ModUtils.QuestStatus questStatus = ModUtils.QuestStatus.values()[buffer.readByte()];
                questStatuses.put(questId, questStatus);
            }
            return new SyncQuestStatusS2CPacket(questStatuses);
        }

        public void encode(SyncQuestStatusS2CPacket packet, FriendlyByteBuf buffer) {
            buffer.writeInt(packet.questStatuses.size());
            packet.questStatuses.forEach((questId, questStatus) -> {
                buffer.m_130070_(questId);
                buffer.writeByte((int)((byte)questStatus.ordinal()));
            });
        }

        public ResourceLocation id() {
            return ReLo.of("sync_quest_status");
        }

        public Class<SyncQuestStatusS2CPacket> type() {
            return SyncQuestStatusS2CPacket.class;
        }

        public Runnable handle(SyncQuestStatusS2CPacket packet) {
            return () -> ClientQuests.syncGroup((QuestsContent)new QuestsContent("", packet.questStatuses, false));
        }
    }
}

