/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.config.VisibilityState;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ConfirmDeletionScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.RenameScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageHolder;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScreenshotWidget
extends AbstractWidget
implements AutoCloseable,
ScreenshotImageHolder {
    private final ManageScreenshotsScreen mainScreen;
    private final Minecraft client;
    private final Context ctx;
    private VisibilityState textVisibility;
    private float backgroundOpacityPercentage;
    private int textColor;
    private boolean renderTextShadow;
    private boolean promptOnDelete;
    private List<ClientTooltipComponent> hintTooltip;
    private File screenshotFile;
    private CompletableFuture<NativeImage> image;
    @Nullable
    private DynamicTexture texture;
    private boolean selectedForDeletion;
    private float hoverTime;
    private int baseY;

    public ScreenshotWidget(ManageScreenshotsScreen mainScreen, int x, int y, int width, int height, Context ctx, File screenshotFile) {
        super(x, y, width, height, (Component)Component.m_237113_((String)screenshotFile.getName()));
        this.mainScreen = mainScreen;
        this.client = mainScreen.client();
        this.baseY = y;
        this.ctx = ctx;
        this.screenshotFile = screenshotFile;
        this.image = this.getImage(screenshotFile);
        this.onConfigUpdate();
    }

    void updateBaseY(int baseY) {
        this.baseY = baseY;
        this.m_253211_(this.baseY);
    }

    void updateY(int scrollY) {
        this.m_253211_(this.baseY - scrollY);
    }

    void deleteScreenshot() {
        if (this.screenshotFile.exists() && !this.screenshotFile.delete()) {
            ManageScreenshotsScreen.LOGGER.error("Failed to delete 'screenshot' file at location '{}'", (Object)this.screenshotFile.toPath().toAbsolutePath());
            return;
        }
        this.ctx.removeEntry(this);
    }

    void onConfigUpdate() {
        this.textVisibility = (VisibilityState)((Object)ManageScreenshotsScreen.CONFIG.screenshotElementTextVisibility.get());
        this.backgroundOpacityPercentage = (float)((Integer)ManageScreenshotsScreen.CONFIG.screenshotElementBackgroundOpacity.get()).intValue() / 100.0f;
        this.textColor = Optional.ofNullable(TextColor.m_131268_((String)((String)ManageScreenshotsScreen.CONFIG.screenshotElementTextColor.get()))).map(TextColor::m_131265_).orElse(0xFFFFFF);
        this.renderTextShadow = (Boolean)ManageScreenshotsScreen.CONFIG.renderScreenshotElementFontShadow.get();
        this.promptOnDelete = (Boolean)ManageScreenshotsScreen.CONFIG.promptWhenDeletingScreenshot.get();
        this.hintTooltip = (Boolean)ManageScreenshotsScreen.CONFIG.displayHintTooltip.get() != false ? ScreenshotViewerUtils.toColoredComponents(this.client, (Component)ScreenshotViewerTexts.translatable("tooltip", "menu_hint", new Object[0]).m_130940_(ChatFormatting.GRAY)) : List.of();
    }

    void updateHoverState(int mouseX, int mouseY, int viewportY, int viewportBottom, boolean updateHoverState) {
        this.f_93622_ = updateHoverState && mouseX >= this.m_252754_() && mouseY >= Math.max(this.m_252907_(), viewportY) && mouseX < this.m_252754_() + this.f_93618_ && mouseY < Math.min(this.m_252907_() + this.f_93619_, viewportBottom);
    }

    boolean isSelectedForDeletion() {
        return this.selectedForDeletion;
    }

    void deselectForDeletion() {
        this.selectedForDeletion = false;
    }

    void render(GuiGraphics context, int mouseX, int mouseY, float partialTick, int viewportY, int viewportBottom) {
        this.hoverTime = this.f_93622_ ? this.hoverTime + partialTick : 0.0f;
        this.renderBackground(context, viewportY, viewportBottom);
        int spacing = 2;
        DynamicTexture image = this.texture();
        if (image != null && image.m_117991_() != null) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (int)image.m_117963_());
            RenderSystem.enableBlend();
            int renderY = Math.max(this.m_252907_() + 2, viewportY);
            int imgHeight = (int)((double)this.f_93619_ / (VisibilityState.HIDDEN.equals((Object)this.textVisibility) ? 1.0 : 1.08) - 6.0);
            int topOffset = Math.max(0, viewportY - this.m_252907_() - 2);
            int bottomOffset = Math.max(0, this.m_252907_() + 2 + imgHeight - viewportBottom);
            int topV = topOffset * image.m_117991_().m_85084_() / imgHeight;
            int bottomV = bottomOffset * image.m_117991_().m_85084_() / imgHeight;
            ScreenshotViewerUtils.drawTexture(context, this.m_252754_() + 2, renderY, this.f_93618_ - 4, imgHeight - topOffset - bottomOffset, 0, topV, image.m_117991_().m_84982_(), image.m_117991_().m_85084_() - topV - bottomV, image.m_117991_().m_84982_(), image.m_117991_().m_85084_());
            if (this.mainScreen.isFastDeleteToggled() && this.selectedForDeletion) {
                context.m_280509_(this.m_252754_() + 2, renderY, this.m_252754_() + this.f_93618_ - 2, renderY + imgHeight - topOffset - bottomOffset, 0x50FF0000);
            }
            RenderSystem.disableBlend();
        }
        if (VisibilityState.VISIBLE.equals((Object)this.textVisibility) || VisibilityState.SHOW_ON_HOVER.equals((Object)this.textVisibility) && this.f_93622_) {
            float scaleFactor = (float)(this.client.m_91268_().m_85446_() / 96) / (float)this.ctx.screenshotsPerRow();
            int textY = this.m_252907_() + (int)((double)this.f_93619_ / 1.08) - 2;
            if (textY > viewportY) {
                float f = textY;
                Objects.requireNonNull(this.client.f_91062_);
                if (f + scaleFactor * 9.0f < (float)viewportBottom) {
                    PoseStack matrices = context.m_280168_();
                    matrices.m_85836_();
                    matrices.m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)textY, 0.0f);
                    matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
                    Component message = this.m_6035_();
                    float centerX = -this.client.f_91062_.m_92852_((FormattedText)this.m_6035_()) / 2;
                    context.m_280614_(this.client.f_91062_, message, (int)centerX, 0, this.textColor, this.renderTextShadow);
                    matrices.m_85849_();
                }
            }
        }
        if (!this.mainScreen.isFastDeleteToggled() && !this.hintTooltip.isEmpty() && this.hoverTime > 20.0f) {
            context.m_280246_(1.0f, 1.0f, 1.0f, Math.min(this.hoverTime - 20.0f, 10.0f) / 10.0f * 0.7f);
            ScreenshotViewerUtils.renderTooltip(context, this.client.f_91062_, this.hintTooltip, mouseX, mouseY);
            context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    private void renderBackground(GuiGraphics graphics, int viewportY, int viewportBottom) {
        int renderY = Math.max(this.m_252907_(), viewportY);
        int renderHeight = Math.min(this.m_252907_() + this.f_93619_, viewportBottom);
        graphics.m_280509_(this.m_252754_(), renderY, this.m_252754_() + this.f_93618_, renderHeight, FastColor.ARGB32.m_13660_((int)((int)(Math.min(this.hoverTime, 10.0f) / 10.0f * this.backgroundOpacityPercentage * 255.0f)), (int)255, (int)255, (int)255));
    }

    private void onClick() {
        if (this.mainScreen.isFastDeleteToggled()) {
            this.selectedForDeletion = !this.selectedForDeletion;
        } else {
            this.mainScreen.enlargeScreenshot(this);
        }
    }

    private void onRightClick(double mouseX, double mouseY) {
        this.mainScreen.showScreenshotProperties(mouseX, mouseY, this);
    }

    private void updateScreenshotFile(File screenshotFile) {
        this.screenshotFile = screenshotFile;
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.texture = null;
        this.image = this.getImage(screenshotFile);
    }

    private CompletableFuture<NativeImage> getImage(File file) {
        return CompletableFuture.supplyAsync(() -> {
            NativeImage nativeImage;
            FileInputStream inputStream = new FileInputStream(file);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)inputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ManageScreenshotsScreen.LOGGER.error("Failed to load screenshot: {}", (Object)file.getName(), (Object)e);
                    return null;
                }
            }
            ((InputStream)inputStream).close();
            return nativeImage;
        }, Util.m_183991_());
    }

    @Nullable
    public DynamicTexture texture() {
        NativeImage nativeImage;
        if (this.texture != null) {
            return this.texture;
        }
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        if (this.image.isDone() && (nativeImage = this.image.join()) != null) {
            this.texture = new DynamicTexture(nativeImage);
            return this.texture;
        }
        return null;
    }

    @Override
    public File getScreenshotFile() {
        return this.screenshotFile;
    }

    @Override
    public void openFile() {
        Util.m_137581_().m_137644_(this.screenshotFile);
    }

    @Override
    public void copyScreenshot() {
        ScreenshotViewerUtils.copyImageToClipboard(this.screenshotFile);
    }

    @Override
    public void requestFileDeletion() {
        BooleanConsumer deleteAction = value -> {
            if (value) {
                this.deleteScreenshot();
                this.mainScreen.enlargeScreenshot(null);
            }
            this.mainScreen.setDialogScreen(null);
        };
        if (this.promptOnDelete) {
            this.mainScreen.setDialogScreen((Screen)new ConfirmDeletionScreen(deleteAction, (Component)Component.m_237110_((String)"screen.screenshot_viewer.delete_prompt", (Object[])new Object[]{this.screenshotFile.getName()}), ScreenshotViewerTexts.DELETE_WARNING_MESSAGE));
            return;
        }
        deleteAction.accept(true);
    }

    @Override
    public void renameFile() {
        String fileName = this.screenshotFile.getName();
        this.mainScreen.setDialogScreen(new RenameScreenshotScreen(fileName.substring(0, fileName.lastIndexOf(46)), s -> {
            try {
                Path moved = Files.move(this.screenshotFile.toPath(), this.screenshotFile.toPath().resolveSibling((String)s), new CopyOption[0]);
                this.updateScreenshotFile(moved.toFile());
            }
            catch (IOException e) {
                ManageScreenshotsScreen.LOGGER.error("Failed to rename 'screenshot' file at '" + this.screenshotFile.toPath().toAbsolutePath() + "' from '" + this.screenshotFile.getName() + "' to '" + s + "'", (Throwable)e);
            }
        }, () -> this.mainScreen.setDialogScreen(null)));
    }

    @Override
    public int indexInList() {
        return this.ctx.currentIndex(this);
    }

    @Override
    public int imageId() {
        DynamicTexture texture = this.texture();
        return texture != null ? texture.m_117963_() : 0;
    }

    @Override
    @Nullable
    public NativeImage image() {
        if (this.image == null) {
            this.image = this.getImage(this.screenshotFile);
        }
        return this.image.getNow(null);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_93622_ && keyCode == 67 && (modifiers & 2) != 0) {
            this.copyScreenshot();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @NotNull
    public Component m_6035_() {
        return this.screenshotFile == null ? super.m_6035_() : Component.m_237113_((String)this.screenshotFile.getName());
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_198029_()) {
            super.m_7435_(this.client.m_91106_());
            if (button == 0) {
                this.onClick();
            }
            if (button == 1) {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return false;
    }

    public boolean m_198029_() {
        return this.f_93622_;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.m_198029_();
    }

    protected void m_168797_(@NotNull NarrationElementOutput p_259858_) {
    }

    @Override
    public void close() {
        if (this.texture != null) {
            this.texture.close();
        } else if (this.image != null) {
            this.image.thenAcceptAsync(image -> {
                if (image != null) {
                    image.close();
                }
            }, (Executor)this.client);
        }
        this.image = null;
        this.texture = null;
    }

    static interface Context {
        public int screenshotsPerRow();

        public int currentIndex(ScreenshotWidget var1);

        public void removeEntry(ScreenshotWidget var1);
    }
}

