/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageList;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotPropertiesMenu;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnlargedScreenshotScreen
extends Screen {
    @Nullable
    private ScreenshotImageHolder showing;
    @Nullable
    private ScreenshotImageList imageList;
    private final PropertiesDisplay properties;
    private final AbstractWidget doneBtn;
    private final AbstractWidget nextBtn;
    private final AbstractWidget prevBtn;
    private final AbstractWidget openBtn;
    private final AbstractWidget copyBtn;
    private final AbstractWidget deleteBtn;
    private final AbstractWidget renameBtn;

    EnlargedScreenshotScreen(PropertiesDisplay properties) {
        super((Component)Component.m_237119_());
        this.properties = properties;
        this.doneBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 52, 20, CommonComponents.f_130655_, btn -> this.m_7379_());
        this.prevBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 20, 20, (Component)Component.m_237113_((String)"<"), btn -> this.previousScreenshot());
        this.nextBtn = new ManageScreenshotsScreen.ExtendedButtonWidget(0, 0, 20, 20, (Component)Component.m_237113_((String)">"), btn -> this.nextScreenshot());
        this.openBtn = this.makeIconWidget(ScreenshotPropertiesMenu.OPEN_ICON, ScreenshotViewerTexts.OPEN_FILE, ScreenshotImageHolder::openFile);
        this.copyBtn = this.makeIconWidget(ScreenshotPropertiesMenu.COPY_ICON, ScreenshotViewerTexts.COPY, ScreenshotImageHolder::copyScreenshot);
        this.deleteBtn = this.makeIconWidget(ScreenshotPropertiesMenu.DELETE_ICON, ScreenshotViewerTexts.DELETE, ScreenshotImageHolder::requestFileDeletion);
        this.renameBtn = this.makeIconWidget(ScreenshotPropertiesMenu.RENAME_ICON, ScreenshotViewerTexts.RENAME_FILE, ScreenshotImageHolder::renameFile);
    }

    private AbstractWidget makeIconWidget(ResourceLocation texture, Component description, Consumer<ScreenshotImageHolder> action) {
        return new ManageScreenshotsScreen.ExtendedTexturedButtonWidget(0, 0, 20, 20, texture, btn -> {
            if (this.showing != null) {
                action.accept(this.showing);
            }
        }, description, description);
    }

    void show(ScreenshotImageHolder showing, ScreenshotImageList imageList) {
        this.showing = showing;
        this.imageList = imageList;
        this.updateButtonsState();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        int spacing = 4;
        this.addPositioned(this.doneBtn, (this.f_96543_ - 52) / 2, this.f_96544_ - 20 - spacing * 2);
        this.addPositioned(this.prevBtn, spacing * 2, (this.f_96544_ - 20) / 2);
        int rightButtonsX = this.f_96543_ - spacing * 2 - 20;
        this.addPositioned(this.nextBtn, this.f_96543_ - spacing * 2 - 20, (this.f_96544_ - 20) / 2);
        this.addPositioned(this.openBtn, rightButtonsX, this.f_96544_ - 100 - spacing * 6);
        this.addPositioned(this.copyBtn, rightButtonsX, this.f_96544_ - 80 - spacing * 5);
        this.addPositioned(this.deleteBtn, rightButtonsX, this.f_96544_ - 60 - spacing * 4);
        this.addPositioned(this.renameBtn, rightButtonsX, this.f_96544_ - 40 - spacing * 3);
    }

    private void addPositioned(AbstractWidget button, int x, int y) {
        button.m_252865_(x);
        button.m_253211_(y);
        this.m_142416_((GuiEventListener)button);
    }

    private void nextScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() + 1) < this.imageList.size()) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void previousScreenshot() {
        int i;
        if (this.hasInfo() && (i = this.showing.indexInList() - 1) >= 0) {
            this.showing = this.imageList.getScreenshot(i);
            this.updateButtonsState();
        }
    }

    private void updateButtonsState() {
        if (this.hasInfo()) {
            int i = this.showing.indexInList();
            this.prevBtn.f_93623_ = i > 0;
            this.nextBtn.f_93623_ = i < this.imageList.size() - 1;
        }
    }

    private boolean hasInfo() {
        return this.showing != null && this.imageList != null;
    }

    boolean renders() {
        return this.hasInfo();
    }

    public void m_280273_(GuiGraphics graphics) {
        graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float partialTicks, boolean updateHoverState) {
        this.m_6702_().forEach(element -> {
            if (element instanceof Renderable) {
                Renderable drawable = (Renderable)element;
                drawable.m_88315_(context, mouseX, mouseY, partialTicks);
            }
            if (element instanceof ManageScreenshotsScreen.CustomHoverState) {
                ManageScreenshotsScreen.CustomHoverState state = (ManageScreenshotsScreen.CustomHoverState)element;
                int mul = updateHoverState ? 1 : -1;
                state.updateHoveredState(mouseX * mul, mouseY * mul);
            }
        });
    }

    public void renderImage(GuiGraphics context) {
        if (this.showing != null) {
            int spacing = 8;
            NativeImage image = this.showing.image();
            if (image != null) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (int)this.showing.imageId());
                RenderSystem.enableBlend();
                float imgRatio = (float)image.m_84982_() / (float)image.m_85084_();
                int texHeight = this.f_96544_ - 24 - 20;
                int texWidth = (int)((float)texHeight * imgRatio);
                ScreenshotViewerUtils.drawTexture(context, (this.f_96543_ - texWidth) / 2, 8, texWidth, texHeight, 0, 0, image.m_84982_(), image.m_85084_(), image.m_84982_(), image.m_85084_());
                RenderSystem.disableBlend();
            }
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.nextScreenshot();
        }
        if (amount < 0.0) {
            this.previousScreenshot();
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousScreenshot();
            return true;
        }
        if (keyCode == 262) {
            this.nextScreenshot();
            return true;
        }
        if (this.showing != null && keyCode == 67 && (modifiers & 2) != 0) {
            this.showing.copyScreenshot();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.showing != null && button == 1) {
            this.properties.showProperties(mouseX, mouseY, this.showing);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        this.showing = null;
        this.imageList = null;
    }

    @FunctionalInterface
    static interface PropertiesDisplay {
        public void showProperties(double var1, double var3, ScreenshotImageHolder var5);
    }
}

