/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.mixin;

import io.github.mortuusars.scholar.book.BookColor;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.crafting.BookCloningRecipe;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookCloningRecipe.class})
public class BookCloningRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/inventory/CraftingContainer;Lnet/minecraft/core/RegistryAccess;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingContainer container, RegistryAccess registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack inputBook = ItemStack.f_41583_;
        Integer resultColor = null;
        int copies = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42615_)) {
                if (!inputBook.m_41619_()) {
                    cir.setReturnValue((Object)ItemStack.f_41583_);
                    return;
                }
                inputBook = stack;
                continue;
            }
            if (stack.m_150930_(Items.f_42614_)) {
                int color = BookColor.of(stack);
                if (resultColor == null) {
                    resultColor = color;
                } else if (resultColor != color) {
                    cir.setReturnValue((Object)ItemStack.f_41583_);
                    return;
                }
                ++copies;
                continue;
            }
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        if (inputBook.m_41619_() || inputBook.m_41783_() == null || copies < 1 || WrittenBookItem.m_43473_((ItemStack)inputBook) >= 2) {
            cir.setReturnValue((Object)ItemStack.f_41583_);
            return;
        }
        ItemStack resultStack = new ItemStack((ItemLike)Items.f_42615_, copies);
        CompoundTag inputBookTag = inputBook.m_41783_().m_6426_();
        inputBookTag.m_128405_("generation", WrittenBookItem.m_43473_((ItemStack)inputBook) + 1);
        resultStack.m_41751_(inputBookTag);
        BookColor.set(resultStack, resultColor);
        cir.setReturnValue((Object)resultStack);
    }
}

