/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.integration.woodworks;

import com.teamabnormals.blueprint.common.block.BlueprintChiseledBookShelfBlock;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.render.ChiseledBookShelf;
import io.github.mortuusars.scholar.integration.woodworks.forge.WoodworksIntegrationImpl;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class WoodworksIntegration {
    public static void registerBlockColors(BiConsumer<BlockColor, Block> consumer) {
        Scholar.LOGGER.info("Registering chiseled bookshelf block colors to 'Woodworks'. If Woodworks bookshelves displaying wrongly - try without Scholar installed, and if incompatibility is confirmed - report to Scholar github.");
        WoodworksIntegration.getChiseledBookshelves().forEach(block -> consumer.accept(ChiseledBookShelf::getSlotTintColor, (Block)block));
    }

    public static void setRenderLayer(BiConsumer<Block, RenderType> consumer) {
        Scholar.LOGGER.info("Setting 'cutout' render type for 'Woodworks'. If Woodworks bookshelves displaying wrongly - try without Scholar installed, and if incompatibility is confirmed - report to Scholar github.");
        WoodworksIntegration.getChiseledBookshelves().forEach(block -> consumer.accept((Block)block, RenderType.m_110463_()));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<Block> getChiseledBookshelves() {
        return WoodworksIntegrationImpl.getChiseledBookshelves();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static OptionalInt getDefaultTintColor(BlockState state, int slot) {
        void var1_1;
        return WoodworksIntegrationImpl.getDefaultTintColor(state, (int)var1_1);
    }

    public static OptionalInt getHitSlot(BlockState state, Vec2 hitPos) {
        Block block = state.m_60734_();
        if (block instanceof BlueprintChiseledBookShelfBlock) {
            BlueprintChiseledBookShelfBlock block2 = (BlueprintChiseledBookShelfBlock)block;
            return OptionalInt.of(block2.m_261279_(hitPos));
        }
        return OptionalInt.empty();
    }
}

