/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.renderers.entities.layers;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.events.CameraShakeEvents;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.models.entities.WiltedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WiltedActivatedLayer
extends RenderLayer<Wilted, WiltedModel<Wilted>> {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("rootoffear", "textures/entity/wilted_activated_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("rootoffear", "textures/entity/wilted_activated_1.png");
    private static final int pulseTime = 5;

    public WiltedActivatedLayer(RenderLayerParent<Wilted, WiltedModel<Wilted>> p_117707_) {
        super(p_117707_);
    }

    public void render(PoseStack p_117720_, MultiBufferSource p_117721_, int p_117722_, Wilted entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
        if (!entity.m_6060_()) {
            float glow = 0.5f + Mth.m_14031_((float)(p_117727_ * 0.1f)) / 2.0f;
            int pulseGlow = Mth.m_14143_((float)(glow * 100.0f));
            float lightMultiplier = Math.max((7.5f - (float)entity.m_9236_().m_45517_(LightLayer.BLOCK, entity.m_20183_())) / 7.5f, 0.0f);
            if (lightMultiplier > 0.0f && entity.pulseCooldown <= 0 && entity.lastPulseGlow < pulseGlow && 5 <= pulseGlow && 5 >= entity.lastPulseGlow) {
                CameraShakeEvents.addCameraShake(entity.m_9236_(), 30, 0.03f, entity.m_20183_(), 80);
                entity.m_9236_().m_7785_(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20188_(), Minecraft.m_91087_().f_91074_.m_20189_(), (SoundEvent)SoundEventInit.WILTED_PULSE.get(), entity.m_5720_(), Mth.m_14179_((float)(1.0f - Mth.m_14036_((float)(Minecraft.m_91087_().f_91074_.m_20270_((Entity)entity) / 80.0f), (float)0.0f, (float)1.0f)), (float)0.0f, (float)0.75f), entity.m_6100_() * lightMultiplier, false);
                entity.pulseCooldown = 20;
            }
            entity.lastPulseGlow = pulseGlow;
            if (!entity.isDisguised()) {
                VertexConsumer vertexconsumer = p_117721_.m_6299_(RenderType.m_234338_((ResourceLocation)TEXTURE_0));
                ((WiltedModel)this.m_117386_()).m_7695_(p_117720_, vertexconsumer, p_117722_, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, glow * lightMultiplier);
                VertexConsumer vertexconsumer1 = p_117721_.m_6299_(RenderType.m_234338_((ResourceLocation)TEXTURE_1));
                float glow1 = 0.5f + Mth.m_14031_((float)((p_117727_ - 5.0f) * 0.1f)) / 2.0f;
                ((WiltedModel)this.m_117386_()).m_7695_(p_117720_, vertexconsumer1, p_117722_, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, glow1 * lightMultiplier);
            }
        }
    }
}

