/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.events;

import com.alexander.rootoffear.capabilities.RoFLevelCapability;
import com.alexander.rootoffear.capabilities.RoFLevelCapabilityProvider;
import com.alexander.rootoffear.config.RoFCommonConfig;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rootoffear")
public class RandomlyPlayWiltedSoundsEvent {
    @SubscribeEvent
    public static void playSounds(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            ServerLevel level = (ServerLevel)event.level;
            level.getCapability(RoFLevelCapabilityProvider.CAP).ifPresent(capability -> {
                ServerPlayer player;
                boolean flag;
                boolean bl = flag = capability.getWiltedID() != null && MiscUtils.isEntityValid(level.m_8791_(capability.getWiltedID()));
                if (!capability.wasNight() && level.m_46462_() && !flag) {
                    RandomlyPlayWiltedSoundsEvent.setNextUseTime(level, capability);
                }
                if ((level.m_46468_() / 24000L >= capability.getNextSpawnDay() - 3L && ((Boolean)RoFCommonConfig.wilted_warning_sounds.get()).booleanValue() || flag) && level.m_46467_() >= capability.getNextSoundTime() && level.m_46462_() && MiscUtils.isEntityValid((LivingEntity)(player = level.m_8890_())) && (MiscUtils.isEntityInValidWiltedSpawnBiome((Entity)player) || flag)) {
                    level.m_6263_(null, player.m_20185_() + level.f_46441_.m_188583_() * 20.0, player.m_20186_(), player.m_20189_() + level.f_46441_.m_188583_() * 20.0, (SoundEvent)SoundEventInit.WILTED_IDLE.get(), SoundSource.HOSTILE, 3.0f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f) / (1.0f + level.f_46441_.m_188501_() / 2.0f));
                    if (flag) {
                        capability.setNextSoundTime(level.m_46467_() + (long)MiscUtils.randomIntBetween(100, 300));
                    } else {
                        RandomlyPlayWiltedSoundsEvent.setNextUseTime(level, capability);
                    }
                }
                capability.setWasNight(level.m_46462_());
            });
        }
    }

    public static void setNextUseTime(ServerLevel level, RoFLevelCapability capability) {
        capability.setNextSoundTime(level.m_46467_() + (long)MiscUtils.randomIntBetween(600, (int)Math.max(2400L, (level.m_8044_() / 24000L - capability.getNextSpawnDay()) * 9600L)));
    }
}

