/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import com.alexander.rootoffear.entities.AbstractHurtableEntity;
import com.alexander.rootoffear.entities.ShadowWilted;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class WiltedBarrier
extends AbstractHurtableEntity {
    public AnimationState emergeAnimationState = new AnimationState();

    public WiltedBarrier(EntityType<? extends WiltedBarrier> type, Level level) {
        super(type, level);
        this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
    }

    public WiltedBarrier(Level level, Vec3 pos) {
        this((EntityType<? extends WiltedBarrier>)((EntityType)EntityTypeInit.WILTED_BARRIER.get()), level);
        this.m_6027_((double)Mth.m_14107_((double)pos.f_82479_) + 0.5, Mth.m_14107_((double)pos.f_82480_), (double)Mth.m_14107_((double)pos.f_82481_) + 0.5);
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 5) {
            for (int i = 0; i < 200; ++i) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(0.85), this.m_20187_(), this.m_20262_(0.85), 0.0, 0.0, 0.0);
            }
        } else if (event == 7) {
            this.emergeAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(event);
        }
    }

    @Override
    public SoundEvent hurtSound() {
        return (SoundEvent)SoundEventInit.WILTED_SWAY.get();
    }

    public Vec3 m_7371_(float p_20309_) {
        double d0 = Mth.m_14139_((double)p_20309_, (double)this.f_19854_, (double)this.m_20185_());
        double d1 = Mth.m_14139_((double)p_20309_, (double)this.f_19855_, (double)this.m_20186_()) + 0.1;
        double d2 = Mth.m_14139_((double)p_20309_, (double)this.f_19856_, (double)this.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateHurtable();
        this.m_6027_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, Mth.m_14107_((double)this.m_20186_()), (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
    }

    @Override
    public void onKilled() {
        this.m_5496_((SoundEvent)SoundEventInit.WILTED_STEP.get(), this.getSoundVolume(), this.getVoicePitch() * 1.5f);
        this.m_5496_((SoundEvent)SoundEventInit.WILTED_SWAY.get(), this.getSoundVolume(), this.getVoicePitch() / 4.0f);
        super.onKilled();
    }

    public boolean m_5829_() {
        return !this.m_213877_() && !this.killed && this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(1.0E-7), entity -> entity instanceof Wilted || entity instanceof ShadowWilted).size() <= 0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public int maxHits() {
        return 5;
    }

    @Override
    public int hurtCooldown() {
        return 10;
    }

    @Override
    public int maxLifeTime() {
        return 600;
    }

    @Override
    public AnimationState hurtAnimationState() {
        return null;
    }

    protected void m_8097_() {
    }
}

