/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import com.alexander.rootoffear.ai.controllers.wilted.WiltedBodyRotationControl;
import com.alexander.rootoffear.ai.controllers.wilted.WiltedLookControl;
import com.alexander.rootoffear.ai.controllers.wilted.WiltedMoveControl;
import com.alexander.rootoffear.ai.controllers.wilted.WiltedNavigation;
import com.alexander.rootoffear.ai.goals.AdvancedNearestAttackableTargetGoal;
import com.alexander.rootoffear.ai.goals.LookAtTargetGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedApproachTargetGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedApproachUltimateTargetGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedAvoidLightGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedBecomeSilentGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedBreakBlocksGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedCreateBarriersGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedCreateDecoyGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedCreateShadowsGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedExtinguishLightsGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedFreezeWhenLookedAtGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedGrabAttackGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedGroundGrabGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedLeafStormGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedLeapToMoveTargetGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedLightExtinguisherPullGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedRevealGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedTeleportGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedTeleportToMoveTargetGoal;
import com.alexander.rootoffear.capabilities.RoFLevelCapabilityProvider;
import com.alexander.rootoffear.config.RoFCommonConfig;
import com.alexander.rootoffear.events.CameraShakeEvents;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.particles.AdvancedParticleOption;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public class Wilted
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_NATURALLY_SPAWNED_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DISGUISED_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PHASING_THROUGH_WALL_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SILENT_TIMER = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final TargetingConditions TARGETING = TargetingConditions.m_148352_().m_148355_().m_26893_();
    public UUID ultimateTargetID;
    public AnimationState hurtAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState revealAnimationState = new AnimationState();
    public AnimationState teleportAnimationState = new AnimationState();
    public AnimationState breakBlocksAnimationState = new AnimationState();
    public AnimationState leapAnimationState = new AnimationState();
    public AnimationState landAnimationState = new AnimationState();
    public AnimationState groundGrabAnimationState = new AnimationState();
    public AnimationState spearAnimationState = new AnimationState();
    public AnimationState twitchingAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public static final Color revealedLeafColour = new Color(12897215);
    public int leafColour = 0;
    public boolean wantsToReveal = false;
    public int wantsToRevealCooldown;
    public boolean willDisguiseOnNextTeleport = false;
    public final EntityDimensions disguisedDimensions = EntityDimensions.m_20395_((float)1.0f, (float)4.0f);
    public BlockPos teleportTargetPos = null;
    public boolean disableRendering = false;
    public double targetMovementSpeed = 0.2;
    public double wallPhasingMovementSpeed = 0.2;
    public int notPhasingThroughWallFor;
    public int bottomInGroundTime;
    public int aggroCooldown;
    public boolean wantsToGoDownwards = false;
    public int phasingThroughWallTick;
    public float walkAnimPosO;
    public int wallUnstuckCooldown;
    public List<Goal> allBonusBehaviours;
    public List<Goal> chosenBonusBehaviours;
    public int lastPulseGlow;
    public int pulseCooldown;
    public boolean stillShowingLeaves = false;
    public int skyDarkenO;
    public int rerollBonusBehavioursCooldown;

    public Wilted(EntityType<? extends Wilted> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.FENCE, 0.0f);
        this.f_21342_ = new WiltedMoveControl((Mob)this);
        this.f_21365_ = new WiltedLookControl(this);
    }

    protected void m_8099_() {
        this.chosenBonusBehaviours = Lists.newArrayList();
        this.allBonusBehaviours = Lists.newArrayList((Object[])new Goal[]{new WiltedCreateDecoyGoal(this), new WiltedTeleportToMoveTargetGoal(this), new WiltedLeapToMoveTargetGoal(this), new WiltedBreakBlocksGoal(this), new WiltedGroundGrabGoal(this), new WiltedLeafStormGoal(this), new WiltedCreateShadowsGoal(this), new WiltedBecomeSilentGoal(this), new WiltedLightExtinguisherPullGoal(this), new WiltedCreateBarriersGoal(this)});
        this.randomiseBonusBehaviours();
        int p = 0;
        this.f_21345_.m_25352_(p++, (Goal)new WiltedRevealGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedTeleportGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedFreezeWhenLookedAtGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedGrabAttackGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedAvoidLightGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedExtinguishLightsGoal(this));
        for (Goal goal : this.allBonusBehaviours) {
            this.f_21345_.m_25352_(p++, goal);
        }
        this.f_21345_.m_25352_(p++, (Goal)new WiltedApproachUltimateTargetGoal(this));
        this.f_21345_.m_25352_(p++, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedApproachTargetGoal((Mob)this));
        this.f_21345_.m_25352_(p++, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(p++, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(p++, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, new AdvancedNearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, false, true, true, null));
    }

    public void randomiseBonusBehaviours() {
        ArrayList bonusBehaviours = Lists.newArrayList();
        bonusBehaviours.addAll(this.allBonusBehaviours);
        this.chosenBonusBehaviours.clear();
        for (int i = 0; i < (Integer)RoFCommonConfig.wilted_bonus_behaviour_amount.get(); ++i) {
            if (bonusBehaviours.isEmpty()) continue;
            Collections.shuffle(bonusBehaviours);
            Goal goal = (Goal)bonusBehaviours.get(0);
            this.chosenBonusBehaviours.add(goal);
            bonusBehaviours.remove(goal);
        }
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    public boolean m_20067_() {
        return super.m_20067_() || this.getSilentTimer() > 0;
    }

    protected SoundEvent m_7515_() {
        return this.isDisguised() ? null : (SoundEvent)SoundEventInit.WILTED_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundEventInit.WILTED_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventInit.WILTED_DEATH.get();
    }

    public float m_6121_() {
        return 3.0f;
    }

    public float m_6100_() {
        return this.m_21224_() ? 1.0f : super.m_6100_();
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
    }

    public static BlockPos findSpawnablePosition(BlockPos origin, ServerLevel level, int minDistance, int maxDistance, int minDistanceFromAnyPlayer, int tries, boolean surface) {
        BlockPos blockpos = null;
        for (int i = 0; i < tries; ++i) {
            int j = origin.m_123341_() + level.f_46441_.m_188503_(maxDistance * 2) - maxDistance;
            int k = origin.m_123343_() + level.f_46441_.m_188503_(maxDistance * 2) - maxDistance;
            int l = surface ? level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, j, k) : origin.m_123342_();
            BlockPos blockpos1 = new BlockPos(j, l, k);
            if (!surface) {
                blockpos1 = PositionUtils.moveToGroundHeight((Level)level, blockpos1, 15);
            }
            if (blockpos1 == null) continue;
            boolean somebodyLookingHere = false;
            for (Player player2 : level.m_6907_()) {
                if (!MiscUtils.inSurvivalMode((LivingEntity)player2) || !Wilted.isLookingAt(player2, blockpos1) && !(PositionUtils.distanceTo(player2.m_20183_(), blockpos1) < (float)minDistanceFromAnyPlayer)) continue;
                somebodyLookingHere = true;
                break;
            }
            if (!(PositionUtils.distanceTo(origin, blockpos1) >= (float)minDistance) || level.m_45517_(LightLayer.BLOCK, blockpos1) > 1 || somebodyLookingHere || !Wilted.isPosSpawnableForWilted(level, blockpos1) || (!surface || !level.m_45527_(blockpos1.m_7494_())) && surface) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    public static boolean checkWiltedSpawnRules(EntityType<? extends Wilted> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_60643_((BlockGetter)level, pos.m_7495_(), entity) && level.m_6425_(pos).m_76178_() && Wilted.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isPosSpawnableForWilted(ServerLevel level, BlockPos pos) {
        if (level.m_45772_(MiscUtils.getSpawnAABB((EntityType)EntityTypeInit.WILTED.get(), (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5))) {
            BlockPos blockpos = BlockPos.m_274561_((double)((double)pos.m_123341_() + 0.5), (double)pos.m_123342_(), (double)((double)pos.m_123343_() + 0.5));
            return SpawnPlacements.m_217074_((EntityType)((EntityType)EntityTypeInit.WILTED.get()), (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)level.m_213780_());
        }
        return false;
    }

    public EntityDimensions m_6972_(Pose p_21047_) {
        return this.isDisguised() ? this.disguisedDimensions : super.m_6972_(p_21047_);
    }

    public void m_7350_(EntityDataAccessor<?> p_33609_) {
        if (DATA_DISGUISED_ID.equals(p_33609_)) {
            this.m_6210_();
        }
        super.m_7350_(p_33609_);
    }

    public boolean isLookingAtMe(Player player) {
        return Wilted.isLookingAt(player, this.m_20185_(), this.m_20188_(), this.m_20189_());
    }

    public static boolean isLookingAt(Player player, BlockPos pos) {
        return Wilted.isLookingAt(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static boolean isLookingAt(Player player, double x, double y, double z) {
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(x - player.m_20185_(), y - player.m_20188_(), z - player.m_20189_());
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 0.5;
    }

    public void m_6043_() {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DISGUISED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_NATURALLY_SPAWNED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_PHASING_THROUGH_WALL_ID, (Object)false);
        this.f_19804_.m_135372_(SILENT_TIMER, (Object)0);
    }

    public void setDisguised(boolean value) {
        this.f_19804_.m_135381_(DATA_DISGUISED_ID, (Object)value);
    }

    public boolean isDisguised() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DISGUISED_ID);
    }

    public void setNaturallySpawned(boolean value) {
        this.f_19804_.m_135381_(DATA_NATURALLY_SPAWNED_ID, (Object)value);
    }

    public boolean isNaturallySpawned() {
        return (Boolean)this.f_19804_.m_135370_(DATA_NATURALLY_SPAWNED_ID);
    }

    public void setWasPhasingThroughWall(boolean value) {
        this.f_19804_.m_135381_(DATA_PHASING_THROUGH_WALL_ID, (Object)value);
    }

    public boolean wasPhasingThroughWall() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PHASING_THROUGH_WALL_ID);
    }

    public void setSilentTimer(int value) {
        this.f_19804_.m_135381_(SILENT_TIMER, (Object)value);
    }

    public int getSilentTimer() {
        return (Integer)this.f_19804_.m_135370_(SILENT_TIMER);
    }

    public LivingEntity getUltimateTarget() {
        LivingEntity living;
        Entity target = this.ultimateTargetID == null || this.m_9236_().m_5776_() ? null : ((ServerLevel)this.m_9236_()).m_8791_(this.ultimateTargetID);
        return target instanceof LivingEntity ? (living = (LivingEntity)target) : null;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.ultimateTargetID != null) {
            tag.m_128362_("UltimateTargetID", this.ultimateTargetID);
        }
        tag.m_128379_("Disguised", this.isDisguised());
        tag.m_128379_("NaturallySpawned", this.isNaturallySpawned());
        tag.m_128405_("LeafColour", this.leafColour);
        tag.m_128405_("RerollBonusBehavioursCooldown", this.rerollBonusBehavioursCooldown);
        if (!this.m_9236_().m_5776_()) {
            int i = 0;
            for (Goal goal : this.chosenBonusBehaviours) {
                tag.m_128405_("BonusBehaviour" + i, this.allBonusBehaviours.indexOf(goal));
                ++i;
            }
        }
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        if (tag.m_128403_("UltimateTargetID")) {
            uuid = tag.m_128342_("UltimateTargetID");
        } else {
            String s = tag.m_128461_("UltimateTargetID");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.ultimateTargetID = uuid;
            }
            catch (Throwable throwable) {
                this.ultimateTargetID = null;
            }
        }
        this.setDisguised(tag.m_128471_("Disguised"));
        this.setNaturallySpawned(tag.m_128471_("NaturallySpawned"));
        this.leafColour = tag.m_128451_("LeafColour");
        this.rerollBonusBehavioursCooldown = tag.m_128451_("RerollBonusBehavioursCooldown");
        if (this.m_9236_() instanceof ServerLevel) {
            int i = 0;
            while (tag.m_128441_("BonusBehaviour" + i)) {
                if (i == 0) {
                    this.chosenBonusBehaviours.clear();
                }
                this.chosenBonusBehaviours.add(this.allBonusBehaviours.get(tag.m_128451_("BonusBehaviour" + i)));
                ++i;
            }
        }
    }

    public int maxBrightness() {
        ArrayList brightnesses = Lists.newArrayList();
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            brightnesses.add(this.m_9236_().m_45517_(LightLayer.BLOCK, pos));
        }
        brightnesses.sort(Collections.reverseOrder());
        return (Integer)brightnesses.get(0);
    }

    public boolean canPhaseThroughWalls() {
        return this.m_9236_().m_46749_(this.m_20183_()) && !this.m_9236_().m_46461_() && this.maxBrightness() < 3;
    }

    public boolean isPhasingThroughWall() {
        AABB aabb = this.wasPhasingThroughWall() ? this.m_20191_().m_82377_(0.05, 0.0, 0.05) : this.m_20191_().m_165887_(this.m_20188_()).m_82377_(0.05, 0.0, 0.05);
        return this.canPhaseThroughWalls() && BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean isStuckInWall() {
        AABB aabb = this.m_20191_().m_82377_(-0.05, -0.05, -0.05);
        return !this.canPhaseThroughWalls() && BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean bottomIsInGround() {
        AABB aabb = this.m_20191_().m_165893_(this.m_20186_() + 1.1).m_82377_(0.05, 0.0, 0.05);
        return this.canPhaseThroughWalls() && BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean isNearWall() {
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.0, 0.5).m_165887_(this.m_20186_() + 1.1);
        return this.canPhaseThroughWalls() && BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    protected PathNavigation m_6037_(Level level) {
        return new WiltedNavigation((Mob)this, level);
    }

    protected BodyRotationControl m_7560_() {
        return new WiltedBodyRotationControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 2.0);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 2.0f;
    }

    public void m_6075_() {
        block48: {
            Level wolf2;
            block49: {
                block50: {
                    block47: {
                        super.m_6075_();
                        if (!this.m_9236_().m_5776_() && this.rerollBonusBehavioursCooldown <= 0 && this.m_9236_().m_7445_() < this.skyDarkenO) {
                            this.randomiseBonusBehaviours();
                            this.rerollBonusBehavioursCooldown = 6000;
                        }
                        this.skyDarkenO = this.m_9236_().m_7445_();
                        if (this.rerollBonusBehavioursCooldown > 0) {
                            --this.rerollBonusBehavioursCooldown;
                        }
                        if (!this.m_9236_().m_5776_()) {
                            if (this.getSilentTimer() > 0) {
                                this.setSilentTimer(this.getSilentTimer() - 1);
                            }
                            this.setWasPhasingThroughWall(this.isPhasingThroughWall());
                        }
                        this.wantsToGoDownwards = false;
                        if (!this.m_9236_().m_5776_()) break block47;
                        this.idleAnimationState.m_216982_(this.f_19797_);
                        this.twitchingAnimationState.m_246184_(!this.isDisguised(), this.f_19797_);
                        this.deathAnimationState.m_246184_(this.m_21224_(), this.f_19797_);
                        if (!this.isDisguised() && this.pulseCooldown > 0 && this.f_19796_.m_188499_()) {
                            this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_GLOW.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                        }
                        if (this.f_19796_.m_188503_(this.isDisguised() ? 30 : 60) == 0) {
                            this.createLeafParticle();
                        }
                        if (this.leafColour == 0) {
                            this.leafColour = ((Biome)((ClientLevel)this.m_9236_()).m_204166_(this.m_20183_()).get()).m_47542_();
                        }
                        if (this.wasPhasingThroughWall() || this.teleportAnimationState.m_216984_() && !this.m_217003_(Pose.STANDING)) {
                            CameraShakeEvents.addCameraShake(this.m_9236_(), 3, 0.1f, this.m_20183_(), 10);
                            if (this.phasingThroughWallTick % 20 == 0) {
                                AABB aabb = this.m_20191_().m_82400_(1.0);
                                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                                    if (!((double)PositionUtils.distanceTo(this.m_20183_().m_6630_(2), blockpos) <= aabb.m_82362_()) || !PositionUtils.isBlockCollidable(this.m_9236_(), blockpos)) continue;
                                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypeInit.WILTED_WALL.get(), (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 0.0, 0.0, 0.0);
                                }
                            }
                            ++this.phasingThroughWallTick;
                        } else {
                            this.phasingThroughWallTick = 0;
                        }
                        break block48;
                    }
                    if (this.wantsToRevealCooldown-- <= 0 && MiscUtils.isEntityValid(this.m_5448_())) {
                        this.wantsToReveal = true;
                    }
                    if (this.f_19797_ % 30 == 0) {
                        for (Cat cat : this.m_9236_().m_6443_(Cat.class, this.m_20191_().m_82400_(50.0), EntitySelector.f_20402_)) {
                            if (this.f_19796_.m_188503_(5) != 0) continue;
                            cat.m_28167_();
                        }
                        for (Level wolf2 : this.m_9236_().m_6443_(Wolf.class, this.m_20191_().m_82400_(50.0), EntitySelector.f_20402_)) {
                            if (this.f_19796_.m_188503_(5) != 0) continue;
                            wolf2.m_5496_(SoundEvents.f_12620_, 0.4f, wolf2.m_6100_());
                        }
                    }
                    if (!this.m_21573_().m_26572_()) break block49;
                    if (this.isPhasingThroughWall() || this.m_20072_() && (double)this.m_21573_().m_26570_().m_77406_().m_123342_() > this.m_20186_() && PositionUtils.distanceTo((Entity)this, new BlockPos(this.m_21573_().m_26570_().m_77406_().m_123341_(), (int)this.m_20186_(), this.m_21573_().m_26570_().m_77406_().m_123343_())) <= 4.0f) break block50;
                    if (!this.m_20096_() || !((double)this.m_21573_().m_26570_().m_77406_().m_123342_() < this.m_20186_() - 0.1)) break block49;
                    BlockPos blockPos = new BlockPos(this.m_21573_().m_26570_().m_77406_().m_123341_(), (int)this.m_20186_(), this.m_21573_().m_26570_().m_77406_().m_123343_());
                    if (!(PositionUtils.distanceTo((Entity)this, blockPos) <= 6.0f) || PositionUtils.hasLineOfSight((Entity)this, this.m_21573_().m_26570_().m_77406_())) break block49;
                }
                boolean bl = this.wantsToGoDownwards = (double)this.m_21573_().m_26570_().m_77406_().m_123342_() < this.m_20186_() - 0.1;
                if (this.wantsToGoDownwards || (double)this.m_21573_().m_26570_().m_77406_().m_123342_() > this.m_20186_()) {
                    this.m_20256_(new Vec3(this.m_20184_().f_82479_ + this.m_217043_().m_188583_() * 0.01, this.wantsToGoDownwards ? -0.1 : 0.1, this.m_20184_().f_82481_ + this.m_217043_().m_188583_() * 0.01));
                    if (this.m_20072_()) {
                        this.m_20256_(this.m_20184_().m_82542_(0.0, 10.0, 0.0));
                    }
                }
            }
            if (!this.wantsToGoDownwards && this.bottomIsInGround()) {
                ++this.bottomInGroundTime;
                if (this.bottomInGroundTime > 5) {
                    this.m_20256_(new Vec3(this.m_20184_().f_82479_ + this.m_217043_().m_188583_() * 0.01, 0.1, this.m_20184_().f_82481_ + this.m_217043_().m_188583_() * 0.01));
                }
            } else {
                this.bottomInGroundTime = 0;
            }
            if ((wolf2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)wolf2;
                if (serverLevel.m_46461_() && !this.m_9236_().m_45527_(this.m_20183_())) {
                    boolean lookedAt = false;
                    for (Player player : serverLevel.m_6907_()) {
                        if (!this.isLookingAtMe(player) || !player.m_142582_((Entity)this) || !MiscUtils.isEntityValid((LivingEntity)player) || player.m_5833_()) continue;
                        lookedAt = true;
                        break;
                    }
                    if (!lookedAt) {
                        this.m_146870_();
                    }
                }
                if (this.isNaturallySpawned()) {
                    serverLevel.getCapability(RoFLevelCapabilityProvider.CAP).ifPresent(capability -> {
                        Wilted wilted;
                        Entity patt27044$temp;
                        if (capability.getWiltedID() != null && (patt27044$temp = serverLevel.m_8791_(capability.getWiltedID())) instanceof Wilted && (wilted = (Wilted)patt27044$temp) != this || capability.getWiltedID() == null) {
                            this.m_146870_();
                        }
                    });
                }
                if (this.wallUnstuckCooldown > 0) {
                    --this.wallUnstuckCooldown;
                }
                if (this.isStuckInWall() && this.wallUnstuckCooldown <= 0) {
                    Vec3 pos = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
                    int areaSize = 5;
                    ArrayList validPositions = Lists.newArrayList();
                    for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(pos.f_82479_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82480_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82481_ - (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82479_ + (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82480_ + (double)areaSize)), (int)Mth.m_14107_((double)(pos.f_82481_ + (double)areaSize)))) {
                        if (!PositionUtils.isBlockCollidable((Level)serverLevel, blockpos) || PositionUtils.isBlockCollidable((Level)serverLevel, blockpos.m_7494_()) || this.m_21573_().m_26572_() && !(PositionUtils.distanceTo(blockpos, this.m_21573_().m_26567_()) >= PositionUtils.distanceTo((Entity)this, this.m_21573_().m_26567_()))) continue;
                        validPositions.add(new BlockPos(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
                    }
                    if (validPositions.size() > 0) {
                        Collections.shuffle(validPositions);
                        validPositions.sort(PositionUtils.distanceComparator(this.m_20183_()));
                        this.m_146884_(Vec3.m_82512_((Vec3i)((Vec3i)validPositions.get(0))));
                    }
                    this.wallUnstuckCooldown = 20;
                }
            }
        }
        if (this.canPhaseThroughWalls()) {
            if (this.isNearWall() || this.isPhasingThroughWall()) {
                this.m_21441_(BlockPathTypes.BLOCKED, 8.0f);
            } else {
                this.m_21441_(BlockPathTypes.BLOCKED, BlockPathTypes.BLOCKED.m_77124_());
            }
            this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        } else {
            this.m_21441_(BlockPathTypes.BLOCKED, BlockPathTypes.BLOCKED.m_77124_());
            this.m_21441_(BlockPathTypes.LEAVES, BlockPathTypes.LEAVES.m_77124_());
        }
        if (this.revealAnimationState.m_216984_()) {
            Color currentColour = new Color(this.leafColour);
            float transitionSpeed = 0.1f;
            this.leafColour = new Color(Mth.m_14179_((float)transitionSpeed, (float)((float)currentColour.getRed() / 255.0f), (float)((float)revealedLeafColour.getRed() / 255.0f)), Mth.m_14179_((float)transitionSpeed, (float)((float)currentColour.getGreen() / 255.0f), (float)((float)revealedLeafColour.getGreen() / 255.0f)), Mth.m_14179_((float)transitionSpeed, (float)((float)currentColour.getBlue() / 255.0f), (float)((float)revealedLeafColour.getBlue() / 255.0f))).getRGB();
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46749_(this.m_20183_()) && !this.m_20072_()) {
            if (this.maxBrightness() > 1 || this.m_6060_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)15);
                if (!this.isBrightEnoughToBurn()) {
                    this.targetMovementSpeed = 0.25;
                }
            }
            if (this.isBrightEnoughToBurn()) {
                this.m_6469_(this.m_269291_().m_269549_(), this.m_9236_().m_46461_() ? 20.0f : 1.0f);
            }
        }
        if (this.isPhasingThroughWall()) {
            this.targetMovementSpeed = this.wallPhasingMovementSpeed = Math.min(this.wallPhasingMovementSpeed + 0.001, 0.5);
            this.notPhasingThroughWallFor = 0;
        } else {
            ++this.notPhasingThroughWallFor;
            if (this.notPhasingThroughWallFor >= 20) {
                this.wallPhasingMovementSpeed = 0.15;
            }
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(Mth.m_14139_((double)(this.isPhasingThroughWall() || this.maxBrightness() > 1 ? 1.0 : 0.05), (double)this.m_21051_(Attributes.f_22279_).m_22115_(), (double)this.targetMovementSpeed));
        this.targetMovementSpeed = 0.25;
        if (this.pulseCooldown > 0) {
            --this.pulseCooldown;
        }
        if (this.aggroCooldown > 0) {
            --this.aggroCooldown;
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        for (int i = 0; i < 30; ++i) {
            this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(1.0), this.m_20187_() + (double)this.m_217043_().m_188501_(), this.m_20262_(1.0), this.m_20185_(), 0.0, this.m_20189_());
        }
        if (this.f_20919_ >= 30 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        if (this.m_9236_().m_5776_()) {
            CameraShakeEvents.addCameraShake(this.m_9236_(), 80, 0.25f, this.m_20183_(), 20);
        }
    }

    public boolean m_6060_() {
        return super.m_6060_() || this.f_20916_ > 0 || this.m_21224_();
    }

    protected void m_6135_() {
        if (!this.isPhasingThroughWall()) {
            double d1;
            super.m_6135_();
            double d0 = this.f_21342_.m_24999_();
            if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
                this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
            }
        }
    }

    public boolean isBrightEnoughToBurn() {
        return this.maxBrightness() > 10 || this.m_9236_().m_46461_() && this.m_9236_().m_45527_(this.m_20183_());
    }

    public void createLeafParticle() {
        this.m_9236_().m_7107_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.WILTED_LEAF, List.of(Double.valueOf(this.isDisguised() ? this.leafColour : revealedLeafColour.getRGB()), Double.valueOf(this.m_20185_() + this.f_19796_.m_188583_()), Double.valueOf(this.m_20186_() + (double)(this.isDisguised() || this.stillShowingLeaves ? 4 : 2) + this.f_19796_.m_188583_()), Double.valueOf(this.m_20189_() + this.f_19796_.m_188583_()))), Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_(), Minecraft.m_91087_().f_91074_.m_20189_(), 0.0, 0.0, 0.0);
    }

    protected void m_267689_(float speed) {
        float f = Math.min(speed * 4.0f, 1.0f);
        this.f_267362_.m_267566_(f, this.isDisguised() ? 0.9f : 0.4f);
    }

    public void m_7822_(byte event) {
        if (event > 3 && event < 13) {
            this.startAnimation(event - 4);
        } else if (event == 19) {
            if (this.isDisguised() || this.stillShowingLeaves) {
                int i;
                for (i = 0; i < 5; ++i) {
                    this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), this.m_20185_(), 0.0, this.m_20189_());
                }
                for (i = 0; i < 5 + this.f_19796_.m_188503_(5); ++i) {
                    this.createLeafParticle();
                }
            } else {
                for (int i = 0; i < 20 + this.f_19796_.m_188503_(80); ++i) {
                    this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_GLOW.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
            if (!this.revealAnimationState.m_216984_()) {
                this.hurtAnimationState.m_216977_(this.f_19797_);
            }
        } else if (event == 18) {
            for (int i = 0; i < 250; ++i) {
                this.createLeafParticle();
            }
            this.stillShowingLeaves = false;
        } else if (event == 17) {
            this.disableRendering = true;
        } else if (event == 16) {
            this.disableRendering = false;
        } else if (event == 15) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        } else if (event == 13) {
            this.stillShowingLeaves = true;
            this.leafColour = 0;
            this.cancelAnimations();
        } else if (event == 60) {
            int i;
            for (i = 0; i < 500; ++i) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), this.m_20185_(), 1.0, this.m_20189_());
            }
            for (i = 0; i < 50; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(event);
        }
    }

    public void startAnimation(int animation) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)(4 + animation));
        } else {
            this.cancelAnimations();
            switch (animation) {
                case 0: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 1: {
                    this.stillShowingLeaves = true;
                    this.revealAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.teleportAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.breakBlocksAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.leapAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.landAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.groundGrabAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.spearAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
    }

    public void cancelAnimations() {
        this.attackAnimationState.m_216973_();
        this.revealAnimationState.m_216973_();
        this.teleportAnimationState.m_216973_();
        this.breakBlocksAnimationState.m_216973_();
        this.leapAnimationState.m_216973_();
        this.landAnimationState.m_216973_();
        this.groundGrabAnimationState.m_216973_();
        this.spearAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && source.m_7639_() != null) {
            LivingEntity living;
            Entity entity;
            if (!flag) {
                this.m_5496_((SoundEvent)SoundEventInit.WILTED_SWAY.get(), this.m_6121_(), this.m_6100_());
                this.m_9236_().m_7605_((Entity)this, (byte)19);
            }
            if ((entity = source.m_7639_()) instanceof LivingEntity && MiscUtils.inSurvivalMode(living = (LivingEntity)entity) && living != this.m_5448_() && TARGETING.m_26885_((LivingEntity)this, living) && (this.aggroCooldown <= 0 || !MiscUtils.inSurvivalMode(this.m_5448_()) || !(this.m_5448_() instanceof Player) && living instanceof Player)) {
                this.m_6710_(living);
                this.aggroCooldown = living instanceof Player ? 200 : 80;
            }
        }
        return flag;
    }

    public boolean m_6673_(DamageSource p_20122_) {
        return super.m_6673_(p_20122_) || (Boolean)RoFCommonConfig.wilted_immune_to_damage.get() != false && !p_20122_.m_269533_(DamageTypeTags.f_268745_) && !p_20122_.m_276093_(DamageTypes.f_268724_) && !p_20122_.m_276093_(DamageTypes.f_286973_) && !p_20122_.m_276093_(DamageTypes.f_286979_);
    }
}

