/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import com.alexander.rootoffear.ai.controllers.wilted.WiltedMoveControl;
import com.alexander.rootoffear.ai.controllers.wilted.WiltedNavigation;
import com.alexander.rootoffear.ai.goals.AdvancedNearestAttackableTargetGoal;
import com.alexander.rootoffear.ai.goals.LookAtTargetGoal;
import com.alexander.rootoffear.ai.goals.wilted.WiltedApproachTargetGoal;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class ShadowWilted
extends Monster {
    public int lifeTime;
    public UUID ownerID;
    public Vec2 facingAngle = Vec2.f_82462_;
    public Vec2 facingAngleO = Vec2.f_82462_;
    public AnimationState idleAnimationState = new AnimationState();

    public ShadowWilted(EntityType<? extends ShadowWilted> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CAUTIOUS, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.FENCE, 0.0f);
        this.f_21342_ = new WiltedMoveControl((Mob)this);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        int p = 0;
        this.f_21345_.m_25352_(p++, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(p++, (Goal)new WiltedApproachTargetGoal((Mob)this));
        this.f_21345_.m_25352_(p++, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(p++, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(p++, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, new AdvancedNearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, false, true, true, null));
    }

    public void m_7822_(byte event) {
        if (event == 60) {
            for (int i = 0; i < 50; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0.0, 0.0, 0.0);
            }
        } else {
            super.m_7822_(event);
        }
    }

    protected void m_6153_() {
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6075_() {
        Player player;
        super.m_6075_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        this.facingAngleO = this.facingAngle;
        if (!this.m_9236_().m_5776_() && this.f_19797_ > 20 && this.ownerID != null && !MiscUtils.isEntityValid(this.getOwner())) {
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
        }
        if ((player = this.m_9236_().m_45930_((Entity)this, 100.0)) != null) {
            this.facingAngle = PositionUtils.rotationToFace(this.m_146892_(), player.m_146892_());
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.lifeTime++ > 1200) {
                this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
            }
            if (this.m_9236_().m_46749_(this.m_20183_()) && !this.m_20072_() && this.isBrightEnoughToBurn()) {
                this.m_6469_(this.m_269291_().m_269549_(), 1.0f);
            }
        }
    }

    public void m_7334_(Entity p_21294_) {
    }

    protected void m_7324_(Entity p_20971_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 2.0);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 2.0f;
    }

    public int maxBrightness() {
        ArrayList brightnesses = Lists.newArrayList();
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            brightnesses.add(this.m_9236_().m_45517_(LightLayer.BLOCK, pos));
        }
        brightnesses.sort(Collections.reverseOrder());
        return (Integer)brightnesses.get(0);
    }

    public boolean isBrightEnoughToBurn() {
        return this.maxBrightness() > 10 || this.m_9236_().m_46461_() && this.m_9236_().m_45527_(this.m_20183_());
    }

    protected float m_6121_() {
        return 2.0f;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WiltedNavigation((Mob)this, level);
    }

    protected boolean m_6129_() {
        return false;
    }

    public void m_7601_(BlockState p_20006_, Vec3 p_20007_) {
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188499_() ? (SoundEvent)SoundEventInit.WILTED_STEP.get() : (SoundEvent)SoundEventInit.WILTED_IDLE.get();
    }

    public int m_8100_() {
        return 20;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return null;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundEventInit.WILTED_HURT.get();
    }

    public LivingEntity getOwner() {
        LivingEntity living;
        Entity target = this.ownerID == null || this.m_9236_().m_5776_() ? null : ((ServerLevel)this.m_9236_()).m_8791_(this.ownerID);
        return target instanceof LivingEntity ? (living = (LivingEntity)target) : null;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("OwnerID")) {
            UUID uuid;
            if (tag.m_128403_("OwnerID")) {
                uuid = tag.m_128342_("OwnerID");
            } else {
                String s = tag.m_128461_("OwnerID");
                uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            if (uuid != null) {
                try {
                    this.ownerID = uuid;
                }
                catch (Throwable throwable) {
                    this.ownerID = null;
                }
            }
        }
        if (tag.m_128441_("LifeTime")) {
            this.lifeTime = tag.m_128451_("LifeTime");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.ownerID != null) {
            tag.m_128362_("OwnerID", this.ownerID);
        }
        tag.m_128405_("LifeTime", this.lifeTime);
    }
}

