/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.entities;

import com.alexander.rootoffear.entities.AbstractHurtableEntity;
import com.alexander.rootoffear.entities.ShadowWilted;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.events.LightExtinguisherTrackingEvent;
import com.alexander.rootoffear.init.EntityTypeInit;
import com.alexander.rootoffear.init.ParticleTypeInit;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class LightExtinguisher
extends AbstractHurtableEntity {
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_EXTINGUISHED_POS_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Optional<BlockState>> DATA_EXTINGUISHED_STATE_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Integer> PULLED_ENTITY_ID = SynchedEntityData.m_135353_(Wilted.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState extinguishAnimationState = new AnimationState();
    public AnimationState hurtAnimationState = new AnimationState();
    public boolean foundDirection = false;
    public Direction attachDirection = Direction.UP;
    public CompoundTag extingishedBlockEntityData = null;
    public float darkness = 0.0f;
    public float darknessO = 0.0f;
    public int deadDespawnTimer;
    public UUID ownerID = null;
    public LivingEntity pulledEntity = null;
    public int pull;
    public int pullO;
    public float pullLengthLerp;
    public float pullLengthLerpO;
    public Vec2 facingAngle = Vec2.f_82462_;
    public Vec2 facingAngleO = Vec2.f_82462_;
    public double pullTargetDist;
    public double pullTargetDistO;

    public LightExtinguisher(EntityType<? extends LightExtinguisher> type, Level level) {
        super(type, level);
    }

    public LightExtinguisher(Level level, BlockPos pos, Entity owner) {
        this((EntityType<? extends LightExtinguisher>)((EntityType)EntityTypeInit.LIGHT_EXTINGUISHER.get()), level);
        LivingEntity living;
        this.m_6027_((double)Mth.m_14143_((float)pos.m_123341_()) + 0.5, Mth.m_14143_((float)pos.m_123342_()), (double)Mth.m_14143_((float)pos.m_123343_()) + 0.5);
        if (owner instanceof LivingEntity && MiscUtils.isEntityValid(living = (LivingEntity)owner)) {
            this.ownerID = living.m_20148_();
        }
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 5) {
            for (int i = 0; i < 100; ++i) {
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypeInit.WILTED_BREAK.get(), this.m_20208_(0.85), this.m_20187_(), this.m_20262_(0.85), 0.0, 0.0, 0.0);
            }
            super.m_7822_(event);
        } else if (event == 7) {
            this.extinguishAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(event);
        }
    }

    @Override
    public SoundEvent hurtSound() {
        return (SoundEvent)SoundEventInit.WILTED_SWAY.get();
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 2.0f;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().m_5776_() && this.pulledEntity != null) {
            this.pulledEntity = null;
            this.m_5496_((SoundEvent)SoundEventInit.WILTED_DIG_IN.get(), this.getSoundVolume(), this.getVoicePitch());
        }
        return super.m_6469_(source, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.pull > 200) {
            this.pulledEntity = null;
            this.m_5496_((SoundEvent)SoundEventInit.WILTED_DIG_IN.get(), this.getSoundVolume(), this.getVoicePitch());
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ > 20 && this.ownerID != null && !MiscUtils.isEntityValid(this.getOwner())) {
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
        }
        if (this.m_9236_().m_5776_()) {
            LightExtinguisherTrackingEvent.extinguishers.put(this, this.m_20183_());
            this.darknessO = this.darkness;
            this.darkness = Mth.m_14179_((float)0.2f, (float)this.darkness, (float)(this.getExtinguishedPos().isPresent() ? 0.85f : 0.0f));
        } else if (MiscUtils.inSurvivalMode(this.pulledEntity)) {
            this.setPulledEntityID(this.pulledEntity.m_19879_());
        } else {
            this.setPulledEntityID(0);
        }
        if (MiscUtils.inSurvivalMode(this.getPulledEntity()) && !this.killed) {
            this.pullLengthLerpO = this.pullLengthLerp;
            this.pullLengthLerp = Mth.m_14179_((float)0.3f, (float)this.pullLengthLerp, (float)1.0f);
            this.pullTargetDistO = this.pullTargetDist;
            this.pullTargetDist = this.m_20270_((Entity)this.getPulledEntity());
            this.facingAngleO = this.facingAngle;
            this.facingAngle = PositionUtils.rotationToFace(this.m_146892_(), this.getPulledEntity().m_146892_());
            if (this.pull % 100 == 0) {
                this.m_5496_((SoundEvent)SoundEventInit.WILTED_GROUND_GRAB.get(), this.getSoundVolume(), 1.4f);
            }
            this.pullO = this.pull++;
            double x = this.m_20185_() - this.getPulledEntity().m_20185_();
            double y = this.m_20186_() - this.getPulledEntity().m_20186_();
            double z = this.m_20189_() - this.getPulledEntity().m_20189_();
            double d = Math.max(this.m_20270_((Entity)this.getPulledEntity()), 1.0f);
            this.getPulledEntity().m_20256_(this.getPulledEntity().m_20184_().m_82549_(new Vec3(x / d, y / d, z / d).m_82490_(0.05)));
        } else {
            this.pullLengthLerp = Mth.m_14179_((float)0.3f, (float)this.pullLengthLerp, (float)0.0f);
            this.pull = 0;
        }
        this.m_6027_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, Mth.m_14107_((double)this.m_20186_()), (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
        if (!(this.m_9236_().m_5776_() || this.killed || this.lifeTime <= 20 && !this.getExtinguishedPos().isPresent())) {
            if (this.getExtinguishedPos().isEmpty()) {
                this.extinguish(this.m_20183_());
            } else if (this.getExtinguishedPos().isPresent() && this.m_20183_() != this.getExtinguishedPos().get()) {
                this.replaceExtinguishedBlock();
            } else if (this.getExtinguishedPos().isPresent() && (!this.getExtinguishedState().get().m_60710_((LevelReader)this.m_9236_(), this.getExtinguishedPos().get()) || this.getExtinguishedState().get().m_60795_())) {
                this.m_216990_(this.getExtinguishedState().get().m_60827_().m_56775_());
                this.m_9236_().m_7605_((Entity)this, (byte)5);
                this.m_146870_();
            }
        }
        if (!this.foundDirection) {
            if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_7495_())) {
                this.attachDirection = Direction.UP;
            } else if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_7494_())) {
                this.attachDirection = Direction.DOWN;
            } else if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_122029_())) {
                this.attachDirection = Direction.WEST;
            } else if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_122024_())) {
                this.attachDirection = Direction.EAST;
            } else if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_122012_())) {
                this.attachDirection = Direction.SOUTH;
            } else if (PositionUtils.isBlockCollidable(this.m_9236_(), this.m_20183_().m_122019_())) {
                this.attachDirection = Direction.NORTH;
            }
            this.foundDirection = true;
        }
        if (this.killed) {
            if (this.deadDespawnTimer > 200) {
                this.m_6074_();
            }
            ++this.deadDespawnTimer;
        }
        this.updateHurtable();
    }

    public void setPulledEntityID(int setTo) {
        this.f_19804_.m_135381_(PULLED_ENTITY_ID, (Object)setTo);
    }

    public boolean hasPulledEntity() {
        return (Integer)this.f_19804_.m_135370_(PULLED_ENTITY_ID) != 0;
    }

    @Nullable
    public LivingEntity getPulledEntity() {
        if (!this.hasPulledEntity()) {
            return null;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.pulledEntity != null) {
                return this.pulledEntity;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(PULLED_ENTITY_ID)).intValue());
            if (entity instanceof LivingEntity) {
                this.pulledEntity = (LivingEntity)entity;
                return this.pulledEntity;
            }
            return null;
        }
        return this.pulledEntity;
    }

    public void m_6075_() {
    }

    @Override
    public boolean m_6087_() {
        return !this.m_213877_() && (!this.killed || this.deadDespawnTimer < 10);
    }

    @Override
    public void onKilled() {
        this.m_9236_().m_7605_((Entity)this, (byte)5);
        this.m_5496_((SoundEvent)SoundEventInit.WILTED_STEP.get(), this.getSoundVolume(), this.getVoicePitch() * 4.0f);
        if (this.getExtinguishedPos().isPresent()) {
            this.replaceExtinguishedBlock();
        }
    }

    public boolean m_5829_() {
        return !this.m_213877_() && !this.killed && this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(1.0E-7), entity -> entity instanceof Wilted || entity instanceof ShadowWilted).size() <= 0;
    }

    public void m_6074_() {
        if (!this.m_9236_().m_5776_() && this.getExtinguishedPos().isPresent()) {
            this.replaceExtinguishedBlock();
        }
        super.m_6074_();
    }

    public void extinguish(BlockPos pos) {
        this.setExtinguishedPos(pos);
        this.setExtinguishedState(this.m_9236_().m_8055_(pos));
        if (this.m_9236_().m_7702_(pos) != null) {
            this.extingishedBlockEntityData = this.m_9236_().m_7702_(pos).m_187481_();
        }
        this.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public void replaceExtinguishedBlock() {
        this.m_9236_().m_46597_(this.getExtinguishedPos().get(), this.getExtinguishedState().get());
        if (this.m_9236_().m_7702_(this.getExtinguishedPos().get()) != null) {
            this.m_9236_().m_7702_(this.getExtinguishedPos().get()).m_142466_(this.extingishedBlockEntityData);
            this.m_9236_().m_151543_(this.getExtinguishedPos().get());
        }
        this.setExtinguishedPos(null);
        this.setExtinguishedState(null);
        this.extingishedBlockEntityData = null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_EXTINGUISHED_POS_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_EXTINGUISHED_STATE_ID, Optional.empty());
        this.f_19804_.m_135372_(PULLED_ENTITY_ID, (Object)0);
    }

    public void setExtinguishedPos(BlockPos value) {
        if (value == null) {
            this.f_19804_.m_135381_(DATA_EXTINGUISHED_POS_ID, Optional.empty());
        } else {
            this.f_19804_.m_135381_(DATA_EXTINGUISHED_POS_ID, Optional.of(value));
        }
    }

    public Optional<BlockPos> getExtinguishedPos() {
        return (Optional)this.f_19804_.m_135370_(DATA_EXTINGUISHED_POS_ID);
    }

    public void setExtinguishedState(BlockState value) {
        if (value == null) {
            this.f_19804_.m_135381_(DATA_EXTINGUISHED_STATE_ID, Optional.empty());
        } else {
            this.f_19804_.m_135381_(DATA_EXTINGUISHED_STATE_ID, Optional.of(value));
        }
    }

    public Optional<BlockState> getExtinguishedState() {
        return (Optional)this.f_19804_.m_135370_(DATA_EXTINGUISHED_STATE_ID);
    }

    public LivingEntity getOwner() {
        LivingEntity living;
        Entity target = this.ownerID == null || this.m_9236_().m_5776_() ? null : ((ServerLevel)this.m_9236_()).m_8791_(this.ownerID);
        return target instanceof LivingEntity ? (living = (LivingEntity)target) : null;
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("ExtinguishedPos", 10)) {
            this.setExtinguishedPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("ExtinguishedPos")));
        }
        if (tag.m_128425_("ExtinguishedState", 10)) {
            this.setExtinguishedState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("ExtinguishedState")));
        }
        if (tag.m_128425_("ExtinguishedBlockEntityData", 10)) {
            this.extingishedBlockEntityData = tag.m_128469_("ExtinguishedBlockEntityData");
        }
        if (tag.m_128441_("OwnerID")) {
            UUID uuid;
            if (tag.m_128403_("OwnerID")) {
                uuid = tag.m_128342_("OwnerID");
            } else {
                String s = tag.m_128461_("OwnerID");
                uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
            }
            if (uuid != null) {
                try {
                    this.ownerID = uuid;
                }
                catch (Throwable throwable) {
                    this.ownerID = null;
                }
            }
        }
        if (tag.m_128441_("DeadDespawnTimer")) {
            this.deadDespawnTimer = tag.m_128451_("DeadDespawnTimer");
        }
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getExtinguishedPos().isPresent()) {
            tag.m_128365_("ExtinguishedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getExtinguishedPos().get()));
        }
        if (this.getExtinguishedState().isPresent()) {
            tag.m_128365_("ExtinguishedState", (Tag)NbtUtils.m_129202_((BlockState)this.getExtinguishedState().get()));
        }
        if (this.extingishedBlockEntityData != null) {
            tag.m_128365_("ExtinguishedBlockEntityData", (Tag)this.extingishedBlockEntityData);
        }
        if (this.ownerID != null) {
            tag.m_128362_("OwnerID", this.ownerID);
        }
        tag.m_128405_("DeadDespawnTimer", this.deadDespawnTimer);
    }

    public float m_6143_() {
        return 0.1f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public int maxHits() {
        return 5;
    }

    @Override
    public int hurtCooldown() {
        return 15;
    }

    @Override
    public int maxLifeTime() {
        return 6000;
    }

    @Override
    public AnimationState hurtAnimationState() {
        return this.hurtAnimationState;
    }
}

