/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.ai.goals.wilted;

import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.events.CameraShakeEvents;
import com.alexander.rootoffear.init.SoundEventInit;
import com.alexander.rootoffear.utils.MiscUtils;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class WiltedRevealGoal
extends Goal {
    public Wilted mob;
    public int useTicks;

    public WiltedRevealGoal(Wilted mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.mob = mob;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_8036_() {
        return this.mob.isDisguised() && this.mob.wantsToReveal;
    }

    public boolean m_8045_() {
        return this.useTicks > 0;
    }

    public void m_8056_() {
        this.useTicks = 46;
        this.mob.setDisguised(false);
        this.mob.startAnimation(1);
        this.mob.m_20124_(Pose.SPIN_ATTACK);
        this.mob.m_5496_((SoundEvent)SoundEventInit.WILTED_REVEAL.get(), 5.0f, 1.0f);
        CameraShakeEvents.addCameraShake(this.mob.m_9236_(), 80, 0.25f, this.mob.m_20183_(), 20);
    }

    public void m_8037_() {
        this.mob.m_21573_().m_26573_();
        this.mob.targetMovementSpeed = 0.5;
        Player nearestPlayer = this.mob.m_9236_().m_45930_((Entity)this.mob, 128.0);
        if (MiscUtils.isEntityValid((LivingEntity)nearestPlayer)) {
            this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, nearestPlayer.m_146892_());
        }
        if (this.useTicks > 10 && this.useTicks <= 35) {
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)19);
        }
        if (this.useTicks == 10) {
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)18);
        }
        if (this.useTicks > 0) {
            --this.useTicks;
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_20124_(Pose.STANDING);
    }
}

