/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.rootoffear.ai.goals.wilted;

import com.alexander.rootoffear.entities.ShadowWilted;
import com.alexander.rootoffear.entities.Wilted;
import com.alexander.rootoffear.utils.MiscUtils;
import com.alexander.rootoffear.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LightLayer;

public class WiltedApproachTargetGoal
extends Goal {
    public Mob mob;
    @Nullable
    public LivingEntity target;
    public int tryTime;

    public WiltedApproachTargetGoal(Mob mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
        this.target = mob.m_5448_();
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return MiscUtils.inSurvivalMode(this.target);
    }

    public void m_8056_() {
        super.m_8056_();
        this.tryTime = 0;
    }

    public void m_8037_() {
        this.target = this.mob.m_5448_();
        if (MiscUtils.inSurvivalMode(this.target)) {
            Mob mob = this.mob;
            if (mob instanceof Wilted) {
                Wilted wilted = (Wilted)mob;
                wilted.targetMovementSpeed = 0.7;
            }
            if (this.tryTime >= 300 || this.mob.m_21573_().m_26571_() || this.mob.m_9236_().m_45517_(LightLayer.BLOCK, this.target.m_20183_()) < 3) {
                if ((this.mob.m_142582_((Entity)this.target) || this.mob.m_9236_().m_45517_(LightLayer.BLOCK, this.target.m_20183_()) < 3) && !(this.mob instanceof ShadowWilted)) {
                    this.mob.m_21573_().m_5624_((Entity)this.target, 1.0);
                } else {
                    BlockPos pos = this.findTarget();
                    if (pos != null) {
                        this.mob.m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0);
                    }
                }
                this.tryTime = 0;
            }
        }
        ++this.tryTime;
    }

    public BlockPos findTarget() {
        ArrayList validPositions = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = this.target.m_20183_().m_7918_((int)(this.mob.m_217043_().m_188583_() * 10.0), 0, (int)(this.mob.m_217043_().m_188583_() * 10.0));
            if (pos == null || this.mob.m_9236_().m_45517_(LightLayer.BLOCK, pos) >= 3) continue;
            validPositions.add(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        }
        if (validPositions.size() > 0) {
            Collections.shuffle(validPositions);
            Collections.sort(validPositions, PositionUtils.distanceComparator(this.mob.m_20183_()));
            return (BlockPos)validPositions.get(validPositions.size() - 1);
        }
        return null;
    }
}

