/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.loot.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class LootCollection {
    public Map<String, Float> entries;
    private Consumer<LootCollection> applicator;

    public static LootCollectionBuilder builder() {
        return new LootCollectionBuilder(){

            @Override
            public LootCollection build() {
                LootCollection info = super.build();
                info.getApplicator().accept(info);
                return info;
            }
        };
    }

    private static Consumer<LootCollection> $default$applicator() {
        return builder -> {};
    }

    public Map<String, Float> getEntries() {
        return this.entries;
    }

    public Consumer<LootCollection> getApplicator() {
        return this.applicator;
    }

    public void setEntries(Map<String, Float> entries) {
        this.entries = entries;
    }

    public void setApplicator(Consumer<LootCollection> applicator) {
        this.applicator = applicator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootCollection)) {
            return false;
        }
        LootCollection other = (LootCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Float> this$entries = this.getEntries();
        Map<String, Float> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        Consumer<LootCollection> this$applicator = this.getApplicator();
        Consumer<LootCollection> other$applicator = other.getApplicator();
        return !(this$applicator == null ? other$applicator != null : !this$applicator.equals(other$applicator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootCollection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Float> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        Consumer<LootCollection> $applicator = this.getApplicator();
        result = result * 59 + ($applicator == null ? 43 : $applicator.hashCode());
        return result;
    }

    public String toString() {
        return "LootCollection(entries=" + String.valueOf(this.getEntries()) + ", applicator=" + String.valueOf(this.getApplicator()) + ")";
    }

    public LootCollection(Map<String, Float> entries, Consumer<LootCollection> applicator) {
        this.entries = entries;
        this.applicator = applicator;
    }

    public static class LootCollectionBuilder {
        private boolean applicator$set;
        private Consumer<LootCollection> applicator$value;
        public Map<String, Float> entries = new HashMap<String, Float>();

        public LootCollectionBuilder entry(String lootId, float chance) {
            this.entries.put(lootId, Float.valueOf(chance));
            return this;
        }

        public LootCollectionBuilder entry(LootCollection collection) {
            this.entries.putAll(collection.getEntries());
            return this;
        }

        public LootCollectionBuilder entry(String ... lootIds) {
            for (String lotId : lootIds) {
                this.entries.put(lotId, Float.valueOf(0.0f));
            }
            return this;
        }

        LootCollectionBuilder() {
        }

        public LootCollectionBuilder entries(Map<String, Float> entries) {
            this.entries = entries;
            return this;
        }

        public LootCollectionBuilder applicator(Consumer<LootCollection> applicator) {
            this.applicator$value = applicator;
            this.applicator$set = true;
            return this;
        }

        public LootCollection build() {
            Consumer<LootCollection> applicator$value = this.applicator$value;
            if (!this.applicator$set) {
                applicator$value = LootCollection.$default$applicator();
            }
            return new LootCollection(this.entries, applicator$value);
        }

        public String toString() {
            return "LootCollection.LootCollectionBuilder(entries=" + String.valueOf(this.entries) + ", applicator$value=" + String.valueOf(this.applicator$value) + ")";
        }
    }
}

